// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --check-globals all --filter-out-after "getelem.*kernel" --filter-out "= alloca.*" --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _ --global-value-regex "\.offload_.*" --global-hex-value-regex ".offload_maptypes.*" --version 5
// RUN: %clang_cc1 -verify -fopenmp -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | FileCheck %s
// RUN: %clang_cc1 -fopenmp -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -triple powerpc64le-unknown-unknown -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s

// expected-no-diagnostics
#ifndef HEADER
#define HEADER

struct S {
  short x;
  int y;
  int *p;
};

S s, *ps;

void f1() {
  // &ps, &ps, sizeof(ps), TO | PARAM
  #pragma omp target map(to: ps)
    ps->y = 5;
}

void f2() {
  // &ps[0], &ps->y, sizeof(ps->y), TO | PARAM
  // &ps,    &ps->y, sizeof(ps),    ATTACH
  #pragma omp target map(to: ps->y)
    ps->y = 6;
}

void f3() {
  // &ps,    &ps,    sizeof(ps),    TO | PARAM
  // &ps[0], &ps->y, sizeof(ps->y), TO
  // &ps,    &ps->y, sizeof(ps),    ATTACH
  #pragma omp target map(to: ps, ps->y)
    ps->y = 7;
}

void f4() {
  // &ps,    &ps,    sizeof(ps),    TO | PARAM
  // &ps[0], &ps->y, sizeof(ps->y), TO
  // &ps,    &ps->y, sizeof(ps),    ATTACH
  #pragma omp target map(to: ps->y, ps)
    ps->y = 8;
}

void f5() {
  // &ps,    &ps,      sizeof(ps),                    TO | PARAM
  // &ps[0], &ps[0].x, ((&ps[0].y + 1) - &ps[0].x)/8, ALLOC
  // &ps[0], &ps->y,   sizeof(ps->y),                 TO | MEMBER_OF(2)
  // &ps[0], &ps->x,   sizeof(ps->x),                 TO | MEMBER_OF(2)
  // &ps,    &ps[0].x, sizeof(ps),                    ATTACH
  #pragma omp target map(to: ps->y, ps, ps->x)
    ps->y = 9;
}

#endif
//.
// CHECK: @.offload_sizes = private unnamed_addr constant [1 x i64] [i64 8]
// CHECK: @.offload_maptypes = private unnamed_addr constant [1 x i64] [i64 [[#0x21]]]
// CHECK: @.offload_sizes.1 = private unnamed_addr constant [2 x i64] [i64 4, i64 8]
// CHECK: @.offload_maptypes.2 = private unnamed_addr constant [2 x i64] [i64 [[#0x21]], i64 [[#0x4000]]]
// CHECK: @.offload_sizes.3 = private unnamed_addr constant [3 x i64] [i64 8, i64 4, i64 8]
// CHECK: @.offload_maptypes.4 = private unnamed_addr constant [3 x i64] [i64 [[#0x21]], i64 [[#0x1]], i64 [[#0x4000]]]
// CHECK: @.offload_sizes.5 = private unnamed_addr constant [3 x i64] [i64 8, i64 4, i64 8]
// CHECK: @.offload_maptypes.6 = private unnamed_addr constant [3 x i64] [i64 [[#0x21]], i64 [[#0x1]], i64 [[#0x4000]]]
// CHECK: @.offload_sizes.7 = private unnamed_addr constant [5 x i64] [i64 8, i64 0, i64 4, i64 2, i64 8]
// CHECK: @.offload_maptypes.8 = private unnamed_addr constant [5 x i64] [i64 [[#0x21]], i64 [[#0x0]], i64 [[#0x2000000000001]], i64 [[#0x2000000000001]], i64 [[#0x4000]]]
//.
// CHECK-LABEL: define dso_local void @_Z2f1v(
// CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    [[TMP0:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr @ps, ptr [[TMP0]], align 8
// CHECK:    [[TMP1:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr @ps, ptr [[TMP1]], align 8
// CHECK:    [[TMP2:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS:%.*]], i64 0, i64 0
// CHECK:    store ptr null, ptr [[TMP2]], align 8
// CHECK:    [[TMP3:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK:    [[TMP5:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], ptr [[KERNEL_ARGS:%.*]], i32 0, i32 0
//
//
// CHECK-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z2f1v_l20(
// CHECK-SAME: ptr noundef nonnull align 8 dereferenceable(8) [[PS:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    store ptr [[PS]], ptr [[PS_ADDR:%.*]], align 8
// CHECK:    [[TMP0:%.*]] = load ptr, ptr [[PS_ADDR]], align 8, !nonnull [[META13:![0-9]+]], !align [[META14:![0-9]+]]
// CHECK:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK:    [[Y:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK:    store i32 5, ptr [[Y]], align 4
// CHECK:    ret void
//
//
// CHECK-LABEL: define dso_local void @_Z2f2v(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    [[TMP0:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[TMP1:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[TMP2:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[Y:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[TMP2]], i32 0, i32 1
// CHECK:    [[TMP3:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr [[TMP1]], ptr [[TMP3]], align 8
// CHECK:    [[TMP4:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr [[Y]], ptr [[TMP4]], align 8
// CHECK:    [[TMP5:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS:%.*]], i64 0, i64 0
// CHECK:    store ptr null, ptr [[TMP5]], align 8
// CHECK:    [[TMP6:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK:    store ptr @ps, ptr [[TMP6]], align 8
// CHECK:    [[TMP7:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK:    store ptr [[Y]], ptr [[TMP7]], align 8
// CHECK:    [[TMP8:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK:    store ptr null, ptr [[TMP8]], align 8
// CHECK:    [[TMP9:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK:    [[TMP10:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK:    [[TMP11:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], ptr [[KERNEL_ARGS:%.*]], i32 0, i32 0
//
//
// CHECK-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z2f2v_l27(
// CHECK-SAME: ptr noundef [[PS:%.*]]) #[[ATTR1]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    store ptr [[PS]], ptr [[PS_ADDR:%.*]], align 8
// CHECK:    [[TMP0:%.*]] = load ptr, ptr [[PS_ADDR]], align 8
// CHECK:    [[Y:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[TMP0]], i32 0, i32 1
// CHECK:    store i32 6, ptr [[Y]], align 4
// CHECK:    ret void
//
//
// CHECK-LABEL: define dso_local void @_Z2f3v(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    [[TMP0:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[TMP1:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[Y:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK:    [[TMP2:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr @ps, ptr [[TMP2]], align 8
// CHECK:    [[TMP3:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr @ps, ptr [[TMP3]], align 8
// CHECK:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS:%.*]], i64 0, i64 0
// CHECK:    store ptr null, ptr [[TMP4]], align 8
// CHECK:    [[TMP5:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK:    store ptr [[TMP0]], ptr [[TMP5]], align 8
// CHECK:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK:    store ptr [[Y]], ptr [[TMP6]], align 8
// CHECK:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK:    store ptr null, ptr [[TMP7]], align 8
// CHECK:    [[TMP8:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK:    store ptr @ps, ptr [[TMP8]], align 8
// CHECK:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK:    store ptr [[Y]], ptr [[TMP9]], align 8
// CHECK:    [[TMP10:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK:    store ptr null, ptr [[TMP10]], align 8
// CHECK:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK:    [[TMP13:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], ptr [[KERNEL_ARGS:%.*]], i32 0, i32 0
//
//
// CHECK-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z2f3v_l35(
// CHECK-SAME: ptr noundef nonnull align 8 dereferenceable(8) [[PS:%.*]]) #[[ATTR1]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    store ptr [[PS]], ptr [[PS_ADDR:%.*]], align 8
// CHECK:    [[TMP0:%.*]] = load ptr, ptr [[PS_ADDR]], align 8, !nonnull [[META13]], !align [[META14]]
// CHECK:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK:    [[Y:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK:    store i32 7, ptr [[Y]], align 4
// CHECK:    ret void
//
//
// CHECK-LABEL: define dso_local void @_Z2f4v(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    [[TMP0:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[TMP1:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[Y:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK:    [[TMP2:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr @ps, ptr [[TMP2]], align 8
// CHECK:    [[TMP3:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr @ps, ptr [[TMP3]], align 8
// CHECK:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS:%.*]], i64 0, i64 0
// CHECK:    store ptr null, ptr [[TMP4]], align 8
// CHECK:    [[TMP5:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK:    store ptr [[TMP0]], ptr [[TMP5]], align 8
// CHECK:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK:    store ptr [[Y]], ptr [[TMP6]], align 8
// CHECK:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK:    store ptr null, ptr [[TMP7]], align 8
// CHECK:    [[TMP8:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK:    store ptr @ps, ptr [[TMP8]], align 8
// CHECK:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK:    store ptr [[Y]], ptr [[TMP9]], align 8
// CHECK:    [[TMP10:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK:    store ptr null, ptr [[TMP10]], align 8
// CHECK:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK:    [[TMP13:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], ptr [[KERNEL_ARGS:%.*]], i32 0, i32 0
//
//
// CHECK-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z2f4v_l43(
// CHECK-SAME: ptr noundef nonnull align 8 dereferenceable(8) [[PS:%.*]]) #[[ATTR1]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    store ptr [[PS]], ptr [[PS_ADDR:%.*]], align 8
// CHECK:    [[TMP0:%.*]] = load ptr, ptr [[PS_ADDR]], align 8, !nonnull [[META13]], !align [[META14]]
// CHECK:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK:    [[Y:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK:    store i32 8, ptr [[Y]], align 4
// CHECK:    ret void
//
//
// CHECK-LABEL: define dso_local void @_Z2f5v(
// CHECK-SAME: ) #[[ATTR0]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    [[TMP0:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[TMP1:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[Y:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK:    [[TMP2:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[TMP3:%.*]] = load ptr, ptr @ps, align 8
// CHECK:    [[X:%.*]] = getelementptr inbounds nuw [[STRUCT_S]], ptr [[TMP3]], i32 0, i32 0
// CHECK:    [[TMP4:%.*]] = getelementptr i32, ptr [[Y]], i32 1
// CHECK:    [[TMP5:%.*]] = ptrtoint ptr [[TMP4]] to i64
// CHECK:    [[TMP6:%.*]] = ptrtoint ptr [[X]] to i64
// CHECK:    [[TMP7:%.*]] = sub i64 [[TMP5]], [[TMP6]]
// CHECK:    [[TMP8:%.*]] = sdiv exact i64 [[TMP7]], ptrtoint (ptr getelementptr (i8, ptr null, i32 1) to i64)
// CHECK:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[DOTOFFLOAD_SIZES:%.*]], ptr align 8 @.offload_sizes.7, i64 40, i1 false)
// CHECK:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr @ps, ptr [[TMP9]], align 8
// CHECK:    [[TMP10:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS:%.*]], i32 0, i32 0
// CHECK:    store ptr @ps, ptr [[TMP10]], align 8
// CHECK:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS:%.*]], i64 0, i64 0
// CHECK:    store ptr null, ptr [[TMP11]], align 8
// CHECK:    [[TMP12:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK:    store ptr [[TMP0]], ptr [[TMP12]], align 8
// CHECK:    [[TMP13:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK:    store ptr [[X]], ptr [[TMP13]], align 8
// CHECK:    [[TMP14:%.*]] = getelementptr inbounds [5 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK:    store i64 [[TMP8]], ptr [[TMP14]], align 8
// CHECK:    [[TMP15:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK:    store ptr null, ptr [[TMP15]], align 8
// CHECK:    [[TMP16:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK:    store ptr [[TMP0]], ptr [[TMP16]], align 8
// CHECK:    [[TMP17:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK:    store ptr [[Y]], ptr [[TMP17]], align 8
// CHECK:    [[TMP18:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK:    store ptr null, ptr [[TMP18]], align 8
// CHECK:    [[TMP19:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK:    store ptr [[TMP2]], ptr [[TMP19]], align 8
// CHECK:    [[TMP20:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK:    store ptr [[X]], ptr [[TMP20]], align 8
// CHECK:    [[TMP21:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK:    store ptr null, ptr [[TMP21]], align 8
// CHECK:    [[TMP22:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK:    store ptr @ps, ptr [[TMP22]], align 8
// CHECK:    [[TMP23:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK:    store ptr [[X]], ptr [[TMP23]], align 8
// CHECK:    [[TMP24:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK:    store ptr null, ptr [[TMP24]], align 8
// CHECK:    [[TMP25:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK:    [[TMP26:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK:    [[TMP27:%.*]] = getelementptr inbounds [5 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK:    [[TMP28:%.*]] = getelementptr inbounds nuw [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], ptr [[KERNEL_ARGS:%.*]], i32 0, i32 0
//
//
// CHECK-LABEL: define internal void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z2f5v_l53(
// CHECK-SAME: ptr noundef nonnull align 8 dereferenceable(8) [[PS:%.*]]) #[[ATTR1]] {
// CHECK:  [[ENTRY:.*:]]
// CHECK:    store ptr [[PS]], ptr [[PS_ADDR:%.*]], align 8
// CHECK:    [[TMP0:%.*]] = load ptr, ptr [[PS_ADDR]], align 8, !nonnull [[META13]], !align [[META14]]
// CHECK:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK:    [[Y:%.*]] = getelementptr inbounds nuw [[STRUCT_S:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK:    store i32 9, ptr [[Y]], align 4
// CHECK:    ret void
//
