# Changelog 0.3.x

## 0.3.0

This release introduces the uv [project](https://docs.astral.sh/uv/guides/projects/),
[tool](https://docs.astral.sh/uv/guides/tools/),
[script](https://docs.astral.sh/uv/guides/scripts/), and
[python](https://docs.astral.sh/uv/guides/install-python/) interfaces. If you've been following uv's
development, you've probably seen these new commands behind a preview flag. Now, the interfaces are
stable and ready for production-use.

These features are all documented in [new, comprehensive documentation](https://docs.astral.sh/uv/).

This release also stabilizes preview functionality in `uv venv`:

- `uv venv --python <version>` will
  [automatically download](https://docs.astral.sh/uv/concepts/python-versions/#requesting-a-version)
  the Python version if required
- `uv venv` will read the required Python version from the `.python-version` file or
  `pyproject.toml`

The `uv pip` interface should not be affected by any breaking changes.

Note the following changelog entries does not include all the new features since they were added
incrementally as preview features. See the
[feature page](https://docs.astral.sh/uv/getting-started/features/) in the documentation for a
comprehensive listing, or read the [blog post](https://astral.sh/blog/uv-unified-python-packaging)
for more context on the new features.

### Breaking changes

- Migrate to XDG and Linux strategy for macOS directories
  ([#5806](https://github.com/astral-sh/uv/pull/5806))
- Move concurrency settings to top-level ([#4257](https://github.com/astral-sh/uv/pull/4257))
- Apply system Python filtering to executable name requests
  ([#4309](https://github.com/astral-sh/uv/pull/4309))
- Remove `--legacy-setup-py` command-line argument
  ([#4255](https://github.com/astral-sh/uv/pull/4255))
- Stabilize preview features ([#6166](https://github.com/astral-sh/uv/pull/6166))

### Enhancements

- Add 32-bit Windows target ([#6252](https://github.com/astral-sh/uv/pull/6252))
- Add support for `python_version in ...` markers
  ([#6172](https://github.com/astral-sh/uv/pull/6172))
- Allow user to constrain supported lock environments
  ([#6210](https://github.com/astral-sh/uv/pull/6210))
- Lift requirement that .egg-info filenames must include version
  ([#6179](https://github.com/astral-sh/uv/pull/6179))
- Change "any of" to "all of" in error messages ([#6222](https://github.com/astral-sh/uv/pull/6222))
- Collapse redundant dependency clauses enumerating available versions
  ([#6160](https://github.com/astral-sh/uv/pull/6160))
- Collapse unavailable packages in resolver errors
  ([#6154](https://github.com/astral-sh/uv/pull/6154))
- Fix messages for unavailable packages when range is plural
  ([#6221](https://github.com/astral-sh/uv/pull/6221))
- Improve resolver error messages when `--offline` is used
  ([#6156](https://github.com/astral-sh/uv/pull/6156))
- Avoid overwriting dependencies with different markers in `uv add`
  ([#6010](https://github.com/astral-sh/uv/pull/6010))
- Simplify available package version ranges when the name includes markers or extras
  ([#6162](https://github.com/astral-sh/uv/pull/6162))
- Simplify version ranges reported for unavailable packages
  ([#6155](https://github.com/astral-sh/uv/pull/6155))
- Rename `environment-markers` to `resolution-markers`
  ([#6240](https://github.com/astral-sh/uv/pull/6240))
- Support `uv add -r requirements.txt` ([#6005](https://github.com/astral-sh/uv/pull/6005))

### CLI

- Hide global options in `uv generate-shell-completion`
  ([#6170](https://github.com/astral-sh/uv/pull/6170))
- Show generate-shell-completion command in `uv help`
  ([#6180](https://github.com/astral-sh/uv/pull/6180))
- Special-case reinstalls in environment update summaries
  ([#6243](https://github.com/astral-sh/uv/pull/6243))
- Add output when `uv add` and `uv remove` update scripts
  ([#6231](https://github.com/astral-sh/uv/pull/6231))
- Add support for `package@latest` in `tool run`
  ([#6138](https://github.com/astral-sh/uv/pull/6138))
- Show `python find` output with `-q` ([#6256](https://github.com/astral-sh/uv/pull/6256))
- Warn when `--upgrade` is passed to `tool run` ([#6140](https://github.com/astral-sh/uv/pull/6140))

### Configuration

- Allow customizing the tool install directory with `UV_TOOL_BIN_DIR`
  ([#6207](https://github.com/astral-sh/uv/pull/6207))

### Performance

- Use `FxHash` in `uv-auth` ([#6149](https://github.com/astral-sh/uv/pull/6149))

### Bug fixes

- Avoid panicking when the resolver thread encounters a closed channel
  ([#6182](https://github.com/astral-sh/uv/pull/6182))
- Respect release-only semantics of `python_full_version` when constructing markers
  ([#6171](https://github.com/astral-sh/uv/pull/6171))
- Tolerate missing `[project]` table in `uv venv`
  ([#6178](https://github.com/astral-sh/uv/pull/6178))
- Avoid using workspace `lock_path` as relative root
  ([#6157](https://github.com/astral-sh/uv/pull/6157))

### Documentation

- Preview changes are now included in the standard changelog
  ([#6259](https://github.com/astral-sh/uv/pull/6259))
- Document dynamic metadata behavior for cache ([#5993](https://github.com/astral-sh/uv/pull/5993))
- Document the effect of ordering on package priority
  ([#6211](https://github.com/astral-sh/uv/pull/6211))
- Make some edits to the workspace concept documentation
  ([#6223](https://github.com/astral-sh/uv/pull/6223))
- Update environment variables doc ([#5994](https://github.com/astral-sh/uv/pull/5994))
- Disable collapsible navigation in the documentation
  ([#5674](https://github.com/astral-sh/uv/pull/5674))
- Document `uv add` and `uv remove` behavior with markers
  ([#6163](https://github.com/astral-sh/uv/pull/6163))
- Document the Python installation directory ([#6227](https://github.com/astral-sh/uv/pull/6227))
- Document the `uv.pip` section semantics ([#6225](https://github.com/astral-sh/uv/pull/6225))
- Document the cache directory ([#6229](https://github.com/astral-sh/uv/pull/6229))
- Document the tools directory ([#6228](https://github.com/astral-sh/uv/pull/6228))
- Document yanked packages caveat during sync ([#6219](https://github.com/astral-sh/uv/pull/6219))
- Link to persistent configuration options in Python versions document
  ([#6226](https://github.com/astral-sh/uv/pull/6226))
- Link to the projects concept from the dependencies concept
  ([#6224](https://github.com/astral-sh/uv/pull/6224))
- Improvements to the Docker installation guide ([#6216](https://github.com/astral-sh/uv/pull/6216))
- Increase the size of navigation entries ([#6233](https://github.com/astral-sh/uv/pull/6233))
- Install `ca-certificates` in docker and use pipefail
  ([#6208](https://github.com/astral-sh/uv/pull/6208))
- Add script support to feature highlights in index
  ([#6251](https://github.com/astral-sh/uv/pull/6251))
- Show `uv generate-shell-completion` in CLI documentation reference
  ([#6146](https://github.com/astral-sh/uv/pull/6146))
- Update Docker guide for projects ([#6217](https://github.com/astral-sh/uv/pull/6217))
- Use `uv add --script` in guide ([#6215](https://github.com/astral-sh/uv/pull/6215))
- Show pinned version example on in GitHub Actions integration guide
  ([#6234](https://github.com/astral-sh/uv/pull/6234))

<!-- prettier-ignore-end -->

## 0.3.1

### Enhancements

- Add `--with-editable` support to `uv run` ([#6262](https://github.com/astral-sh/uv/pull/6262))
- Respect `.python-version` files and `pyproject.toml` in `uv python find`
  ([#6369](https://github.com/astral-sh/uv/pull/6369))
- Allow manylinux compatibility override via `_manylinux` module
  ([#6039](https://github.com/astral-sh/uv/pull/6039))

### CLI

- Avoid treating `uv add -r` as `--raw-sources` ([#6287](https://github.com/astral-sh/uv/pull/6287))

### Bug fixes

- Always invoke found interpreter when `uv run python` is used
  ([#6363](https://github.com/astral-sh/uv/pull/6363))
- Avoid adding extra newline for script with non-empty prelude
  ([#6366](https://github.com/astral-sh/uv/pull/6366))
- Fix metadata cache instability for lockfile ([#6332](https://github.com/astral-sh/uv/pull/6332))
- Handle Ctrl-C properly in `uvx` invocations ([#6346](https://github.com/astral-sh/uv/pull/6346))
- Ignore workspace discovery errors with `--no-workspace`
  ([#6328](https://github.com/astral-sh/uv/pull/6328))
- Invalidate `uv.lock` when virtual `dev-dependencies` change
  ([#6291](https://github.com/astral-sh/uv/pull/6291))
- Make cache robust to removed archives ([#6284](https://github.com/astral-sh/uv/pull/6284))
- Preserve Git username for SSH dependencies ([#6335](https://github.com/astral-sh/uv/pull/6335))
- Respect `--no-build-isolation` in `uv add` ([#6368](https://github.com/astral-sh/uv/pull/6368))
- Respect `.python-version` files in `uv run` outside projects
  ([#6361](https://github.com/astral-sh/uv/pull/6361))
- Use `sys_executable` for `uv run` invocations ([#6354](https://github.com/astral-sh/uv/pull/6354))
- Use atomic write for `pip compile` output ([#6274](https://github.com/astral-sh/uv/pull/6274))
- Use consistent logic for deserializing short revisions
  ([#6341](https://github.com/astral-sh/uv/pull/6341))

### Documentation

- Remove the preview default value of `python-preference`
  ([#6301](https://github.com/astral-sh/uv/pull/6301))
- Update env vars doc about `XDG_*` variables on macOS
  ([#6337](https://github.com/astral-sh/uv/pull/6337))

## 0.3.2

### Configuration

- Add support for configuring `python-downloads` with `UV_PYTHON_DOWNLOADS`
  ([#6436](https://github.com/astral-sh/uv/pull/6436))
- Add support for configuring the `python-preference` with `UV_PYTHON_PREFERENCE`
  ([#6432](https://github.com/astral-sh/uv/pull/6432))
- Deny invalid members in workspace schema ([#6450](https://github.com/astral-sh/uv/pull/6450))

### Performance

- Stop streaming wheels when `METADATA` is discovered (if range requests aren't supported)
  ([#6470](https://github.com/astral-sh/uv/pull/6470))

### Bug fixes

- Remove URI type from JSON Schema ([#6449](https://github.com/astral-sh/uv/pull/6449))
- Fix retrieval of credentials for URLs from cache
  ([#6452](https://github.com/astral-sh/uv/pull/6452))
- Restore `cache` suffix on Windows cache path ([#6482](https://github.com/astral-sh/uv/pull/6482))
- Treat `.pyw` files as scripts in `uv run` on Windows
  ([#6453](https://github.com/astral-sh/uv/pull/6453))
- Treat invalid extras as `false` in marker evaluation
  ([#6395](https://github.com/astral-sh/uv/pull/6395))
- Avoid overwriting symlinks in `pip compile` output
  ([#6487](https://github.com/astral-sh/uv/pull/6487))

### Documentation

- Add `uv run` hint to the `uvx` guide ([#6454](https://github.com/astral-sh/uv/pull/6454))
- Add a guide for using uv with FastAPI ([#6401](https://github.com/astral-sh/uv/pull/6401))
- Add tip for using `managed = false` to disable project management
  ([#6465](https://github.com/astral-sh/uv/pull/6465))
- Clarify the `uv tool run`, `uvx`, and `uv run` relationships
  ([#6455](https://github.com/astral-sh/uv/pull/6455))
- Fix references to `--python-downloads` (it is `--no-python-downloads`)
  ([#6439](https://github.com/astral-sh/uv/pull/6439))
- Further clarifications to the tools documentation
  ([#6474](https://github.com/astral-sh/uv/pull/6474))
- Update docs dockerfile (bullseye -> bookworm) ([#6441](https://github.com/astral-sh/uv/pull/6441))
- Update the installation documentation page ([#6468](https://github.com/astral-sh/uv/pull/6468))
- Update pip compatibility pages to mention configuration files support
  ([#6410](https://github.com/astral-sh/uv/pull/6410))
- Add `uv run` docs for gui scripts ([#6478](https://github.com/astral-sh/uv/pull/6478))

## 0.3.3

### Enhancements

- Add `uv sync --no-install-project` to skip installation of the project
  ([#6538](https://github.com/astral-sh/uv/pull/6538))
- Add `uv sync --no-install-workspace` to skip installation of all workspace members
  ([#6539](https://github.com/astral-sh/uv/pull/6539))
- Add `uv sync --no-install-package` to skip installation of specific packages
  ([#6540](https://github.com/astral-sh/uv/pull/6540))
- Show previous version in self update message ([#6473](https://github.com/astral-sh/uv/pull/6473))

### CLI

- Add `--no-project` alias for `uv python pin --no-workspace`
  ([#6514](https://github.com/astral-sh/uv/pull/6514))
- Ignore `.python-version` files in `uv venv` with `--no-config`
  ([#6513](https://github.com/astral-sh/uv/pull/6513))
- Include virtual environment interpreters in `uv python find`
  ([#6521](https://github.com/astral-sh/uv/pull/6521))
- Respect `-` as stdin channel for `uv run` ([#6481](https://github.com/astral-sh/uv/pull/6481))
- Revert changes to pyproject.toml when sync fails during `uv add`
  ([#6526](https://github.com/astral-sh/uv/pull/6526))

### Configuration

- Add `UV_COMPILE_BYTECODE` environment variable
  ([#6530](https://github.com/astral-sh/uv/pull/6530))

### Bug fixes

- Set `VIRTUAL_ENV` for `uv run` invocations ([#6543](https://github.com/astral-sh/uv/pull/6543))
- Ignore errors in workspace discovery with `--no-project`
  ([#6554](https://github.com/astral-sh/uv/pull/6554))

### Documentation

- Add documentation for `uv python find` ([#6527](https://github.com/astral-sh/uv/pull/6527))
- Add uv tool install example in Docker ([#6547](https://github.com/astral-sh/uv/pull/6547))
- Document why we do lower bounds ([#6516](https://github.com/astral-sh/uv/pull/6516))
- Fix to miss string termination in PowerShell commands for shell autocompletion documentation
  ([#6491](https://github.com/astral-sh/uv/pull/6491))
- Fix incorrect workspace members keyword ([#6502](https://github.com/astral-sh/uv/pull/6502))
- Use proper environment variables for Windows ([#6433](https://github.com/astral-sh/uv/pull/6433))
- Improve caveat in `uvx` note ([#6546](https://github.com/astral-sh/uv/pull/6546))

## 0.3.4

### CLI

- Show `--editable` on the `uv add` CLI ([#6608](https://github.com/astral-sh/uv/pull/6608))
- Add `--refresh` to `tool run` warning for `--with` dependencies
  ([#6609](https://github.com/astral-sh/uv/pull/6609))

### Bug fixes

- Allow per dependency build isolation for `setup.py`-based projects
  ([#6517](https://github.com/astral-sh/uv/pull/6517))
- Avoid un-strict syncing by-default for build isolation
  ([#6606](https://github.com/astral-sh/uv/pull/6606))
- Respect `--no-build-isolation-package` in `uv sync`
  ([#6605](https://github.com/astral-sh/uv/pull/6605))
- Respect extras and markers on virtual dev dependencies
  ([#6620](https://github.com/astral-sh/uv/pull/6620))
- Support PEP 723 scripts in GUI files ([#6611](https://github.com/astral-sh/uv/pull/6611))
- Update lockfile after setting minimum bounds in `uv add`
  ([#6618](https://github.com/astral-sh/uv/pull/6618))
- Use relative paths for `--find-links` and local registries
  ([#6566](https://github.com/astral-sh/uv/pull/6566))
- Use separate types to represent raw vs. resolver markers
  ([#6646](https://github.com/astral-sh/uv/pull/6646))
- Parse wheels `WHEEL` and `METADATA` files as email messages
  ([#6616](https://github.com/astral-sh/uv/pull/6616))
- Support unquoted hrefs in `--find-links` and other HTML sources
  ([#6622](https://github.com/astral-sh/uv/pull/6622))
- Don't canonicalize paths to user requirements ([#6560](https://github.com/astral-sh/uv/pull/6560))

### Documentation

- Add FastAPI guide to overview ([#6603](https://github.com/astral-sh/uv/pull/6603))
- Add docs for disabling build isolation with `uv sync`
  ([#6607](https://github.com/astral-sh/uv/pull/6607))
- Add example of reading script from stdin using echo
  ([#6567](https://github.com/astral-sh/uv/pull/6567))
- Add tip to use intermediate layers in Docker builds
  ([#6650](https://github.com/astral-sh/uv/pull/6650))
- Clarify need to include `pyproject.toml` with `--no-install-project`
  ([#6581](https://github.com/astral-sh/uv/pull/6581))
- Move `WORKDIR` directive in Docker examples ([#6652](https://github.com/astral-sh/uv/pull/6652))
- Remove duplicate `WORKDIR` directive in Docker example
  ([#6651](https://github.com/astral-sh/uv/pull/6651))

## 0.3.5

### Enhancements

- Add support for `--allow-insecure-host` (aliased to `--trusted-host`)
  ([#6591](https://github.com/astral-sh/uv/pull/6591))
- Read requirements from `requires.txt` when available
  ([#6655](https://github.com/astral-sh/uv/pull/6655))
- Respect `tool.uv.environments` in `pip compile --universal`
  ([#6663](https://github.com/astral-sh/uv/pull/6663))
- Use relative paths by default in `uv add` ([#6686](https://github.com/astral-sh/uv/pull/6686))
- Improve messages for empty solves and installs
  ([#6588](https://github.com/astral-sh/uv/pull/6588))

### Bug fixes

- Avoid reusing state across tool upgrades ([#6660](https://github.com/astral-sh/uv/pull/6660))
- Detect musl and error for musl Python builds ([#6643](https://github.com/astral-sh/uv/pull/6643))
- Ignore `send` errors in installer ([#6667](https://github.com/astral-sh/uv/pull/6667))

### Documentation

- Add development section to Docker guide and reference new example project
  ([#6666](https://github.com/astral-sh/uv/pull/6666))
- Add docs for `constraint-dependencies` and `override-dependencies`
  ([#6596](https://github.com/astral-sh/uv/pull/6596))
- Clarify package priority order in pip compatibility guide
  ([#6619](https://github.com/astral-sh/uv/pull/6619))
- Fix docs for disabling build isolation with `uv sync`
  ([#6674](https://github.com/astral-sh/uv/pull/6674))
- Improve consistency of directory lookup instructions in Docker
  ([#6665](https://github.com/astral-sh/uv/pull/6665))
- Improve lockfile concept documentation, add coverage for upgrades
  ([#6698](https://github.com/astral-sh/uv/pull/6698))
- Shift the order of some of the Docker guide content
  ([#6664](https://github.com/astral-sh/uv/pull/6664))
- Use `python` to highlight requirements and use more content tabs
  ([#6549](https://github.com/astral-sh/uv/pull/6549))
