/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;

public class CompoundBorder
extends AbstractBorder {
    protected Border inner;
    protected Border outer;

    public CompoundBorder() {
    }

    public CompoundBorder(Border outer, Border inner) {
        this.outer = outer;
        this.inner = inner;
    }

    public Border getInnerBorder() {
        return this.inner;
    }

    @Override
    public Insets getInsets(IFigure figure) {
        Insets insets = null;
        insets = this.inner != null ? this.inner.getInsets(figure) : new Insets();
        if (this.outer != null) {
            Insets moreInsets = this.outer.getInsets(figure);
            insets = insets.getAdded(moreInsets);
        }
        return insets;
    }

    @Override
    public Dimension getPreferredSize(IFigure fig) {
        Dimension prefSize = new Dimension(this.inner.getPreferredSize(fig));
        Insets outerInsets = this.outer.getInsets(fig);
        prefSize.expand(outerInsets.getWidth(), outerInsets.getHeight());
        prefSize.union(this.outer.getPreferredSize(fig));
        return prefSize;
    }

    public Border getOuterBorder() {
        return this.outer;
    }

    @Override
    public boolean isOpaque() {
        return this.inner != null && this.inner.isOpaque() && this.outer != null && this.outer.isOpaque();
    }

    @Override
    public void paint(IFigure figure, Graphics g, Insets insets) {
        if (this.outer != null) {
            g.pushState();
            this.outer.paint(figure, g, insets);
            g.popState();
            insets = insets.getAdded(this.outer.getInsets(figure));
        }
        if (this.inner != null) {
            this.inner.paint(figure, g, insets);
        }
    }
}

