/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.data.AbstractDatabaseList;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCArrayImpl;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollectionString;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetImpl;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.utils.CommonUtils;

public class JDBCCollection
extends AbstractDatabaseList
implements DBDValueCloneable {
    private static final Log log = Log.getLog(JDBCCollection.class);
    private Object[] contents;
    private DBSDataType type;
    private DBDValueHandler valueHandler;
    private boolean modified;

    public JDBCCollection() {
    }

    public JDBCCollection(@NotNull DBRProgressMonitor monitor, DBSDataType type, DBDValueHandler valueHandler, @Nullable Object[] contents) {
        this.type = type;
        this.valueHandler = valueHandler;
        if (contents != null) {
            this.contents = new Object[contents.length];
            int i = 0;
            while (i < contents.length) {
                Object value = contents[i];
                if (value instanceof DBDValueCloneable) {
                    try {
                        value = ((DBDValueCloneable)value).cloneValue(monitor);
                    }
                    catch (DBCException ex) {
                        log.warn((Object)("Failed to clone value of type " + value.getClass().getName()), (Throwable)ex);
                    }
                }
                this.contents[i] = value;
                ++i;
            }
        } else {
            this.contents = null;
        }
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.type;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return this.valueHandler;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        return new JDBCCollection(monitor, this.type, this.valueHandler, this.contents);
    }

    public Object getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.makeArrayString('{', '}');
    }

    @NotNull
    public String makeArrayString(char ... brackets) {
        if (this.isNull()) {
            return "NULL";
        }
        StringBuilder str = new StringBuilder(this.contents.length * 32);
        str.append(brackets[0]);
        int i = 0;
        while (i < this.contents.length) {
            Object item = this.contents[i];
            if (i > 0) {
                str.append(',');
            }
            String itemString = this.valueHandler.getValueDisplayString((DBSTypedObject)this.type, item, DBDDisplayFormat.NATIVE);
            SQLUtils.appendValue((StringBuilder)str, (DBSTypedObject)this.type, (Object)itemString);
            ++i;
        }
        str.append(brackets[1]);
        return str.toString();
    }

    public int getItemCount() {
        return this.contents == null ? 0 : this.contents.length;
    }

    public Object getItem(int index) {
        return this.contents[index];
    }

    public void setItem(int index, Object value) {
        this.contents[index] = value;
        this.modified = true;
    }

    public void setContents(Object[] contents) {
        this.contents = contents;
        this.modified = true;
    }

    public java.sql.Array getArrayValue() throws DBCException {
        Object attr;
        if (this.contents == null) {
            return null;
        }
        Object[] attrs = new Object[this.contents.length];
        int i = 0;
        while (i < this.contents.length) {
            attr = this.contents[i];
            if (attr instanceof DBDValue) {
                attr = ((DBDValue)attr).getRawValue();
            }
            attrs[i] = attr;
            ++i;
        }
        DBSDataType dataType = this.getComponentType();
        try {
            attr = null;
            Object var4_7 = null;
            try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)dataType, (String)"Create JDBC array");){
                if (session instanceof Connection) {
                    String typeName = dataType.getFullTypeName();
                    return ((Connection)session).createArrayOf(typeName, attrs);
                }
                return new JDBCArrayImpl(dataType.getTypeName(), dataType.getTypeID(), attrs);
            }
            catch (Throwable throwable) {
                if (attr == null) {
                    attr = throwable;
                } else if (attr != throwable) {
                    ((Throwable)attr).addSuppressed(throwable);
                }
                throw attr;
            }
        }
        catch (Throwable e) {
            throw new DBCException("Error creating struct", e);
        }
    }

    @NotNull
    public static JDBCCollection makeCollectionFromArray(@NotNull JDBCSession session, @NotNull DBSTypedObject column, java.sql.Array array) throws DBCException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        DBSDataType arrayType = null;
        DBSDataType elementType = null;
        JDBCDataSource dataSource = session.getDataSource();
        try {
            if (column instanceof DBSTypedObjectEx) {
                arrayType = ((DBSTypedObjectEx)column).getDataType();
            }
            if (arrayType == null) {
                DBSEntityAttribute attribute;
                DBSEntity docEntity;
                DBCEntityMetaData entityMetaData;
                if (column instanceof DBCAttributeMetaData && (entityMetaData = ((DBCAttributeMetaData)column).getEntityMetaData()) != null && (docEntity = DBUtils.getEntityFromMetaData((DBRProgressMonitor)session.getProgressMonitor(), (DBCExecutionContext)session.getExecutionContext(), (DBCEntityMetaData)entityMetaData)) != null && (attribute = docEntity.getAttribute(session.getProgressMonitor(), ((DBCAttributeMetaData)column).getName())) instanceof DBSTypedObjectEx) {
                    arrayType = ((DBSTypedObjectEx)attribute).getDataType();
                }
                if (arrayType == null) {
                    arrayType = dataSource.resolveDataType(session.getProgressMonitor(), column.getFullTypeName());
                }
            }
            if (arrayType != null) {
                elementType = arrayType.getComponentType(monitor);
            }
        }
        catch (DBException e) {
            log.debug((Object)"Error getting array component type", (Throwable)e);
        }
        if (elementType == null) {
            try {
                String baseTypeName;
                if (array != null && (baseTypeName = array.getBaseTypeName()) != null) {
                    baseTypeName = SQLUtils.stripColumnTypeModifiers((String)baseTypeName);
                    elementType = dataSource.resolveDataType(monitor, baseTypeName);
                }
            }
            catch (Exception e) {
                throw new DBCException("Error resolving data type", (Throwable)e);
            }
        }
        try {
            block21: {
                if (elementType == null && array == null) {
                    String defDataTypeName = dataSource.getDefaultDataTypeName(DBPDataKind.OBJECT);
                    DBSDataType defDataType = dataSource.getLocalDataType(defDataTypeName);
                    DBDValueHandler defValueHandler = session.getDefaultValueHandler();
                    return new JDBCCollection(monitor, defDataType, defValueHandler, null);
                }
                if (elementType != null) {
                    try {
                        return JDBCCollection.makeCollectionFromArray(session, array, elementType);
                    }
                    catch (SQLException e) {
                        if (array != null) break block21;
                        throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                    }
                }
            }
            try {
                return JDBCCollection.makeCollectionFromResultSet(session, array, null);
            }
            catch (SQLException sQLException) {
                try {
                    return JDBCCollection.makeCollectionFromJavaArray(session, array.getArray());
                }
                catch (SQLException ex) {
                    throw new DBCException((Throwable)ex, (DBCExecutionContext)session.getExecutionContext());
                }
            }
        }
        catch (DBException e) {
            throw new DBCException("Can't extract array data from JDBC array", (Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    @NotNull
    public static JDBCCollection makeCollectionFromJavaArray(@NotNull JDBCSession session, Object array) throws DBCException {
        DBSDataType elementType;
        DBPDataKind dataKind;
        JDBCDataSource dataTypeProvider = session.getDataSource();
        if (array instanceof int[] || JDBCCollection.isBoxedObjectArray(array, Integer.class)) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(4);
        } else if (array instanceof short[] || JDBCCollection.isBoxedObjectArray(array, Short.class)) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(5);
        } else if (array instanceof byte[] || JDBCCollection.isBoxedObjectArray(array, Byte.class)) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(-2);
        } else if (array instanceof long[] || JDBCCollection.isBoxedObjectArray(array, Long.class)) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(-5);
        } else if (array instanceof float[] || JDBCCollection.isBoxedObjectArray(array, Float.class)) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(6);
            if (elementType == null) {
                elementType = dataTypeProvider.getLocalDataType(8);
            }
        } else if (array instanceof double[] || JDBCCollection.isBoxedObjectArray(array, Double.class)) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(8);
            if (elementType == null) {
                elementType = dataTypeProvider.getLocalDataType(6);
            }
        } else if (array instanceof BigDecimal[]) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(3);
        } else if (array instanceof boolean[] || JDBCCollection.isBoxedObjectArray(array, Boolean.class)) {
            dataKind = DBPDataKind.BOOLEAN;
            elementType = dataTypeProvider.getLocalDataType(16);
        } else if (array instanceof String[]) {
            dataKind = DBPDataKind.STRING;
            elementType = dataTypeProvider.getLocalDataType(12);
        } else if (array instanceof Date[]) {
            dataKind = DBPDataKind.DATETIME;
            elementType = dataTypeProvider.getLocalDataType(93);
        } else {
            dataKind = DBPDataKind.OBJECT;
            elementType = dataTypeProvider.getLocalDataType(2002);
        }
        if (elementType == null) {
            try {
                String typeName = dataTypeProvider.getDefaultDataTypeName(dataKind);
                if (typeName != null) {
                    elementType = dataTypeProvider.getLocalDataType(typeName);
                }
            }
            catch (Exception e) {
                throw new DBCException("Error resolving default data type", (Throwable)e);
            }
        }
        try {
            if (elementType == null) {
                throw new DBCException("Can't resolve array element data type");
            }
            DBDValueHandler elementValueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)elementType);
            if (array == null) {
                return new JDBCCollection(session.getProgressMonitor(), elementType, elementValueHandler, null);
            }
            return JDBCCollection.makeCollectionFromJavaArray(session, elementType, elementValueHandler, array);
        }
        catch (DBException e) {
            throw new DBCException("Can't extract array data from Java array", (Throwable)e);
        }
    }

    @NotNull
    public static JDBCCollection makeCollectionFromJavaCollection(@NotNull JDBCSession session, @NotNull DBSTypedObject column, Collection<?> coll) throws DBCException {
        JDBCDataSource dataTypeProvider = session.getDataSource();
        DBPDataKind dataKind = DBPDataKind.OBJECT;
        DBSDataType elementType = dataTypeProvider.getLocalDataType(2002);
        if (elementType == null) {
            try {
                String typeName = dataTypeProvider.getDefaultDataTypeName(dataKind);
                if (typeName != null) {
                    elementType = dataTypeProvider.getLocalDataType(typeName);
                }
            }
            catch (Exception e) {
                throw new DBCException("Error resolving default data type", (Throwable)e);
            }
        }
        try {
            if (elementType == null) {
                throw new DBCException("Can't resolve array element data type");
            }
            DBDValueHandler elementValueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)elementType);
            return JDBCCollection.makeCollectionFromJavaArray(session, elementType, elementValueHandler, coll.toArray());
        }
        catch (DBException e) {
            throw new DBCException("Can't extract array data from Java array", (Throwable)e);
        }
    }

    @NotNull
    private static JDBCCollection makeCollectionFromResultSet(@NotNull JDBCSession session, @NotNull java.sql.Array array, @Nullable DBSDataType elementType) throws SQLException, DBException {
        DBDValueHandler valueHandler;
        ResultSet dbResult = array.getResultSet();
        if (dbResult == null) {
            throw new DBCException("JDBC array type was not resolved and result set was not provided by driver. Return NULL.");
        }
        if (elementType == null) {
            JDBCColumnMetaData itemMeta = new JDBCColumnMetaData((DBPDataSource)session.getDataSource(), dbResult.getMetaData(), 1);
            elementType = DBUtils.resolveDataType((DBRProgressMonitor)session.getProgressMonitor(), (DBPDataSource)session.getDataSource(), (String)itemMeta.getTypeName());
            if (elementType == null) {
                elementType = new DBSDataType(session.getDataSource(), (DBSTypedObject)itemMeta);
            }
            valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemMeta);
        } else {
            valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)elementType);
        }
        try {
            JDBCCollection jDBCCollection;
            block22: {
                Throwable throwable = null;
                Object var6_7 = null;
                JDBCResultSet resultSet = JDBCResultSetImpl.makeResultSet(session, null, dbResult, ModelMessages.model_jdbc_array_result_set, true);
                try {
                    ArrayList<Object> data = new ArrayList<Object>();
                    while (dbResult.next()) {
                        data.add(valueHandler.fetchValueObject((DBCSession)session, (DBCResultSet)resultSet, elementType, 1));
                    }
                    jDBCCollection = new JDBCCollection(session.getProgressMonitor(), elementType, valueHandler, data.toArray());
                    if (resultSet == null) break block22;
                }
                catch (Throwable throwable2) {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                resultSet.close();
            }
            return jDBCCollection;
        }
        finally {
            try {
                dbResult.close();
            }
            catch (SQLException e) {
                log.debug((Object)"Can't close array result set", (Throwable)e);
            }
        }
    }

    @NotNull
    private static JDBCCollection makeCollectionFromArray(@NotNull JDBCSession session, @Nullable java.sql.Array array, @NotNull DBSDataType elementType) throws SQLException, DBCException {
        DBDValueHandler elementValueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)elementType);
        if (array == null) {
            return new JDBCCollection(session.getProgressMonitor(), elementType, elementValueHandler, null);
        }
        Object arrObject = array.getArray();
        return JDBCCollection.makeCollectionFromJavaArray(session, elementType, elementValueHandler, arrObject);
    }

    @NotNull
    private static JDBCCollection makeCollectionFromJavaArray(@NotNull JDBCSession session, @NotNull DBSDataType elementType, @NotNull DBDValueHandler elementValueHandler, @Nullable Object arrObject) throws DBCException {
        int arrLength = arrObject == null ? 0 : Array.getLength(arrObject);
        Object[] contents = new Object[arrLength];
        int i = 0;
        while (i < arrLength) {
            Object item = Array.get(arrObject, i);
            Object itemValue = item != null && item.getClass().isArray() && elementType.getDataKind() != DBPDataKind.ARRAY ? JDBCCollection.makeCollectionFromJavaArray(session, elementType, elementValueHandler, item) : elementValueHandler.getValueFromObject((DBCSession)session, (DBSTypedObject)elementType, item, false, true);
            contents[i] = itemValue;
            ++i;
        }
        return new JDBCCollection(session.getProgressMonitor(), elementType, elementValueHandler, contents);
    }

    private static boolean isBoxedObjectArray(@Nullable Object array, @NotNull Class<?> type) {
        if (array instanceof Object[]) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = (Object[])array;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray2[n2];
                if (element != null) {
                    return type.isInstance(element);
                }
                ++n2;
            }
        }
        return false;
    }

    @NotNull
    public static DBDCollection makeCollectionFromString(@NotNull JDBCSession session, String value) throws DBCException {
        DBDValueHandler valueHandler;
        String stringType = DBUtils.getDefaultDataTypeName((DBSObject)session.getDataSource(), (DBPDataKind)DBPDataKind.STRING);
        DBSDataType dataType = DBUtils.getLocalDataType((DBPDataSource)session.getDataSource(), (String)stringType);
        if (dataType == null) {
            log.debug((Object)("String data type '" + stringType + "' not supported by database"));
            valueHandler = session.getDataSource().getContainer().getDefaultValueHandler();
        } else {
            valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)dataType);
        }
        if (!CommonUtils.isEmpty((String)value) && value.startsWith("[") && value.endsWith("]")) {
            String arrayString = value.substring(1, value.length() - 1);
            ArrayList<String> items = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(arrayString, ",", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("\"") && token.endsWith("\"")) {
                    token = token.substring(1, token.length() - 1);
                }
                items.add(token);
            }
            return new JDBCCollectionString(session.getProgressMonitor(), dataType, valueHandler, value, items.toArray());
        }
        return new JDBCCollectionString(session.getProgressMonitor(), dataType, valueHandler, value);
    }

    public int size() {
        return this.getItemCount();
    }

    public Object get(int index) {
        return this.getItem(index);
    }
}

