// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the information about the bucket that will be created. For more information about directory buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>
/// <p>This functionality is only supported by directory buckets.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct BucketInfo {
    /// <p>The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket.</p>
    pub data_redundancy: ::std::option::Option<crate::types::DataRedundancy>,
    /// <p>The type of bucket.</p>
    pub r#type: ::std::option::Option<crate::types::BucketType>,
}
impl BucketInfo {
    /// <p>The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket.</p>
    pub fn data_redundancy(&self) -> ::std::option::Option<&crate::types::DataRedundancy> {
        self.data_redundancy.as_ref()
    }
    /// <p>The type of bucket.</p>
    pub fn r#type(&self) -> ::std::option::Option<&crate::types::BucketType> {
        self.r#type.as_ref()
    }
}
impl BucketInfo {
    /// Creates a new builder-style object to manufacture [`BucketInfo`](crate::types::BucketInfo).
    pub fn builder() -> crate::types::builders::BucketInfoBuilder {
        crate::types::builders::BucketInfoBuilder::default()
    }
}

/// A builder for [`BucketInfo`](crate::types::BucketInfo).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct BucketInfoBuilder {
    pub(crate) data_redundancy: ::std::option::Option<crate::types::DataRedundancy>,
    pub(crate) r#type: ::std::option::Option<crate::types::BucketType>,
}
impl BucketInfoBuilder {
    /// <p>The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket.</p>
    pub fn data_redundancy(mut self, input: crate::types::DataRedundancy) -> Self {
        self.data_redundancy = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket.</p>
    pub fn set_data_redundancy(mut self, input: ::std::option::Option<crate::types::DataRedundancy>) -> Self {
        self.data_redundancy = input;
        self
    }
    /// <p>The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket.</p>
    pub fn get_data_redundancy(&self) -> &::std::option::Option<crate::types::DataRedundancy> {
        &self.data_redundancy
    }
    /// <p>The type of bucket.</p>
    pub fn r#type(mut self, input: crate::types::BucketType) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of bucket.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::BucketType>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The type of bucket.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::BucketType> {
        &self.r#type
    }
    /// Consumes the builder and constructs a [`BucketInfo`](crate::types::BucketInfo).
    pub fn build(self) -> crate::types::BucketInfo {
        crate::types::BucketInfo {
            data_redundancy: self.data_redundancy,
            r#type: self.r#type,
        }
    }
}
