/*
 * Copyright (C) 2025 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "shared/source/xe3p_core/hw_cmds_cri.h"
#include "shared/test/common/test_macros/hw_test_base.h"
using namespace NEO;

HWTEST_EXCLUDE_PRODUCT(AUBWriteImageBCS, GivenUnalignedMemoryWhenWritingImageWithBlitterEnabledThenExpectationsAreMet, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(AUBCopyImageCCS, WhenCopyingThenExpectationsMet, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(AUBCopyImageBCS, WhenCopyingWithBlitterEnabledThenExpectationsMet, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(AUBReadImageCCS, GivenMisalignedHostPtrWhenReadingImageThenExpectationsAreMet_ImageSupport, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(AUBReadImageCCS, GivenUnalignedMemoryWhenReadingImageThenExpectationsAreMet, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(AUBReadImageBCS, GivenMisalignedHostPtrWhenReadingImageWithBlitterEnabledThenExpectationsAreMet_ImageSupport, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(AUBReadImageBCS, GivenUnalignedMemoryWhenReadingImageWithBlitterEnabledThenExpectationsAreMet, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(AUBWriteImageCCS, GivenMisalignedHostPtrWhenWritingImageThenExpectationsAreMet_ImageSupport, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(AUBWriteImageCCS, GivenUnalignedMemoryWhenWritingImageThenExpectationsAreMet, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(AUBWriteImageBCS, GivenMisalignedHostPtrWhenWritingImageWithBlitterEnabledThenExpectationsAreMet_ImageSupport, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenNotCompressedBufferWhenBltExecutedThenCompressDataAndResolve, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenHostPtrWhenBlitCommandToCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenDstHostPtrWhenBlitCommandFromCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenDstHostPtrWhenBlitCommandFromNotCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenSrcHostPtrWhenBlitCommandToNotCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenBufferWithOffsetWhenHostPtrBlitCommandIsDispatchedFromHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenBufferWithOffsetWhenHostPtrBlitCommandIsDispatchedToHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenOffsetsWhenBltExecutedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenSrcCompressedBufferWhenBlitCommandToDstCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenCompressedBufferWhenAuxTranslationCalledThenResolveAndCompress, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenReadBufferRectWithOffsetWhenHostPtrBlitCommandIsDispatchedToHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenWriteBufferRectWithOffsetWhenHostPtrBlitCommandIsDispatchedToHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenCopyBufferRectWithOffsetWhenHostPtrBlitCommandIsDispatchedToHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineTests, givenCopyBufferRectWithBigSizesWhenHostPtrBlitCommandIsDispatchedToHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileCopyEngineSystemMemoryTests, givenSrcSystemBufferWhenBlitCommandToDstSystemBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenNotCompressedBufferWhenBltExecutedThenCompressDataAndResolve, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenHostPtrWhenBlitCommandToCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenDstHostPtrWhenBlitCommandFromCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenDstHostPtrWhenBlitCommandFromNotCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenSrcHostPtrWhenBlitCommandToNotCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenBufferWithOffsetWhenHostPtrBlitCommandIsDispatchedFromHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenBufferWithOffsetWhenHostPtrBlitCommandIsDispatchedToHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenOffsetsWhenBltExecutedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenSrcCompressedBufferWhenBlitCommandToDstCompressedBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenCompressedBufferWhenAuxTranslationCalledThenResolveAndCompress, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenReadBufferRectWithOffsetWhenHostPtrBlitCommandIsDispatchedToHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenWriteBufferRectWithOffsetWhenHostPtrBlitCommandIsDispatchedToHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileXe3pCoreTests, givenCopyBufferRectWithOffsetWhenHostPtrBlitCommandIsDispatchedToHostPtrThenDataIsCorrectlyCopied, IGFX_CRI);
HWTEST_EXCLUDE_PRODUCT(SingleTileSystemMemoryXe3pCoreTests, givenSrcSystemBufferWhenBlitCommandToDstSystemBufferIsDispatchedThenCopiedDataIsValid, IGFX_CRI);
