//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbuttontype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSButtonType(pub NSUInteger);
impl NSButtonType {
    #[doc(alias = "NSButtonTypeMomentaryLight")]
    pub const MomentaryLight: Self = Self(0);
    #[doc(alias = "NSButtonTypePushOnPushOff")]
    pub const PushOnPushOff: Self = Self(1);
    #[doc(alias = "NSButtonTypeToggle")]
    pub const Toggle: Self = Self(2);
    #[doc(alias = "NSButtonTypeSwitch")]
    pub const Switch: Self = Self(3);
    #[doc(alias = "NSButtonTypeRadio")]
    pub const Radio: Self = Self(4);
    #[doc(alias = "NSButtonTypeMomentaryChange")]
    pub const MomentaryChange: Self = Self(5);
    #[doc(alias = "NSButtonTypeOnOff")]
    pub const OnOff: Self = Self(6);
    #[doc(alias = "NSButtonTypeMomentaryPushIn")]
    pub const MomentaryPushIn: Self = Self(7);
    #[doc(alias = "NSButtonTypeAccelerator")]
    pub const Accelerator: Self = Self(8);
    #[doc(alias = "NSButtonTypeMultiLevelAccelerator")]
    pub const MultiLevelAccelerator: Self = Self(9);
}

unsafe impl Encode for NSButtonType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSButtonType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbezelstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSBezelStyle(pub NSUInteger);
impl NSBezelStyle {
    /// The appearance of this bezel style is automatically determined based on the button's contents and position within the window. This bezel style is the default for all button initializers.
    #[doc(alias = "NSBezelStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    /// The standard system push button style.
    #[doc(alias = "NSBezelStylePush")]
    pub const Push: Self = Self(1);
    /// A flexible-height variant of NSBezelStylePush.
    #[doc(alias = "NSBezelStyleFlexiblePush")]
    pub const FlexiblePush: Self = Self(2);
    /// An unbezeled button with a disclosure triangle.
    #[doc(alias = "NSBezelStyleDisclosure")]
    pub const Disclosure: Self = Self(5);
    /// A button with a circular bezel suitable for a small icon or single character.
    #[doc(alias = "NSBezelStyleCircular")]
    pub const Circular: Self = Self(7);
    /// A circular button with a question mark providing the standard Help button appearance.
    #[doc(alias = "NSBezelStyleHelpButton")]
    pub const HelpButton: Self = Self(9);
    /// A button with squared edges and flexible height.
    #[doc(alias = "NSBezelStyleSmallSquare")]
    pub const SmallSquare: Self = Self(10);
    /// A button style that is appropriate for use in a toolbar item.
    #[doc(alias = "NSBezelStyleToolbar")]
    pub const Toolbar: Self = Self(11);
    /// A bezel style that is suitable for accessory and scope bars. This style is typically used for buttons that perform an action or for pop-up buttons.
    #[doc(alias = "NSBezelStyleAccessoryBarAction")]
    pub const AccessoryBarAction: Self = Self(12);
    /// A bezel style that is suitable for accessory and scope bars. This style is typically used for buttons with togglable state.
    #[doc(alias = "NSBezelStyleAccessoryBar")]
    pub const AccessoryBar: Self = Self(13);
    /// A bezeled variant of NSBezelStyleDisclosure.
    #[doc(alias = "NSBezelStylePushDisclosure")]
    pub const PushDisclosure: Self = Self(14);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleBadge")]
    pub const Badge: Self = Self(15);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleShadowlessSquare")]
    #[deprecated]
    pub const ShadowlessSquare: Self = Self(6);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleTexturedSquare")]
    #[deprecated]
    pub const TexturedSquare: Self = Self(8);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleRounded")]
    #[deprecated]
    pub const Rounded: Self = Self(NSBezelStyle::Push.0);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleRegularSquare")]
    #[deprecated]
    pub const RegularSquare: Self = Self(NSBezelStyle::FlexiblePush.0);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleTexturedRounded")]
    #[deprecated]
    pub const TexturedRounded: Self = Self(NSBezelStyle::Toolbar.0);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleRoundRect")]
    #[deprecated]
    pub const RoundRect: Self = Self(NSBezelStyle::AccessoryBarAction.0);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleRecessed")]
    #[deprecated]
    pub const Recessed: Self = Self(NSBezelStyle::AccessoryBar.0);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleRoundedDisclosure")]
    #[deprecated]
    pub const RoundedDisclosure: Self = Self(NSBezelStyle::PushDisclosure.0);
    /// A bezel style that is typically used in table rows to display information about the row, such as a count.
    #[doc(alias = "NSBezelStyleInline")]
    #[deprecated]
    pub const Inline: Self = Self(NSBezelStyle::Badge.0);
}

unsafe impl Encode for NSBezelStyle {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSBezelStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbuttoncell?language=objc)
    #[unsafe(super(NSActionCell, NSCell, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSActionCell", feature = "NSCell"))]
    pub struct NSButtonCell;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSActionCell",
    feature = "NSCell"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSButtonCell {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSActionCell",
    feature = "NSCell"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSButtonCell {}
);

#[cfg(all(feature = "NSActionCell", feature = "NSCell"))]
extern_conformance!(
    unsafe impl NSCoding for NSButtonCell {}
);

#[cfg(all(feature = "NSActionCell", feature = "NSCell"))]
extern_conformance!(
    unsafe impl NSCopying for NSButtonCell {}
);

#[cfg(all(feature = "NSActionCell", feature = "NSCell"))]
unsafe impl CopyingHelper for NSButtonCell {
    type Result = Self;
}

#[cfg(all(feature = "NSActionCell", feature = "NSCell"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSButtonCell {}
);

#[cfg(all(
    feature = "NSActionCell",
    feature = "NSCell",
    feature = "NSUserInterfaceItemIdentification"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSButtonCell {}
);

#[cfg(all(feature = "NSActionCell", feature = "NSCell"))]
impl NSButtonCell {
    extern_methods!(
        #[unsafe(method(initTextCell:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initTextCell(this: Allocated<Self>, string: &NSString) -> Retained<Self>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(initImageCell:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initImageCell(
            this: Allocated<Self>,
            image: Option<&NSImage>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[unsafe(method(bezelStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn bezelStyle(&self) -> NSBezelStyle;

        /// Setter for [`bezelStyle`][Self::bezelStyle].
        #[unsafe(method(setBezelStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBezelStyle(&self, bezel_style: NSBezelStyle);

        #[unsafe(method(setButtonType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setButtonType(&self, r#type: NSButtonType);

        #[unsafe(method(highlightsBy))]
        #[unsafe(method_family = none)]
        pub unsafe fn highlightsBy(&self) -> NSCellStyleMask;

        /// Setter for [`highlightsBy`][Self::highlightsBy].
        #[unsafe(method(setHighlightsBy:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHighlightsBy(&self, highlights_by: NSCellStyleMask);

        #[unsafe(method(showsStateBy))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsStateBy(&self) -> NSCellStyleMask;

        /// Setter for [`showsStateBy`][Self::showsStateBy].
        #[unsafe(method(setShowsStateBy:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsStateBy(&self, shows_state_by: NSCellStyleMask);

        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitle(&self, title: Option<&NSString>);

        #[unsafe(method(attributedTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributedTitle(&self) -> Retained<NSAttributedString>;

        /// Setter for [`attributedTitle`][Self::attributedTitle].
        #[unsafe(method(setAttributedTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributedTitle(&self, attributed_title: &NSAttributedString);

        #[unsafe(method(alternateTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn alternateTitle(&self) -> Retained<NSString>;

        /// Setter for [`alternateTitle`][Self::alternateTitle].
        #[unsafe(method(setAlternateTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlternateTitle(&self, alternate_title: &NSString);

        #[unsafe(method(attributedAlternateTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributedAlternateTitle(&self) -> Retained<NSAttributedString>;

        /// Setter for [`attributedAlternateTitle`][Self::attributedAlternateTitle].
        #[unsafe(method(setAttributedAlternateTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributedAlternateTitle(
            &self,
            attributed_alternate_title: &NSAttributedString,
        );

        #[cfg(feature = "NSImage")]
        #[unsafe(method(alternateImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn alternateImage(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`alternateImage`][Self::alternateImage].
        #[unsafe(method(setAlternateImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlternateImage(&self, alternate_image: Option<&NSImage>);

        #[unsafe(method(imagePosition))]
        #[unsafe(method_family = none)]
        pub unsafe fn imagePosition(&self) -> NSCellImagePosition;

        /// Setter for [`imagePosition`][Self::imagePosition].
        #[unsafe(method(setImagePosition:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImagePosition(&self, image_position: NSCellImagePosition);

        #[unsafe(method(imageScaling))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageScaling(&self) -> NSImageScaling;

        /// Setter for [`imageScaling`][Self::imageScaling].
        #[unsafe(method(setImageScaling:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImageScaling(&self, image_scaling: NSImageScaling);

        #[unsafe(method(keyEquivalent))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyEquivalent(&self) -> Retained<NSString>;

        /// Setter for [`keyEquivalent`][Self::keyEquivalent].
        #[unsafe(method(setKeyEquivalent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setKeyEquivalent(&self, key_equivalent: &NSString);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(keyEquivalentModifierMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyEquivalentModifierMask(&self) -> NSEventModifierFlags;

        #[cfg(feature = "NSEvent")]
        /// Setter for [`keyEquivalentModifierMask`][Self::keyEquivalentModifierMask].
        #[unsafe(method(setKeyEquivalentModifierMask:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setKeyEquivalentModifierMask(
            &self,
            key_equivalent_modifier_mask: NSEventModifierFlags,
        );

        #[unsafe(method(isTransparent))]
        #[unsafe(method_family = none)]
        pub unsafe fn isTransparent(&self) -> bool;

        /// Setter for [`isTransparent`][Self::isTransparent].
        #[unsafe(method(setTransparent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTransparent(&self, transparent: bool);

        #[unsafe(method(isOpaque))]
        #[unsafe(method_family = none)]
        pub unsafe fn isOpaque(&self) -> bool;

        #[unsafe(method(imageDimsWhenDisabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageDimsWhenDisabled(&self) -> bool;

        /// Setter for [`imageDimsWhenDisabled`][Self::imageDimsWhenDisabled].
        #[unsafe(method(setImageDimsWhenDisabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImageDimsWhenDisabled(&self, image_dims_when_disabled: bool);

        #[unsafe(method(showsBorderOnlyWhileMouseInside))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsBorderOnlyWhileMouseInside(&self) -> bool;

        /// Setter for [`showsBorderOnlyWhileMouseInside`][Self::showsBorderOnlyWhileMouseInside].
        #[unsafe(method(setShowsBorderOnlyWhileMouseInside:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsBorderOnlyWhileMouseInside(
            &self,
            shows_border_only_while_mouse_inside: bool,
        );

        #[cfg(feature = "NSSound")]
        #[unsafe(method(sound))]
        #[unsafe(method_family = none)]
        pub unsafe fn sound(&self) -> Option<Retained<NSSound>>;

        #[cfg(feature = "NSSound")]
        /// Setter for [`sound`][Self::sound].
        #[unsafe(method(setSound:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSound(&self, sound: Option<&NSSound>);

        #[cfg(feature = "NSColor")]
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundColor(&self) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundColor(&self, background_color: Option<&NSColor>);

        #[unsafe(method(setPeriodicDelay:interval:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPeriodicDelay_interval(&self, delay: c_float, interval: c_float);

        #[unsafe(method(getPeriodicDelay:interval:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getPeriodicDelay_interval(
            &self,
            delay: NonNull<c_float>,
            interval: NonNull<c_float>,
        );

        #[unsafe(method(performClick:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performClick(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(mouseEntered:))]
        #[unsafe(method_family = none)]
        pub unsafe fn mouseEntered(&self, event: &NSEvent);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(mouseExited:))]
        #[unsafe(method_family = none)]
        pub unsafe fn mouseExited(&self, event: &NSEvent);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawBezelWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawBezelWithFrame_inView(&self, frame: NSRect, control_view: &NSView);

        #[cfg(all(feature = "NSImage", feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawImage:withFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawImage_withFrame_inView(
            &self,
            image: &NSImage,
            frame: NSRect,
            control_view: &NSView,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawTitle:withFrame:inView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawTitle_withFrame_inView(
            &self,
            title: &NSAttributedString,
            frame: NSRect,
            control_view: &NSView,
        ) -> NSRect;
    );
}

/// Methods declared on superclass `NSCell`.
#[cfg(all(feature = "NSActionCell", feature = "NSCell"))]
impl NSButtonCell {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSActionCell", feature = "NSCell"))]
impl NSButtonCell {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsgradienttype?language=objc)
// NS_ENUM
#[deprecated]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSGradientType(pub NSUInteger);
impl NSGradientType {
    #[doc(alias = "NSGradientNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "NSGradientConcaveWeak")]
    pub const ConcaveWeak: Self = Self(1);
    #[doc(alias = "NSGradientConcaveStrong")]
    pub const ConcaveStrong: Self = Self(2);
    #[doc(alias = "NSGradientConvexWeak")]
    pub const ConvexWeak: Self = Self(3);
    #[doc(alias = "NSGradientConvexStrong")]
    pub const ConvexStrong: Self = Self(4);
}

unsafe impl Encode for NSGradientType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSGradientType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmomentarylightbutton?language=objc)
pub static NSMomentaryLightButton: NSButtonType = NSButtonType(NSButtonType::MomentaryLight.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspushonpushoffbutton?language=objc)
pub static NSPushOnPushOffButton: NSButtonType = NSButtonType(NSButtonType::PushOnPushOff.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstogglebutton?language=objc)
pub static NSToggleButton: NSButtonType = NSButtonType(NSButtonType::Toggle.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsswitchbutton?language=objc)
pub static NSSwitchButton: NSButtonType = NSButtonType(NSButtonType::Switch.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsradiobutton?language=objc)
pub static NSRadioButton: NSButtonType = NSButtonType(NSButtonType::Radio.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmomentarychangebutton?language=objc)
pub static NSMomentaryChangeButton: NSButtonType = NSButtonType(NSButtonType::MomentaryChange.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsonoffbutton?language=objc)
pub static NSOnOffButton: NSButtonType = NSButtonType(NSButtonType::OnOff.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmomentarypushinbutton?language=objc)
pub static NSMomentaryPushInButton: NSButtonType = NSButtonType(NSButtonType::MomentaryPushIn.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsacceleratorbutton?language=objc)
pub static NSAcceleratorButton: NSButtonType = NSButtonType(NSButtonType::Accelerator.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmultilevelacceleratorbutton?language=objc)
pub static NSMultiLevelAcceleratorButton: NSButtonType =
    NSButtonType(NSButtonType::MultiLevelAccelerator.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmomentarypushbutton?language=objc)
pub static NSMomentaryPushButton: NSButtonType = NSButtonType(NSButtonType::MomentaryLight.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmomentarylight?language=objc)
pub static NSMomentaryLight: NSButtonType = NSButtonType(NSButtonType::MomentaryPushIn.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsroundedbezelstyle?language=objc)
pub static NSRoundedBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::Push.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsregularsquarebezelstyle?language=objc)
pub static NSRegularSquareBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::FlexiblePush.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdisclosurebezelstyle?language=objc)
pub static NSDisclosureBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::Disclosure.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsshadowlesssquarebezelstyle?language=objc)
pub static NSShadowlessSquareBezelStyle: NSBezelStyle =
    NSBezelStyle(NSBezelStyle::ShadowlessSquare.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscircularbezelstyle?language=objc)
pub static NSCircularBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::Circular.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexturedsquarebezelstyle?language=objc)
pub static NSTexturedSquareBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::TexturedSquare.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nshelpbuttonbezelstyle?language=objc)
pub static NSHelpButtonBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::HelpButton.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssmallsquarebezelstyle?language=objc)
pub static NSSmallSquareBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::SmallSquare.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstexturedroundedbezelstyle?language=objc)
pub static NSTexturedRoundedBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::Toolbar.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsroundrectbezelstyle?language=objc)
pub static NSRoundRectBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::AccessoryBarAction.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsrecessedbezelstyle?language=objc)
pub static NSRecessedBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::AccessoryBar.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsroundeddisclosurebezelstyle?language=objc)
pub static NSRoundedDisclosureBezelStyle: NSBezelStyle =
    NSBezelStyle(NSBezelStyle::PushDisclosure.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsinlinebezelstyle?language=objc)
pub static NSInlineBezelStyle: NSBezelStyle = NSBezelStyle(NSBezelStyle::Badge.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssmalliconbuttonbezelstyle?language=objc)
pub static NSSmallIconButtonBezelStyle: NSBezelStyle = NSBezelStyle(2);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsthicksquarebezelstyle?language=objc)
pub static NSThickSquareBezelStyle: NSBezelStyle = NSBezelStyle(3);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsthickersquarebezelstyle?language=objc)
pub static NSThickerSquareBezelStyle: NSBezelStyle = NSBezelStyle(4);

/// NSDeprecated.
#[cfg(all(feature = "NSActionCell", feature = "NSCell"))]
impl NSButtonCell {
    extern_methods!(
        #[deprecated = "The gradientType property is unused, and setting it has no effect."]
        #[unsafe(method(gradientType))]
        #[unsafe(method_family = none)]
        pub unsafe fn gradientType(&self) -> NSGradientType;

        /// Setter for [`gradientType`][Self::gradientType].
        #[deprecated = "The gradientType property is unused, and setting it has no effect."]
        #[unsafe(method(setGradientType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGradientType(&self, gradient_type: NSGradientType);

        #[deprecated = "Mnemonics are not used on macOS. Set the title property directly instead."]
        #[unsafe(method(setTitleWithMnemonic:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitleWithMnemonic(&self, string_with_ampersand: Option<&NSString>);

        #[deprecated = "Mnemonics are not used on macOS. Set the alternateTitle property directly instead."]
        #[unsafe(method(setAlternateTitleWithMnemonic:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlternateTitleWithMnemonic(
            &self,
            string_with_ampersand: Option<&NSString>,
        );

        #[deprecated = "Mnemonics are not used on macOS. Calling this method has no effect."]
        #[unsafe(method(setAlternateMnemonicLocation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlternateMnemonicLocation(&self, location: NSUInteger);

        #[deprecated = "Mnemonics are not used on macOS. This property always returns NSNotFound."]
        #[unsafe(method(alternateMnemonicLocation))]
        #[unsafe(method_family = none)]
        pub unsafe fn alternateMnemonicLocation(&self) -> NSUInteger;

        #[deprecated = "Mnemonics are not used on macOS. This property always returns an empty string."]
        #[unsafe(method(alternateMnemonic))]
        #[unsafe(method_family = none)]
        pub unsafe fn alternateMnemonic(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSFont")]
        #[deprecated = "The keyEquivalentFont property is no longer used. It always returns the NSButtonCell's font, and setting it has no effect."]
        #[unsafe(method(keyEquivalentFont))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyEquivalentFont(&self) -> Option<Retained<NSFont>>;

        #[cfg(feature = "NSFont")]
        /// Setter for [`keyEquivalentFont`][Self::keyEquivalentFont].
        #[deprecated = "The keyEquivalentFont property is no longer used. It always returns the NSButtonCell's font, and setting it has no effect."]
        #[unsafe(method(setKeyEquivalentFont:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setKeyEquivalentFont(&self, key_equivalent_font: Option<&NSFont>);

        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated = "The keyEquivalentFont property is no longer used. Setting it has no effect."]
        #[unsafe(method(setKeyEquivalentFont:size:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setKeyEquivalentFont_size(&self, font_name: &NSString, font_size: CGFloat);
    );
}
