package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScalingConfigItemV2 invokes the emr.DescribeScalingConfigItemV2 API synchronously
func (client *Client) DescribeScalingConfigItemV2(request *DescribeScalingConfigItemV2Request) (response *DescribeScalingConfigItemV2Response, err error) {
	response = CreateDescribeScalingConfigItemV2Response()
	err = client.DoAction(request, response)
	return
}

// DescribeScalingConfigItemV2WithChan invokes the emr.DescribeScalingConfigItemV2 API asynchronously
func (client *Client) DescribeScalingConfigItemV2WithChan(request *DescribeScalingConfigItemV2Request) (<-chan *DescribeScalingConfigItemV2Response, <-chan error) {
	responseChan := make(chan *DescribeScalingConfigItemV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScalingConfigItemV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScalingConfigItemV2WithCallback invokes the emr.DescribeScalingConfigItemV2 API asynchronously
func (client *Client) DescribeScalingConfigItemV2WithCallback(request *DescribeScalingConfigItemV2Request, callback func(response *DescribeScalingConfigItemV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScalingConfigItemV2Response
		var err error
		defer close(result)
		response, err = client.DescribeScalingConfigItemV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScalingConfigItemV2Request is the request struct for api DescribeScalingConfigItemV2
type DescribeScalingConfigItemV2Request struct {
	*requests.RpcRequest
	ConfigItemType      string           `position:"Query" name:"ConfigItemType"`
	ResourceOwnerId     requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ScalingGroupBizId   string           `position:"Query" name:"ScalingGroupBizId"`
	ResourceGroupId     string           `position:"Query" name:"ResourceGroupId"`
	ScalingConfigItemId string           `position:"Query" name:"ScalingConfigItemId"`
}

// DescribeScalingConfigItemV2Response is the response struct for api DescribeScalingConfigItemV2
type DescribeScalingConfigItemV2Response struct {
	*responses.BaseResponse
	RequestId              string `json:"RequestId" xml:"RequestId"`
	ConfigItemType         string `json:"ConfigItemType" xml:"ConfigItemType"`
	ScalingGroupBizId      string `json:"ScalingGroupBizId" xml:"ScalingGroupBizId"`
	ScalingConfigItemBizId string `json:"ScalingConfigItemBizId" xml:"ScalingConfigItemBizId"`
	ConfigItemInformation  string `json:"ConfigItemInformation" xml:"ConfigItemInformation"`
}

// CreateDescribeScalingConfigItemV2Request creates a request to invoke DescribeScalingConfigItemV2 API
func CreateDescribeScalingConfigItemV2Request() (request *DescribeScalingConfigItemV2Request) {
	request = &DescribeScalingConfigItemV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeScalingConfigItemV2", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeScalingConfigItemV2Response creates a response to parse from DescribeScalingConfigItemV2 response
func CreateDescribeScalingConfigItemV2Response() (response *DescribeScalingConfigItemV2Response) {
	response = &DescribeScalingConfigItemV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
