package tdsr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWindowConfig invokes the tdsr.GetWindowConfig API synchronously
// api document: https://help.aliyun.com/api/tdsr/getwindowconfig.html
func (client *Client) GetWindowConfig(request *GetWindowConfigRequest) (response *GetWindowConfigResponse, err error) {
	response = CreateGetWindowConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetWindowConfigWithChan invokes the tdsr.GetWindowConfig API asynchronously
// api document: https://help.aliyun.com/api/tdsr/getwindowconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetWindowConfigWithChan(request *GetWindowConfigRequest) (<-chan *GetWindowConfigResponse, <-chan error) {
	responseChan := make(chan *GetWindowConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWindowConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWindowConfigWithCallback invokes the tdsr.GetWindowConfig API asynchronously
// api document: https://help.aliyun.com/api/tdsr/getwindowconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetWindowConfigWithCallback(request *GetWindowConfigRequest, callback func(response *GetWindowConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWindowConfigResponse
		var err error
		defer close(result)
		response, err = client.GetWindowConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWindowConfigRequest is the request struct for api GetWindowConfig
type GetWindowConfigRequest struct {
	*requests.RpcRequest
	PreviewToken string `position:"Query" name:"PreviewToken"`
}

// GetWindowConfigResponse is the response struct for api GetWindowConfig
type GetWindowConfigResponse struct {
	*responses.BaseResponse
	RequestId    string                 `json:"RequestId" xml:"RequestId"`
	Success      bool                   `json:"Success" xml:"Success"`
	ErrMessage   string                 `json:"ErrMessage" xml:"ErrMessage"`
	Data         map[string]interface{} `json:"Data" xml:"Data"`
	ObjectString string                 `json:"ObjectString" xml:"ObjectString"`
}

// CreateGetWindowConfigRequest creates a request to invoke GetWindowConfig API
func CreateGetWindowConfigRequest() (request *GetWindowConfigRequest) {
	request = &GetWindowConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("tdsr", "2020-01-01", "GetWindowConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateGetWindowConfigResponse creates a response to parse from GetWindowConfig response
func CreateGetWindowConfigResponse() (response *GetWindowConfigResponse) {
	response = &GetWindowConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
