package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckReceivingDetail invokes the unimkt.CheckReceivingDetail API synchronously
func (client *Client) CheckReceivingDetail(request *CheckReceivingDetailRequest) (response *CheckReceivingDetailResponse, err error) {
	response = CreateCheckReceivingDetailResponse()
	err = client.DoAction(request, response)
	return
}

// CheckReceivingDetailWithChan invokes the unimkt.CheckReceivingDetail API asynchronously
func (client *Client) CheckReceivingDetailWithChan(request *CheckReceivingDetailRequest) (<-chan *CheckReceivingDetailResponse, <-chan error) {
	responseChan := make(chan *CheckReceivingDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckReceivingDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckReceivingDetailWithCallback invokes the unimkt.CheckReceivingDetail API asynchronously
func (client *Client) CheckReceivingDetailWithCallback(request *CheckReceivingDetailRequest, callback func(response *CheckReceivingDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckReceivingDetailResponse
		var err error
		defer close(result)
		response, err = client.CheckReceivingDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckReceivingDetailRequest is the request struct for api CheckReceivingDetail
type CheckReceivingDetailRequest struct {
	*requests.RpcRequest
	DeviceCode string `position:"Body" name:"DeviceCode"`
	V          string `position:"Body" name:"V"`
	ChannelId  string `position:"Body" name:"ChannelId"`
}

// CheckReceivingDetailResponse is the response struct for api CheckReceivingDetail
type CheckReceivingDetailResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Status       bool   `json:"Status" xml:"Status"`
	Msg          string `json:"Msg" xml:"Msg"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	HasPromotion bool   `json:"HasPromotion" xml:"HasPromotion"`
	TradeOrderId string `json:"TradeOrderId" xml:"TradeOrderId"`
}

// CreateCheckReceivingDetailRequest creates a request to invoke CheckReceivingDetail API
func CreateCheckReceivingDetailRequest() (request *CheckReceivingDetailRequest) {
	request = &CheckReceivingDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "CheckReceivingDetail", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckReceivingDetailResponse creates a response to parse from CheckReceivingDetail response
func CreateCheckReceivingDetailResponse() (response *CheckReceivingDetailResponse) {
	response = &CheckReceivingDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
