package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEmbedToken invokes the quickbi_public.CreateEmbedToken API synchronously
func (client *Client) CreateEmbedToken(request *CreateEmbedTokenRequest) (response *CreateEmbedTokenResponse, err error) {
	response = CreateCreateEmbedTokenResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEmbedTokenWithChan invokes the quickbi_public.CreateEmbedToken API asynchronously
func (client *Client) CreateEmbedTokenWithChan(request *CreateEmbedTokenRequest) (<-chan *CreateEmbedTokenResponse, <-chan error) {
	responseChan := make(chan *CreateEmbedTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEmbedToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEmbedTokenWithCallback invokes the quickbi_public.CreateEmbedToken API asynchronously
func (client *Client) CreateEmbedTokenWithCallback(request *CreateEmbedTokenRequest, callback func(response *CreateEmbedTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEmbedTokenResponse
		var err error
		defer close(result)
		response, err = client.CreateEmbedToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEmbedTokenRequest is the request struct for api CreateEmbedToken
type CreateEmbedTokenRequest struct {
	*requests.RpcRequest
	AccountName string           `position:"Query" name:"AccountName"`
	ClientToken string           `position:"Query" name:"ClientToken"`
	WorksId     string           `position:"Query" name:"WorksId"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	AccountType requests.Integer `position:"Query" name:"AccountType"`
	SignType    string           `position:"Query" name:"SignType"`
	ExpireMin   requests.Integer `position:"Query" name:"ExpireMin"`
	UserId      string           `position:"Query" name:"UserId"`
}

// CreateEmbedTokenResponse is the response struct for api CreateEmbedToken
type CreateEmbedTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateEmbedTokenRequest creates a request to invoke CreateEmbedToken API
func CreateCreateEmbedTokenRequest() (request *CreateEmbedTokenRequest) {
	request = &CreateEmbedTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2021-03-25", "CreateEmbedToken", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEmbedTokenResponse creates a response to parse from CreateEmbedToken response
func CreateCreateEmbedTokenResponse() (response *CreateEmbedTokenResponse) {
	response = &CreateEmbedTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
