package storage

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/network"
	"github.com/mailru/easyjson"
)

// EventCacheStorageContentUpdated a cache's contents have been modified.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-cacheStorageContentUpdated
type EventCacheStorageContentUpdated struct {
	Origin     string `json:"origin"`     // Origin to update.
	StorageKey string `json:"storageKey"` // Storage key to update.
	BucketID   string `json:"bucketId"`   // Storage bucket to update.
	CacheName  string `json:"cacheName"`  // Name of cache in origin.
}

// EventCacheStorageListUpdated a cache has been added/deleted.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-cacheStorageListUpdated
type EventCacheStorageListUpdated struct {
	Origin     string `json:"origin"`     // Origin to update.
	StorageKey string `json:"storageKey"` // Storage key to update.
	BucketID   string `json:"bucketId"`   // Storage bucket to update.
}

// EventIndexedDBContentUpdated the origin's IndexedDB object store has been
// modified.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-indexedDBContentUpdated
type EventIndexedDBContentUpdated struct {
	Origin          string `json:"origin"`          // Origin to update.
	StorageKey      string `json:"storageKey"`      // Storage key to update.
	BucketID        string `json:"bucketId"`        // Storage bucket to update.
	DatabaseName    string `json:"databaseName"`    // Database to update.
	ObjectStoreName string `json:"objectStoreName"` // ObjectStore to update.
}

// EventIndexedDBListUpdated the origin's IndexedDB database list has been
// modified.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-indexedDBListUpdated
type EventIndexedDBListUpdated struct {
	Origin     string `json:"origin"`     // Origin to update.
	StorageKey string `json:"storageKey"` // Storage key to update.
	BucketID   string `json:"bucketId"`   // Storage bucket to update.
}

// EventInterestGroupAccessed one of the interest groups was accessed. Note
// that these events are global to all targets sharing an interest group store.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-interestGroupAccessed
type EventInterestGroupAccessed struct {
	AccessTime            *cdp.TimeSinceEpoch     `json:"accessTime"`
	Type                  InterestGroupAccessType `json:"type"`
	OwnerOrigin           string                  `json:"ownerOrigin"`
	Name                  string                  `json:"name"`
	ComponentSellerOrigin string                  `json:"componentSellerOrigin,omitempty"` // For topLevelBid/topLevelAdditionalBid, and when appropriate, win and additionalBidWin
	Bid                   float64                 `json:"bid,omitempty"`                   // For bid or somethingBid event, if done locally and not on a server.
	BidCurrency           string                  `json:"bidCurrency,omitempty"`
	UniqueAuctionID       InterestGroupAuctionID  `json:"uniqueAuctionId,omitempty"` // For non-global events --- links to interestGroupAuctionEvent
}

// EventInterestGroupAuctionEventOccurred an auction involving interest
// groups is taking place. These events are target-specific.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-interestGroupAuctionEventOccurred
type EventInterestGroupAuctionEventOccurred struct {
	EventTime       *cdp.TimeSinceEpoch           `json:"eventTime"`
	Type            InterestGroupAuctionEventType `json:"type"`
	UniqueAuctionID InterestGroupAuctionID        `json:"uniqueAuctionId"`
	ParentAuctionID InterestGroupAuctionID        `json:"parentAuctionId,omitempty"` // Set for child auctions.
	AuctionConfig   easyjson.RawMessage           `json:"auctionConfig,omitempty"`
}

// EventInterestGroupAuctionNetworkRequestCreated specifies which auctions a
// particular network fetch may be related to, and in what role. Note that it is
// not ordered with respect to Network.requestWillBeSent (but will happen before
// loadingFinished loadingFailed).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-interestGroupAuctionNetworkRequestCreated
type EventInterestGroupAuctionNetworkRequestCreated struct {
	Type      InterestGroupAuctionFetchType `json:"type"`
	RequestID network.RequestID             `json:"requestId"`
	Auctions  []InterestGroupAuctionID      `json:"auctions"` // This is the set of the auctions using the worklet that issued this request.  In the case of trusted signals, it's possible that only some of them actually care about the keys being queried.
}

// EventSharedStorageAccessed shared storage was accessed by the associated
// page. The following parameters are included in all events.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-sharedStorageAccessed
type EventSharedStorageAccessed struct {
	AccessTime  *cdp.TimeSinceEpoch        `json:"accessTime"`  // Time of the access.
	Type        SharedStorageAccessType    `json:"type"`        // Enum value indicating the Shared Storage API method invoked.
	MainFrameID cdp.FrameID                `json:"mainFrameId"` // DevTools Frame Token for the primary frame tree's root.
	OwnerOrigin string                     `json:"ownerOrigin"` // Serialized origin for the context that invoked the Shared Storage API.
	Params      *SharedStorageAccessParams `json:"params"`      // The sub-parameters wrapped by params are all optional and their presence/absence depends on type.
}

// EventStorageBucketCreatedOrUpdated [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-storageBucketCreatedOrUpdated
type EventStorageBucketCreatedOrUpdated struct {
	BucketInfo *BucketInfo `json:"bucketInfo"`
}

// EventStorageBucketDeleted [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-storageBucketDeleted
type EventStorageBucketDeleted struct {
	BucketID string `json:"bucketId"`
}

// EventAttributionReportingSourceRegistered [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-attributionReportingSourceRegistered
type EventAttributionReportingSourceRegistered struct {
	Registration *AttributionReportingSourceRegistration      `json:"registration"`
	Result       AttributionReportingSourceRegistrationResult `json:"result"`
}

// EventAttributionReportingTriggerRegistered [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-attributionReportingTriggerRegistered
type EventAttributionReportingTriggerRegistered struct {
	Registration *AttributionReportingTriggerRegistration `json:"registration"`
	EventLevel   AttributionReportingEventLevelResult     `json:"eventLevel"`
	Aggregatable AttributionReportingAggregatableResult   `json:"aggregatable"`
}
