/*++
Copyright (c) 2006 Microsoft Corporation

Module Name:

    pattern_inference_params.h

Abstract:

    <abstract>

Author:

    Leonardo de Moura (leonardo) 2008-03-24.

Revision History:

--*/
#pragma once

#include "util/params.h"

enum arith_pattern_inference_kind {
    AP_NO,           // do not infer patterns with arithmetic terms
    AP_CONSERVATIVE, // only infer patterns with arithmetic terms if there is no other option
    AP_FULL          // always use patterns with arithmetic terms
};

struct pattern_inference_params {
    bool                          m_pi_enabled = true;
    unsigned                      m_pi_max_multi_patterns = 1; 
    bool                          m_pi_block_loop_patterns; 
    bool                          m_pi_decompose_patterns;
    arith_pattern_inference_kind  m_pi_arith;
    bool                          m_pi_use_database;
    unsigned                      m_pi_arith_weight;
    unsigned                      m_pi_non_nested_arith_weight;
    bool                          m_pi_pull_quantifiers;
    int                           m_pi_nopat_weight = -1;
    bool                          m_pi_avoid_skolems = true;
    bool                          m_pi_warnings;
    
    pattern_inference_params(params_ref const & p = params_ref()) {
        updt_params(p);
    }

    void updt_params(params_ref const & _p);

    void display(std::ostream & out) const;
};


