/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.10.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html2.h"
        #include <wx/webview.h>
        #include <wx/filesys.h>


class sipwxWebViewHandler : public ::wxWebViewHandler
{
public:
    sipwxWebViewHandler(const ::wxString&);
    sipwxWebViewHandler(const ::wxWebViewHandler&);
    virtual ~sipwxWebViewHandler();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxString GetSecurityURL() const SIP_OVERRIDE;
    void SetSecurityURL(const ::wxString&) SIP_OVERRIDE;
    ::wxString GetName() const SIP_OVERRIDE;
    ::wxFSFile* GetFile(const ::wxString&) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxWebViewHandler(const sipwxWebViewHandler &);
    sipwxWebViewHandler &operator = (const sipwxWebViewHandler &);

    char sipPyMethods[4];
};

sipwxWebViewHandler::sipwxWebViewHandler(const ::wxString& scheme): ::wxWebViewHandler(scheme), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxWebViewHandler::sipwxWebViewHandler(const ::wxWebViewHandler& a0): ::wxWebViewHandler(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxWebViewHandler::~sipwxWebViewHandler()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxString sipwxWebViewHandler::GetSecurityURL() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetSecurityURL);

    if (!sipMeth)
        return ::wxWebViewHandler::GetSecurityURL();

    extern ::wxString sipVH__html2_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html2_1(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxWebViewHandler::SetSecurityURL(const ::wxString& url)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_SetSecurityURL);

    if (!sipMeth)
    {
        ::wxWebViewHandler::SetSecurityURL(url);
        return;
    }

    extern void sipVH__html2_2(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxString&);

    sipVH__html2_2(sipGILState, 0, sipPySelf, sipMeth, url);
}

::wxString sipwxWebViewHandler::GetName() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[2]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetName);

    if (!sipMeth)
        return ::wxWebViewHandler::GetName();

    extern ::wxString sipVH__html2_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html2_1(sipGILState, 0, sipPySelf, sipMeth);
}

::wxFSFile* sipwxWebViewHandler::GetFile(const ::wxString& uri)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, sipName_WebViewHandler, sipName_GetFile);

    if (!sipMeth)
        return 0;

    extern ::wxFSFile* sipVH__html2_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxString&);

    return sipVH__html2_0(sipGILState, 0, sipPySelf, sipMeth, uri);
}


PyDoc_STRVAR(doc_wxWebViewHandler_GetFile, "GetFile(uri) -> wx.FSFile");

extern "C" {static PyObject *meth_wxWebViewHandler_GetFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxWebViewHandler_GetFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxString* uri;
        int uriState = 0;
        ::wxWebViewHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_uri,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxWebViewHandler, &sipCpp, sipType_wxString, &uri, &uriState))
        {
            ::wxFSFile*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_WebViewHandler, sipName_GetFile);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFile(*uri);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(uri), sipType_wxString, uriState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFSFile, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewHandler, sipName_GetFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewHandler_GetName, "GetName() -> str");

extern "C" {static PyObject *meth_wxWebViewHandler_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewHandler_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxWebViewHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewHandler, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString((sipSelfWasArg ? sipCpp->::wxWebViewHandler::GetName() : sipCpp->GetName()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewHandler, sipName_GetName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewHandler_SetSecurityURL, "SetSecurityURL(url) -> None\n"
"\n"
"Sets a custom security URL.");

extern "C" {static PyObject *meth_wxWebViewHandler_SetSecurityURL(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxWebViewHandler_SetSecurityURL(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxString* url;
        int urlState = 0;
        ::wxWebViewHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_url,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxWebViewHandler, &sipCpp, sipType_wxString, &url, &urlState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxWebViewHandler::SetSecurityURL(*url) : sipCpp->SetSecurityURL(*url));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(url), sipType_wxString, urlState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewHandler, sipName_SetSecurityURL, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewHandler_GetSecurityURL, "GetSecurityURL() -> str");

extern "C" {static PyObject *meth_wxWebViewHandler_GetSecurityURL(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewHandler_GetSecurityURL(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxWebViewHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewHandler, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString((sipSelfWasArg ? sipCpp->::wxWebViewHandler::GetSecurityURL() : sipCpp->GetSecurityURL()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewHandler, sipName_GetSecurityURL, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxWebViewHandler(void *, int);}
static void release_wxWebViewHandler(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxWebViewHandler *>(sipCppV);
    else
        delete reinterpret_cast<::wxWebViewHandler *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxWebViewHandler(sipSimpleWrapper *);}
static void dealloc_wxWebViewHandler(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxWebViewHandler *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxWebViewHandler(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxWebViewHandler(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxWebViewHandler(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxWebViewHandler *sipCpp = SIP_NULLPTR;

    {
        const ::wxString* scheme;
        int schemeState = 0;

        static const char *sipKwdList[] = {
            sipName_scheme,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxString, &scheme, &schemeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxWebViewHandler(*scheme);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(scheme), sipType_wxString, schemeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxWebViewHandler* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxWebViewHandler, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxWebViewHandler(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxWebViewHandler[] = {
    {sipName_GetFile, SIP_MLMETH_CAST(meth_wxWebViewHandler_GetFile), METH_VARARGS|METH_KEYWORDS, doc_wxWebViewHandler_GetFile},
    {sipName_GetName, meth_wxWebViewHandler_GetName, METH_VARARGS, doc_wxWebViewHandler_GetName},
    {sipName_GetSecurityURL, meth_wxWebViewHandler_GetSecurityURL, METH_VARARGS, doc_wxWebViewHandler_GetSecurityURL},
    {sipName_SetSecurityURL, SIP_MLMETH_CAST(meth_wxWebViewHandler_SetSecurityURL), METH_VARARGS|METH_KEYWORDS, doc_wxWebViewHandler_SetSecurityURL}
};

sipVariableDef variables_wxWebViewHandler[] = {
    {PropertyVariable, sipName_SecurityURL, &methods_wxWebViewHandler[2], &methods_wxWebViewHandler[3], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Name, &methods_wxWebViewHandler[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxWebViewHandler, "WebViewHandler(scheme) -> None\n"
"\n"
"The base class for handling custom schemes in wxWebView, for example\n"
"to allow virtual file system support.");


sipClassTypeDef sipTypeDef__html2_wxWebViewHandler = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxWebViewHandler,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_WebViewHandler,
        {0, 0, 1},
        4, methods_wxWebViewHandler,
        0, SIP_NULLPTR,
        2, variables_wxWebViewHandler,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxWebViewHandler,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxWebViewHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxWebViewHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxWebViewHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxWebViewHandler),
};
