/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "../../libdrgn/tests/hexlify.c.in" instead.
 */

#include <check.h>

#line 1 "../../libdrgn/tests/hexlify.c.in"
// Copyright (c) Meta Platforms, Inc. and affiliates.
// SPDX-License-Identifier: LGPL-2.1-or-later

#include <stdint.h>

#include "test_util.h"
#include "../cleanup.h"
#include "../hexlify.h"

static const uint8_t binary[] = {
	0x19, 0x29, 0x1d, 0x9a, 0xc4, 0xf3, 0x4c, 0x42, 0x01, 0xee,
	0xdf, 0x9e, 0x8d, 0x1e, 0x59, 0x68, 0xf7, 0xd5, 0x48, 0x19,
};
static const char str[] = "19291d9ac4f34c4201eedf9e8d1e5968f7d54819";



START_TEST(hexlify_simple)
{
#line 21
{
	char out[2 * sizeof(binary) + 1];
	out[sizeof(out) - 1] = '~';
	hexlify(binary, sizeof(binary), out);
	ck_assert_mem_eq(out, str, sizeof(out) - 1);
	// Test that the string wasn't null-terminated.
	ck_assert_int_eq(out[sizeof(out) - 1], '~');
}

}
END_TEST

START_TEST(ahexlify_simple)
{
#line 31
{
	_cleanup_free_ char *out = ahexlify(binary, sizeof(binary));
	ck_assert_ptr_nonnull(out);
	ck_assert_str_eq(out, str);
}

}
END_TEST

START_TEST(unhexlify_simple)
{
#line 38
{
	uint8_t out[(sizeof(str) - 1) / 2];
	ck_assert(unhexlify(str, sizeof(str) - 1, out));
	ck_assert_mem_eq(out, binary, sizeof(binary));
}

}
END_TEST

START_TEST(unhexlify_odd)
{
#line 45
{
	ck_assert(!unhexlify("abc", 3, (uint8_t [1]){}));
}

}
END_TEST

START_TEST(unhexlify_non_hex)
{
#line 50
{
	ck_assert(!unhexlify("foobar", 6, (uint8_t [3]){}));
}
}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("hexlify");
    TCase *tc1_1 = tcase_create("hexlify");
    SRunner *sr = srunner_create(s1);
    int nf;

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, hexlify_simple);
    tcase_add_test(tc1_1, ahexlify_simple);
    tcase_add_test(tc1_1, unhexlify_simple);
    tcase_add_test(tc1_1, unhexlify_odd);
    tcase_add_test(tc1_1, unhexlify_non_hex);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
