/* eslint-disable */
/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */

/**
 * JSON Schema definitions for Claude CLI tool inputs
 */
export type ToolInputSchemas =
  | AgentInput
  | BashInput
  | TaskOutputInput
  | ExitPlanModeInput
  | FileEditInput
  | FileReadInput
  | FileWriteInput
  | GlobInput
  | GrepInput
  | KillShellInput
  | ListMcpResourcesInput
  | McpInput
  | NotebookEditInput
  | ReadMcpResourceInput
  | TodoWriteInput
  | WebFetchInput
  | WebSearchInput
  | AskUserQuestionInput
  | ConfigInput;

export interface AgentInput {
  /**
   * A short (3-5 word) description of the task
   */
  description: string;
  /**
   * The task for the agent to perform
   */
  prompt: string;
  /**
   * The type of specialized agent to use for this task
   */
  subagent_type: string;
  /**
   * Optional model to use for this agent. If not specified, inherits from parent. Prefer haiku for quick, straightforward tasks to minimize cost and latency.
   */
  model?: "sonnet" | "opus" | "haiku";
  /**
   * Optional agent ID to resume from. If provided, the agent will continue from the previous execution transcript.
   */
  resume?: string;
  /**
   * Set to true to run this agent in the background. The tool result will include an output_file path - use Read tool or Bash tail to check on output.
   */
  run_in_background?: boolean;
  /**
   * Maximum number of agentic turns (API round-trips) before stopping. Used internally for warmup.
   */
  max_turns?: number;
}
export interface BashInput {
  /**
   * The command to execute
   */
  command: string;
  /**
   * Optional timeout in milliseconds (max 600000)
   */
  timeout?: number;
  /**
   * Clear, concise description of what this command does in active voice. Never use words like "complex" or "risk" in the description - just describe what it does.
   *
   * For simple commands (git, npm, standard CLI tools), keep it brief (5-10 words):
   * - ls → "List files in current directory"
   * - git status → "Show working tree status"
   * - npm install → "Install package dependencies"
   *
   * For commands that are harder to parse at a glance (piped commands, obscure flags, etc.), add enough context to clarify what it does:
   * - find . -name "*.tmp" -exec rm {} \; → "Find and delete all .tmp files recursively"
   * - git reset --hard origin/main → "Discard all local changes and match remote main"
   * - curl -s url | jq '.data[]' → "Fetch JSON from URL and extract data array elements"
   */
  description?: string;
  /**
   * Set to true to run this command in the background. Use TaskOutput to read the output later.
   */
  run_in_background?: boolean;
  /**
   * Set this to true to dangerously override sandbox mode and run commands without sandboxing.
   */
  dangerouslyDisableSandbox?: boolean;
  /**
   * Internal: pre-computed sed edit result from preview
   */
  _simulatedSedEdit?: {
    filePath: string;
    newContent: string;
  };
}
export interface TaskOutputInput {
  /**
   * The task ID to get output from
   */
  task_id: string;
  /**
   * Whether to wait for completion
   */
  block: boolean;
  /**
   * Max wait time in ms
   */
  timeout: number;
}
export interface ExitPlanModeInput {
  /**
   * Prompt-based permissions needed to implement the plan. These describe categories of actions rather than specific commands.
   */
  allowedPrompts?: {
    /**
     * The tool this prompt applies to
     */
    tool: "Bash";
    /**
     * Semantic description of the action, e.g. "run tests", "install dependencies"
     */
    prompt: string;
  }[];
  [k: string]: unknown;
}
export interface FileEditInput {
  /**
   * The absolute path to the file to modify
   */
  file_path: string;
  /**
   * The text to replace
   */
  old_string: string;
  /**
   * The text to replace it with (must be different from old_string)
   */
  new_string: string;
  /**
   * Replace all occurences of old_string (default false)
   */
  replace_all?: boolean;
}
export interface FileReadInput {
  /**
   * The absolute path to the file to read
   */
  file_path: string;
  /**
   * The line number to start reading from. Only provide if the file is too large to read at once
   */
  offset?: number;
  /**
   * The number of lines to read. Only provide if the file is too large to read at once.
   */
  limit?: number;
}
export interface FileWriteInput {
  /**
   * The absolute path to the file to write (must be absolute, not relative)
   */
  file_path: string;
  /**
   * The content to write to the file
   */
  content: string;
}
export interface GlobInput {
  /**
   * The glob pattern to match files against
   */
  pattern: string;
  /**
   * The directory to search in. If not specified, the current working directory will be used. IMPORTANT: Omit this field to use the default directory. DO NOT enter "undefined" or "null" - simply omit it for the default behavior. Must be a valid directory path if provided.
   */
  path?: string;
}
export interface GrepInput {
  /**
   * The regular expression pattern to search for in file contents
   */
  pattern: string;
  /**
   * File or directory to search in (rg PATH). Defaults to current working directory.
   */
  path?: string;
  /**
   * Glob pattern to filter files (e.g. "*.js", "*.{ts,tsx}") - maps to rg --glob
   */
  glob?: string;
  /**
   * Output mode: "content" shows matching lines (supports -A/-B/-C context, -n line numbers, head_limit), "files_with_matches" shows file paths (supports head_limit), "count" shows match counts (supports head_limit). Defaults to "files_with_matches".
   */
  output_mode?: "content" | "files_with_matches" | "count";
  /**
   * Number of lines to show before each match (rg -B). Requires output_mode: "content", ignored otherwise.
   */
  "-B"?: number;
  /**
   * Number of lines to show after each match (rg -A). Requires output_mode: "content", ignored otherwise.
   */
  "-A"?: number;
  /**
   * Number of lines to show before and after each match (rg -C). Requires output_mode: "content", ignored otherwise.
   */
  "-C"?: number;
  /**
   * Show line numbers in output (rg -n). Requires output_mode: "content", ignored otherwise. Defaults to true.
   */
  "-n"?: boolean;
  /**
   * Case insensitive search (rg -i)
   */
  "-i"?: boolean;
  /**
   * File type to search (rg --type). Common types: js, py, rust, go, java, etc. More efficient than include for standard file types.
   */
  type?: string;
  /**
   * Limit output to first N lines/entries, equivalent to "| head -N". Works across all output modes: content (limits output lines), files_with_matches (limits file paths), count (limits count entries). Defaults to 0 (unlimited).
   */
  head_limit?: number;
  /**
   * Skip first N lines/entries before applying head_limit, equivalent to "| tail -n +N | head -N". Works across all output modes. Defaults to 0.
   */
  offset?: number;
  /**
   * Enable multiline mode where . matches newlines and patterns can span lines (rg -U --multiline-dotall). Default: false.
   */
  multiline?: boolean;
}
export interface KillShellInput {
  /**
   * The ID of the background shell to kill
   */
  shell_id: string;
}
export interface ListMcpResourcesInput {
  /**
   * Optional server name to filter resources by
   */
  server?: string;
}
export interface McpInput {
  [k: string]: unknown;
}
export interface NotebookEditInput {
  /**
   * The absolute path to the Jupyter notebook file to edit (must be absolute, not relative)
   */
  notebook_path: string;
  /**
   * The ID of the cell to edit. When inserting a new cell, the new cell will be inserted after the cell with this ID, or at the beginning if not specified.
   */
  cell_id?: string;
  /**
   * The new source for the cell
   */
  new_source: string;
  /**
   * The type of the cell (code or markdown). If not specified, it defaults to the current cell type. If using edit_mode=insert, this is required.
   */
  cell_type?: "code" | "markdown";
  /**
   * The type of edit to make (replace, insert, delete). Defaults to replace.
   */
  edit_mode?: "replace" | "insert" | "delete";
}
export interface ReadMcpResourceInput {
  /**
   * The MCP server name
   */
  server: string;
  /**
   * The resource URI to read
   */
  uri: string;
}
export interface TodoWriteInput {
  /**
   * The updated todo list
   */
  todos: {
    content: string;
    status: "pending" | "in_progress" | "completed";
    activeForm: string;
  }[];
}
export interface WebFetchInput {
  /**
   * The URL to fetch content from
   */
  url: string;
  /**
   * The prompt to run on the fetched content
   */
  prompt: string;
}
export interface WebSearchInput {
  /**
   * The search query to use
   */
  query: string;
  /**
   * Only include search results from these domains
   */
  allowed_domains?: string[];
  /**
   * Never include search results from these domains
   */
  blocked_domains?: string[];
}
export interface AskUserQuestionInput {
  /**
   * Questions to ask the user (1-4 questions)
   *
   * @minItems 1
   * @maxItems 4
   */
  questions:
    | [
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        }
      ]
    | [
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        },
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        }
      ]
    | [
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        },
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        },
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        }
      ]
    | [
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        },
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        },
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        },
        {
          /**
           * The complete question to ask the user. Should be clear, specific, and end with a question mark. Example: "Which library should we use for date formatting?" If multiSelect is true, phrase it accordingly, e.g. "Which features do you want to enable?"
           */
          question: string;
          /**
           * Very short label displayed as a chip/tag (max 12 chars). Examples: "Auth method", "Library", "Approach".
           */
          header: string;
          /**
           * The available choices for this question. Must have 2-4 options. Each option should be a distinct, mutually exclusive choice (unless multiSelect is enabled). There should be no 'Other' option, that will be provided automatically.
           *
           * @minItems 2
           * @maxItems 4
           */
          options:
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ]
            | [
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                },
                {
                  /**
                   * The display text for this option that the user will see and select. Should be concise (1-5 words) and clearly describe the choice.
                   */
                  label: string;
                  /**
                   * Explanation of what this option means or what will happen if chosen. Useful for providing context about trade-offs or implications.
                   */
                  description: string;
                }
              ];
          /**
           * Set to true to allow the user to select multiple options instead of just one. Use when choices are not mutually exclusive.
           */
          multiSelect: boolean;
        }
      ];
  /**
   * User answers collected by the permission component
   */
  answers?: {
    [k: string]: string;
  };
  /**
   * Optional metadata for tracking and analytics purposes. Not displayed to user.
   */
  metadata?: {
    /**
     * Optional identifier for the source of this question (e.g., "remember" for /remember command). Used for analytics tracking.
     */
    source?: string;
  };
}
export interface ConfigInput {
  /**
   * The setting key (e.g., "theme", "model", "permissions.defaultMode")
   */
  setting: string;
  /**
   * The new value. Omit to get current value.
   */
  value?: string | boolean | number;
}
