//*
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//*
// These .proto interfaces are private and stable.
// Please see http://wiki.apache.org/hadoop/Compatibility
// for what changes are allowed for a *stable* .proto interface.

// This file contains protocol buffers that are used throughout HDFS -- i.e.
// by the client, server, and data transfer protocols.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: HdfsServer.proto

package hadoop_hdfs

import (
	_ "github.com/colinmarc/hdfs/v2/internal/protocol/hadoop_common"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

//*
// State of a block replica at a datanode
type ReplicaStateProto int32

const (
	ReplicaStateProto_FINALIZED ReplicaStateProto = 0 // State of a replica when it is not modified
	ReplicaStateProto_RBW       ReplicaStateProto = 1 // State of replica that is being written to
	ReplicaStateProto_RWR       ReplicaStateProto = 2 // State of replica that is waiting to be recovered
	ReplicaStateProto_RUR       ReplicaStateProto = 3 // State of replica that is under recovery
	ReplicaStateProto_TEMPORARY ReplicaStateProto = 4 // State of replica that is created for replication
)

// Enum value maps for ReplicaStateProto.
var (
	ReplicaStateProto_name = map[int32]string{
		0: "FINALIZED",
		1: "RBW",
		2: "RWR",
		3: "RUR",
		4: "TEMPORARY",
	}
	ReplicaStateProto_value = map[string]int32{
		"FINALIZED": 0,
		"RBW":       1,
		"RWR":       2,
		"RUR":       3,
		"TEMPORARY": 4,
	}
)

func (x ReplicaStateProto) Enum() *ReplicaStateProto {
	p := new(ReplicaStateProto)
	*p = x
	return p
}

func (x ReplicaStateProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReplicaStateProto) Descriptor() protoreflect.EnumDescriptor {
	return file_HdfsServer_proto_enumTypes[0].Descriptor()
}

func (ReplicaStateProto) Type() protoreflect.EnumType {
	return &file_HdfsServer_proto_enumTypes[0]
}

func (x ReplicaStateProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ReplicaStateProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ReplicaStateProto(num)
	return nil
}

// Deprecated: Use ReplicaStateProto.Descriptor instead.
func (ReplicaStateProto) EnumDescriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{0}
}

type NamenodeCommandProto_Type int32

const (
	NamenodeCommandProto_NamenodeCommand   NamenodeCommandProto_Type = 0 // Base command
	NamenodeCommandProto_CheckPointCommand NamenodeCommandProto_Type = 1 // Check point command
)

// Enum value maps for NamenodeCommandProto_Type.
var (
	NamenodeCommandProto_Type_name = map[int32]string{
		0: "NamenodeCommand",
		1: "CheckPointCommand",
	}
	NamenodeCommandProto_Type_value = map[string]int32{
		"NamenodeCommand":   0,
		"CheckPointCommand": 1,
	}
)

func (x NamenodeCommandProto_Type) Enum() *NamenodeCommandProto_Type {
	p := new(NamenodeCommandProto_Type)
	*p = x
	return p
}

func (x NamenodeCommandProto_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NamenodeCommandProto_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_HdfsServer_proto_enumTypes[1].Descriptor()
}

func (NamenodeCommandProto_Type) Type() protoreflect.EnumType {
	return &file_HdfsServer_proto_enumTypes[1]
}

func (x NamenodeCommandProto_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *NamenodeCommandProto_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = NamenodeCommandProto_Type(num)
	return nil
}

// Deprecated: Use NamenodeCommandProto_Type.Descriptor instead.
func (NamenodeCommandProto_Type) EnumDescriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{10, 0}
}

type NamenodeRegistrationProto_NamenodeRoleProto int32

const (
	NamenodeRegistrationProto_NAMENODE   NamenodeRegistrationProto_NamenodeRoleProto = 1
	NamenodeRegistrationProto_BACKUP     NamenodeRegistrationProto_NamenodeRoleProto = 2
	NamenodeRegistrationProto_CHECKPOINT NamenodeRegistrationProto_NamenodeRoleProto = 3
)

// Enum value maps for NamenodeRegistrationProto_NamenodeRoleProto.
var (
	NamenodeRegistrationProto_NamenodeRoleProto_name = map[int32]string{
		1: "NAMENODE",
		2: "BACKUP",
		3: "CHECKPOINT",
	}
	NamenodeRegistrationProto_NamenodeRoleProto_value = map[string]int32{
		"NAMENODE":   1,
		"BACKUP":     2,
		"CHECKPOINT": 3,
	}
)

func (x NamenodeRegistrationProto_NamenodeRoleProto) Enum() *NamenodeRegistrationProto_NamenodeRoleProto {
	p := new(NamenodeRegistrationProto_NamenodeRoleProto)
	*p = x
	return p
}

func (x NamenodeRegistrationProto_NamenodeRoleProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NamenodeRegistrationProto_NamenodeRoleProto) Descriptor() protoreflect.EnumDescriptor {
	return file_HdfsServer_proto_enumTypes[2].Descriptor()
}

func (NamenodeRegistrationProto_NamenodeRoleProto) Type() protoreflect.EnumType {
	return &file_HdfsServer_proto_enumTypes[2]
}

func (x NamenodeRegistrationProto_NamenodeRoleProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *NamenodeRegistrationProto_NamenodeRoleProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = NamenodeRegistrationProto_NamenodeRoleProto(num)
	return nil
}

// Deprecated: Use NamenodeRegistrationProto_NamenodeRoleProto.Descriptor instead.
func (NamenodeRegistrationProto_NamenodeRoleProto) EnumDescriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{14, 0}
}

type NNHAStatusHeartbeatProto_State int32

const (
	NNHAStatusHeartbeatProto_ACTIVE   NNHAStatusHeartbeatProto_State = 0
	NNHAStatusHeartbeatProto_STANDBY  NNHAStatusHeartbeatProto_State = 1
	NNHAStatusHeartbeatProto_OBSERVER NNHAStatusHeartbeatProto_State = 2
)

// Enum value maps for NNHAStatusHeartbeatProto_State.
var (
	NNHAStatusHeartbeatProto_State_name = map[int32]string{
		0: "ACTIVE",
		1: "STANDBY",
		2: "OBSERVER",
	}
	NNHAStatusHeartbeatProto_State_value = map[string]int32{
		"ACTIVE":   0,
		"STANDBY":  1,
		"OBSERVER": 2,
	}
)

func (x NNHAStatusHeartbeatProto_State) Enum() *NNHAStatusHeartbeatProto_State {
	p := new(NNHAStatusHeartbeatProto_State)
	*p = x
	return p
}

func (x NNHAStatusHeartbeatProto_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NNHAStatusHeartbeatProto_State) Descriptor() protoreflect.EnumDescriptor {
	return file_HdfsServer_proto_enumTypes[3].Descriptor()
}

func (NNHAStatusHeartbeatProto_State) Type() protoreflect.EnumType {
	return &file_HdfsServer_proto_enumTypes[3]
}

func (x NNHAStatusHeartbeatProto_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *NNHAStatusHeartbeatProto_State) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = NNHAStatusHeartbeatProto_State(num)
	return nil
}

// Deprecated: Use NNHAStatusHeartbeatProto_State.Descriptor instead.
func (NNHAStatusHeartbeatProto_State) EnumDescriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{15, 0}
}

//*
// Block access token information
type BlockKeyProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyId      *uint32 `protobuf:"varint,1,req,name=keyId" json:"keyId,omitempty"`           // Key identifier
	ExpiryDate *uint64 `protobuf:"varint,2,req,name=expiryDate" json:"expiryDate,omitempty"` // Expiry time in milliseconds
	KeyBytes   []byte  `protobuf:"bytes,3,opt,name=keyBytes" json:"keyBytes,omitempty"`      // Key secret
}

func (x *BlockKeyProto) Reset() {
	*x = BlockKeyProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlockKeyProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlockKeyProto) ProtoMessage() {}

func (x *BlockKeyProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlockKeyProto.ProtoReflect.Descriptor instead.
func (*BlockKeyProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{0}
}

func (x *BlockKeyProto) GetKeyId() uint32 {
	if x != nil && x.KeyId != nil {
		return *x.KeyId
	}
	return 0
}

func (x *BlockKeyProto) GetExpiryDate() uint64 {
	if x != nil && x.ExpiryDate != nil {
		return *x.ExpiryDate
	}
	return 0
}

func (x *BlockKeyProto) GetKeyBytes() []byte {
	if x != nil {
		return x.KeyBytes
	}
	return nil
}

//*
// Current key and set of block keys at the namenode.
type ExportedBlockKeysProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IsBlockTokenEnabled *bool            `protobuf:"varint,1,req,name=isBlockTokenEnabled" json:"isBlockTokenEnabled,omitempty"`
	KeyUpdateInterval   *uint64          `protobuf:"varint,2,req,name=keyUpdateInterval" json:"keyUpdateInterval,omitempty"`
	TokenLifeTime       *uint64          `protobuf:"varint,3,req,name=tokenLifeTime" json:"tokenLifeTime,omitempty"`
	CurrentKey          *BlockKeyProto   `protobuf:"bytes,4,req,name=currentKey" json:"currentKey,omitempty"`
	AllKeys             []*BlockKeyProto `protobuf:"bytes,5,rep,name=allKeys" json:"allKeys,omitempty"`
}

func (x *ExportedBlockKeysProto) Reset() {
	*x = ExportedBlockKeysProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportedBlockKeysProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportedBlockKeysProto) ProtoMessage() {}

func (x *ExportedBlockKeysProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportedBlockKeysProto.ProtoReflect.Descriptor instead.
func (*ExportedBlockKeysProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{1}
}

func (x *ExportedBlockKeysProto) GetIsBlockTokenEnabled() bool {
	if x != nil && x.IsBlockTokenEnabled != nil {
		return *x.IsBlockTokenEnabled
	}
	return false
}

func (x *ExportedBlockKeysProto) GetKeyUpdateInterval() uint64 {
	if x != nil && x.KeyUpdateInterval != nil {
		return *x.KeyUpdateInterval
	}
	return 0
}

func (x *ExportedBlockKeysProto) GetTokenLifeTime() uint64 {
	if x != nil && x.TokenLifeTime != nil {
		return *x.TokenLifeTime
	}
	return 0
}

func (x *ExportedBlockKeysProto) GetCurrentKey() *BlockKeyProto {
	if x != nil {
		return x.CurrentKey
	}
	return nil
}

func (x *ExportedBlockKeysProto) GetAllKeys() []*BlockKeyProto {
	if x != nil {
		return x.AllKeys
	}
	return nil
}

//*
// Block and datanodes where is it located
type BlockWithLocationsProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Block         *BlockProto        `protobuf:"bytes,1,req,name=block" json:"block,omitempty"`                 // Block
	DatanodeUuids []string           `protobuf:"bytes,2,rep,name=datanodeUuids" json:"datanodeUuids,omitempty"` // Datanodes with replicas of the block
	StorageUuids  []string           `protobuf:"bytes,3,rep,name=storageUuids" json:"storageUuids,omitempty"`   // Storages with replicas of the block
	StorageTypes  []StorageTypeProto `protobuf:"varint,4,rep,name=storageTypes,enum=hadoop.hdfs.StorageTypeProto" json:"storageTypes,omitempty"`
	Indices       []byte             `protobuf:"bytes,5,opt,name=indices" json:"indices,omitempty"`
	DataBlockNum  *uint32            `protobuf:"varint,6,opt,name=dataBlockNum" json:"dataBlockNum,omitempty"`
	CellSize      *uint32            `protobuf:"varint,7,opt,name=cellSize" json:"cellSize,omitempty"`
}

func (x *BlockWithLocationsProto) Reset() {
	*x = BlockWithLocationsProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlockWithLocationsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlockWithLocationsProto) ProtoMessage() {}

func (x *BlockWithLocationsProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlockWithLocationsProto.ProtoReflect.Descriptor instead.
func (*BlockWithLocationsProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{2}
}

func (x *BlockWithLocationsProto) GetBlock() *BlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *BlockWithLocationsProto) GetDatanodeUuids() []string {
	if x != nil {
		return x.DatanodeUuids
	}
	return nil
}

func (x *BlockWithLocationsProto) GetStorageUuids() []string {
	if x != nil {
		return x.StorageUuids
	}
	return nil
}

func (x *BlockWithLocationsProto) GetStorageTypes() []StorageTypeProto {
	if x != nil {
		return x.StorageTypes
	}
	return nil
}

func (x *BlockWithLocationsProto) GetIndices() []byte {
	if x != nil {
		return x.Indices
	}
	return nil
}

func (x *BlockWithLocationsProto) GetDataBlockNum() uint32 {
	if x != nil && x.DataBlockNum != nil {
		return *x.DataBlockNum
	}
	return 0
}

func (x *BlockWithLocationsProto) GetCellSize() uint32 {
	if x != nil && x.CellSize != nil {
		return *x.CellSize
	}
	return 0
}

//*
// List of block with locations
type BlocksWithLocationsProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Blocks []*BlockWithLocationsProto `protobuf:"bytes,1,rep,name=blocks" json:"blocks,omitempty"`
}

func (x *BlocksWithLocationsProto) Reset() {
	*x = BlocksWithLocationsProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlocksWithLocationsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlocksWithLocationsProto) ProtoMessage() {}

func (x *BlocksWithLocationsProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlocksWithLocationsProto.ProtoReflect.Descriptor instead.
func (*BlocksWithLocationsProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{3}
}

func (x *BlocksWithLocationsProto) GetBlocks() []*BlockWithLocationsProto {
	if x != nil {
		return x.Blocks
	}
	return nil
}

//*
// Editlog information with available transactions
type RemoteEditLogProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartTxId    *uint64 `protobuf:"varint,1,req,name=startTxId" json:"startTxId,omitempty"` // Starting available edit log transaction
	EndTxId      *uint64 `protobuf:"varint,2,req,name=endTxId" json:"endTxId,omitempty"`     // Ending available edit log transaction
	IsInProgress *bool   `protobuf:"varint,3,opt,name=isInProgress,def=0" json:"isInProgress,omitempty"`
}

// Default values for RemoteEditLogProto fields.
const (
	Default_RemoteEditLogProto_IsInProgress = bool(false)
)

func (x *RemoteEditLogProto) Reset() {
	*x = RemoteEditLogProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteEditLogProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteEditLogProto) ProtoMessage() {}

func (x *RemoteEditLogProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteEditLogProto.ProtoReflect.Descriptor instead.
func (*RemoteEditLogProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{4}
}

func (x *RemoteEditLogProto) GetStartTxId() uint64 {
	if x != nil && x.StartTxId != nil {
		return *x.StartTxId
	}
	return 0
}

func (x *RemoteEditLogProto) GetEndTxId() uint64 {
	if x != nil && x.EndTxId != nil {
		return *x.EndTxId
	}
	return 0
}

func (x *RemoteEditLogProto) GetIsInProgress() bool {
	if x != nil && x.IsInProgress != nil {
		return *x.IsInProgress
	}
	return Default_RemoteEditLogProto_IsInProgress
}

//*
// Enumeration of editlogs available on a remote namenode
type RemoteEditLogManifestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Logs           []*RemoteEditLogProto `protobuf:"bytes,1,rep,name=logs" json:"logs,omitempty"`
	CommittedTxnId *uint64               `protobuf:"varint,2,opt,name=committedTxnId" json:"committedTxnId,omitempty"`
}

func (x *RemoteEditLogManifestProto) Reset() {
	*x = RemoteEditLogManifestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteEditLogManifestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteEditLogManifestProto) ProtoMessage() {}

func (x *RemoteEditLogManifestProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteEditLogManifestProto.ProtoReflect.Descriptor instead.
func (*RemoteEditLogManifestProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{5}
}

func (x *RemoteEditLogManifestProto) GetLogs() []*RemoteEditLogProto {
	if x != nil {
		return x.Logs
	}
	return nil
}

func (x *RemoteEditLogManifestProto) GetCommittedTxnId() uint64 {
	if x != nil && x.CommittedTxnId != nil {
		return *x.CommittedTxnId
	}
	return 0
}

//*
// Namespace information that describes namespace on a namenode
type NamespaceInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BuildVersion    *string                         `protobuf:"bytes,1,req,name=buildVersion" json:"buildVersion,omitempty"`        // Software revision version (e.g. an svn or git revision)
	Unused          *uint32                         `protobuf:"varint,2,req,name=unused" json:"unused,omitempty"`                   // Retained for backward compatibility
	BlockPoolID     *string                         `protobuf:"bytes,3,req,name=blockPoolID" json:"blockPoolID,omitempty"`          // block pool used by the namespace
	StorageInfo     *StorageInfoProto               `protobuf:"bytes,4,req,name=storageInfo" json:"storageInfo,omitempty"`          // Node information
	SoftwareVersion *string                         `protobuf:"bytes,5,req,name=softwareVersion" json:"softwareVersion,omitempty"`  // Software version number (e.g. 2.0.0)
	Capabilities    *uint64                         `protobuf:"varint,6,opt,name=capabilities,def=0" json:"capabilities,omitempty"` // feature flags
	State           *NNHAStatusHeartbeatProto_State `protobuf:"varint,7,opt,name=state,enum=hadoop.hdfs.NNHAStatusHeartbeatProto_State" json:"state,omitempty"`
}

// Default values for NamespaceInfoProto fields.
const (
	Default_NamespaceInfoProto_Capabilities = uint64(0)
)

func (x *NamespaceInfoProto) Reset() {
	*x = NamespaceInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceInfoProto) ProtoMessage() {}

func (x *NamespaceInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceInfoProto.ProtoReflect.Descriptor instead.
func (*NamespaceInfoProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{6}
}

func (x *NamespaceInfoProto) GetBuildVersion() string {
	if x != nil && x.BuildVersion != nil {
		return *x.BuildVersion
	}
	return ""
}

func (x *NamespaceInfoProto) GetUnused() uint32 {
	if x != nil && x.Unused != nil {
		return *x.Unused
	}
	return 0
}

func (x *NamespaceInfoProto) GetBlockPoolID() string {
	if x != nil && x.BlockPoolID != nil {
		return *x.BlockPoolID
	}
	return ""
}

func (x *NamespaceInfoProto) GetStorageInfo() *StorageInfoProto {
	if x != nil {
		return x.StorageInfo
	}
	return nil
}

func (x *NamespaceInfoProto) GetSoftwareVersion() string {
	if x != nil && x.SoftwareVersion != nil {
		return *x.SoftwareVersion
	}
	return ""
}

func (x *NamespaceInfoProto) GetCapabilities() uint64 {
	if x != nil && x.Capabilities != nil {
		return *x.Capabilities
	}
	return Default_NamespaceInfoProto_Capabilities
}

func (x *NamespaceInfoProto) GetState() NNHAStatusHeartbeatProto_State {
	if x != nil && x.State != nil {
		return *x.State
	}
	return NNHAStatusHeartbeatProto_ACTIVE
}

//*
// Block that needs to be recovered with at a given location
type RecoveringBlockProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NewGenStamp   *uint64                   `protobuf:"varint,1,req,name=newGenStamp" json:"newGenStamp,omitempty"`    // New genstamp post recovery
	Block         *LocatedBlockProto        `protobuf:"bytes,2,req,name=block" json:"block,omitempty"`                 // Block to be recovered
	TruncateBlock *BlockProto               `protobuf:"bytes,3,opt,name=truncateBlock" json:"truncateBlock,omitempty"` // New block for recovery (truncate)
	EcPolicy      *ErasureCodingPolicyProto `protobuf:"bytes,4,opt,name=ecPolicy" json:"ecPolicy,omitempty"`
	// block indices of striped internal blocks for each storage in LocatedBlock
	BlockIndices []byte `protobuf:"bytes,5,opt,name=blockIndices" json:"blockIndices,omitempty"`
}

func (x *RecoveringBlockProto) Reset() {
	*x = RecoveringBlockProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecoveringBlockProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecoveringBlockProto) ProtoMessage() {}

func (x *RecoveringBlockProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecoveringBlockProto.ProtoReflect.Descriptor instead.
func (*RecoveringBlockProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{7}
}

func (x *RecoveringBlockProto) GetNewGenStamp() uint64 {
	if x != nil && x.NewGenStamp != nil {
		return *x.NewGenStamp
	}
	return 0
}

func (x *RecoveringBlockProto) GetBlock() *LocatedBlockProto {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *RecoveringBlockProto) GetTruncateBlock() *BlockProto {
	if x != nil {
		return x.TruncateBlock
	}
	return nil
}

func (x *RecoveringBlockProto) GetEcPolicy() *ErasureCodingPolicyProto {
	if x != nil {
		return x.EcPolicy
	}
	return nil
}

func (x *RecoveringBlockProto) GetBlockIndices() []byte {
	if x != nil {
		return x.BlockIndices
	}
	return nil
}

//*
// Unique signature to identify checkpoint transactions.
type CheckpointSignatureProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BlockPoolId              *string           `protobuf:"bytes,1,req,name=blockPoolId" json:"blockPoolId,omitempty"`
	MostRecentCheckpointTxId *uint64           `protobuf:"varint,2,req,name=mostRecentCheckpointTxId" json:"mostRecentCheckpointTxId,omitempty"`
	CurSegmentTxId           *uint64           `protobuf:"varint,3,req,name=curSegmentTxId" json:"curSegmentTxId,omitempty"`
	StorageInfo              *StorageInfoProto `protobuf:"bytes,4,req,name=storageInfo" json:"storageInfo,omitempty"`
}

func (x *CheckpointSignatureProto) Reset() {
	*x = CheckpointSignatureProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckpointSignatureProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckpointSignatureProto) ProtoMessage() {}

func (x *CheckpointSignatureProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckpointSignatureProto.ProtoReflect.Descriptor instead.
func (*CheckpointSignatureProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{8}
}

func (x *CheckpointSignatureProto) GetBlockPoolId() string {
	if x != nil && x.BlockPoolId != nil {
		return *x.BlockPoolId
	}
	return ""
}

func (x *CheckpointSignatureProto) GetMostRecentCheckpointTxId() uint64 {
	if x != nil && x.MostRecentCheckpointTxId != nil {
		return *x.MostRecentCheckpointTxId
	}
	return 0
}

func (x *CheckpointSignatureProto) GetCurSegmentTxId() uint64 {
	if x != nil && x.CurSegmentTxId != nil {
		return *x.CurSegmentTxId
	}
	return 0
}

func (x *CheckpointSignatureProto) GetStorageInfo() *StorageInfoProto {
	if x != nil {
		return x.StorageInfo
	}
	return nil
}

//*
// Command returned from primary to checkpointing namenode.
// This command has checkpoint signature that identifies
// checkpoint transaction and is needed for further
// communication related to checkpointing.
type CheckpointCommandProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique signature to identify checkpoint transation
	Signature *CheckpointSignatureProto `protobuf:"bytes,1,req,name=signature" json:"signature,omitempty"`
	// If true, return transfer image to primary upon the completion of checkpoint
	NeedToReturnImage *bool `protobuf:"varint,2,req,name=needToReturnImage" json:"needToReturnImage,omitempty"`
}

func (x *CheckpointCommandProto) Reset() {
	*x = CheckpointCommandProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckpointCommandProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckpointCommandProto) ProtoMessage() {}

func (x *CheckpointCommandProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckpointCommandProto.ProtoReflect.Descriptor instead.
func (*CheckpointCommandProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{9}
}

func (x *CheckpointCommandProto) GetSignature() *CheckpointSignatureProto {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *CheckpointCommandProto) GetNeedToReturnImage() bool {
	if x != nil && x.NeedToReturnImage != nil {
		return *x.NeedToReturnImage
	}
	return false
}

//*
// Command sent from one namenode to another namenode.
type NamenodeCommandProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Action        *uint32                    `protobuf:"varint,1,req,name=action" json:"action,omitempty"`
	Type          *NamenodeCommandProto_Type `protobuf:"varint,2,req,name=type,enum=hadoop.hdfs.NamenodeCommandProto_Type" json:"type,omitempty"`
	CheckpointCmd *CheckpointCommandProto    `protobuf:"bytes,3,opt,name=checkpointCmd" json:"checkpointCmd,omitempty"`
}

func (x *NamenodeCommandProto) Reset() {
	*x = NamenodeCommandProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamenodeCommandProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamenodeCommandProto) ProtoMessage() {}

func (x *NamenodeCommandProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamenodeCommandProto.ProtoReflect.Descriptor instead.
func (*NamenodeCommandProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{10}
}

func (x *NamenodeCommandProto) GetAction() uint32 {
	if x != nil && x.Action != nil {
		return *x.Action
	}
	return 0
}

func (x *NamenodeCommandProto) GetType() NamenodeCommandProto_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return NamenodeCommandProto_NamenodeCommand
}

func (x *NamenodeCommandProto) GetCheckpointCmd() *CheckpointCommandProto {
	if x != nil {
		return x.CheckpointCmd
	}
	return nil
}

//*
// void request
type VersionRequestProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VersionRequestProto) Reset() {
	*x = VersionRequestProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionRequestProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionRequestProto) ProtoMessage() {}

func (x *VersionRequestProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionRequestProto.ProtoReflect.Descriptor instead.
func (*VersionRequestProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{11}
}

//*
// Version response from namenode.
type VersionResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Info *NamespaceInfoProto `protobuf:"bytes,1,req,name=info" json:"info,omitempty"`
}

func (x *VersionResponseProto) Reset() {
	*x = VersionResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionResponseProto) ProtoMessage() {}

func (x *VersionResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionResponseProto.ProtoReflect.Descriptor instead.
func (*VersionResponseProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{12}
}

func (x *VersionResponseProto) GetInfo() *NamespaceInfoProto {
	if x != nil {
		return x.Info
	}
	return nil
}

//*
// Common node information shared by all the nodes in the cluster
type StorageInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LayoutVersion *uint32 `protobuf:"varint,1,req,name=layoutVersion" json:"layoutVersion,omitempty"` // Layout version of the file system
	NamespceID    *uint32 `protobuf:"varint,2,req,name=namespceID" json:"namespceID,omitempty"`       // File system namespace ID
	ClusterID     *string `protobuf:"bytes,3,req,name=clusterID" json:"clusterID,omitempty"`          // ID of the cluster
	CTime         *uint64 `protobuf:"varint,4,req,name=cTime" json:"cTime,omitempty"`                 // File system creation time
}

func (x *StorageInfoProto) Reset() {
	*x = StorageInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageInfoProto) ProtoMessage() {}

func (x *StorageInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageInfoProto.ProtoReflect.Descriptor instead.
func (*StorageInfoProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{13}
}

func (x *StorageInfoProto) GetLayoutVersion() uint32 {
	if x != nil && x.LayoutVersion != nil {
		return *x.LayoutVersion
	}
	return 0
}

func (x *StorageInfoProto) GetNamespceID() uint32 {
	if x != nil && x.NamespceID != nil {
		return *x.NamespceID
	}
	return 0
}

func (x *StorageInfoProto) GetClusterID() string {
	if x != nil && x.ClusterID != nil {
		return *x.ClusterID
	}
	return ""
}

func (x *StorageInfoProto) GetCTime() uint64 {
	if x != nil && x.CTime != nil {
		return *x.CTime
	}
	return 0
}

//*
// Information sent by a namenode to identify itself to the primary namenode.
type NamenodeRegistrationProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RpcAddress  *string                                      `protobuf:"bytes,1,req,name=rpcAddress" json:"rpcAddress,omitempty"`                                                         // host:port of the namenode RPC address
	HttpAddress *string                                      `protobuf:"bytes,2,req,name=httpAddress" json:"httpAddress,omitempty"`                                                       // host:port of the namenode http server
	StorageInfo *StorageInfoProto                            `protobuf:"bytes,3,req,name=storageInfo" json:"storageInfo,omitempty"`                                                       // Node information
	Role        *NamenodeRegistrationProto_NamenodeRoleProto `protobuf:"varint,4,opt,name=role,enum=hadoop.hdfs.NamenodeRegistrationProto_NamenodeRoleProto,def=1" json:"role,omitempty"` // Namenode role
}

// Default values for NamenodeRegistrationProto fields.
const (
	Default_NamenodeRegistrationProto_Role = NamenodeRegistrationProto_NAMENODE
)

func (x *NamenodeRegistrationProto) Reset() {
	*x = NamenodeRegistrationProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamenodeRegistrationProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamenodeRegistrationProto) ProtoMessage() {}

func (x *NamenodeRegistrationProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamenodeRegistrationProto.ProtoReflect.Descriptor instead.
func (*NamenodeRegistrationProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{14}
}

func (x *NamenodeRegistrationProto) GetRpcAddress() string {
	if x != nil && x.RpcAddress != nil {
		return *x.RpcAddress
	}
	return ""
}

func (x *NamenodeRegistrationProto) GetHttpAddress() string {
	if x != nil && x.HttpAddress != nil {
		return *x.HttpAddress
	}
	return ""
}

func (x *NamenodeRegistrationProto) GetStorageInfo() *StorageInfoProto {
	if x != nil {
		return x.StorageInfo
	}
	return nil
}

func (x *NamenodeRegistrationProto) GetRole() NamenodeRegistrationProto_NamenodeRoleProto {
	if x != nil && x.Role != nil {
		return *x.Role
	}
	return Default_NamenodeRegistrationProto_Role
}

//*
// state - State the NN is in when returning response to the DN
// txid - Highest transaction ID this NN has seen
type NNHAStatusHeartbeatProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	State *NNHAStatusHeartbeatProto_State `protobuf:"varint,1,req,name=state,enum=hadoop.hdfs.NNHAStatusHeartbeatProto_State" json:"state,omitempty"`
	Txid  *uint64                         `protobuf:"varint,2,req,name=txid" json:"txid,omitempty"`
}

func (x *NNHAStatusHeartbeatProto) Reset() {
	*x = NNHAStatusHeartbeatProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_HdfsServer_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NNHAStatusHeartbeatProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NNHAStatusHeartbeatProto) ProtoMessage() {}

func (x *NNHAStatusHeartbeatProto) ProtoReflect() protoreflect.Message {
	mi := &file_HdfsServer_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NNHAStatusHeartbeatProto.ProtoReflect.Descriptor instead.
func (*NNHAStatusHeartbeatProto) Descriptor() ([]byte, []int) {
	return file_HdfsServer_proto_rawDescGZIP(), []int{15}
}

func (x *NNHAStatusHeartbeatProto) GetState() NNHAStatusHeartbeatProto_State {
	if x != nil && x.State != nil {
		return *x.State
	}
	return NNHAStatusHeartbeatProto_ACTIVE
}

func (x *NNHAStatusHeartbeatProto) GetTxid() uint64 {
	if x != nil && x.Txid != nil {
		return *x.Txid
	}
	return 0
}

var File_HdfsServer_proto protoreflect.FileDescriptor

var file_HdfsServer_proto_rawDesc = []byte{
	0x0a, 0x10, 0x48, 0x64, 0x66, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x0b, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x1a,
	0x0a, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x48, 0x41, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x61, 0x0a, 0x0d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4b, 0x65, 0x79,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x0d, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52,
	0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6b,
	0x65, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6b,
	0x65, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x90, 0x02, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4b, 0x65, 0x79, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x30, 0x0a, 0x13, 0x69, 0x73, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x08, 0x52,
	0x13, 0x69, 0x73, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x12, 0x2c, 0x0a, 0x11, 0x6b, 0x65, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52,
	0x11, 0x6b, 0x65, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x12, 0x24, 0x0a, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x4c, 0x69, 0x66, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x4c, 0x69, 0x66, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0a, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x4b, 0x65, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x4b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x07, 0x61, 0x6c, 0x6c, 0x4b, 0x65, 0x79, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4b, 0x65, 0x79, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x07, 0x61, 0x6c, 0x6c, 0x4b, 0x65, 0x79, 0x73, 0x22, 0xaf, 0x02, 0x0a, 0x17, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x57, 0x69, 0x74, 0x68, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x24, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64,
	0x65, 0x55, 0x75, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x61,
	0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x55, 0x75, 0x69, 0x64, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x75, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x75, 0x69, 0x64, 0x73, 0x12,
	0x41, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x07, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0c,
	0x64, 0x61, 0x74, 0x61, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4e, 0x75, 0x6d, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4e, 0x75, 0x6d,
	0x12, 0x1a, 0x0a, 0x08, 0x63, 0x65, 0x6c, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x08, 0x63, 0x65, 0x6c, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x58, 0x0a, 0x18,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x57, 0x69, 0x74, 0x68, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3c, 0x0a, 0x06, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x57, 0x69, 0x74, 0x68,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22, 0x77, 0x0a, 0x12, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x45, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x0a, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x78, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x78, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x78, 0x49, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x78, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x0c, 0x69, 0x73, 0x49, 0x6e, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73,
	0x65, 0x52, 0x0c, 0x69, 0x73, 0x49, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22,
	0x79, 0x0a, 0x1a, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x45, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67,
	0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x33, 0x0a,
	0x04, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x45, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x6c, 0x6f,
	0x67, 0x73, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x54,
	0x78, 0x6e, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x74, 0x65, 0x64, 0x54, 0x78, 0x6e, 0x49, 0x64, 0x22, 0xc7, 0x02, 0x0a, 0x12, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x6e, 0x75, 0x73, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x06, 0x75, 0x6e, 0x75, 0x73, 0x65, 0x64, 0x12, 0x20, 0x0a,
	0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x44, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x09, 0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x44, 0x12,
	0x3f, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x04,
	0x20, 0x02, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x28, 0x0a, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0c, 0x63, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04,
	0x3a, 0x01, 0x30, 0x52, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x41, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4e,
	0x4e, 0x48, 0x41, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65,
	0x61, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x22, 0x94, 0x02, 0x0a, 0x14, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x0a,
	0x0b, 0x6e, 0x65, 0x77, 0x47, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x04, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x47, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x34, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x3d, 0x0a, 0x0d, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74,
	0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0d, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x41, 0x0a, 0x08, 0x65, 0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x65,
	0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x0a, 0x0c, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x22, 0xe1, 0x01, 0x0a, 0x18,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x0a, 0x0b, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0b, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x18, 0x6d, 0x6f,
	0x73, 0x74, 0x52, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x54, 0x78, 0x49, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x18, 0x6d, 0x6f,
	0x73, 0x74, 0x52, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x54, 0x78, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x75, 0x72, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x54, 0x78, 0x49, 0x64, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0e,
	0x63, 0x75, 0x72, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x78, 0x49, 0x64, 0x12, 0x3f,
	0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20,
	0x02, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22,
	0x8b, 0x01, 0x0a, 0x16, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x43, 0x0a, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x2c, 0x0a, 0x11, 0x6e, 0x65, 0x65, 0x64, 0x54, 0x6f, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52, 0x11, 0x6e, 0x65, 0x65, 0x64,
	0x54, 0x6f, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x22, 0xe9, 0x01,
	0x0a, 0x14, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x6e,
	0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x49, 0x0a, 0x0d, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6d, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x43, 0x6d, 0x64, 0x22, 0x32, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x13, 0x0a,
	0x0f, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x10, 0x01, 0x22, 0x15, 0x0a, 0x13, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x4b, 0x0a, 0x14, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x33, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x8c, 0x01,
	0x0a, 0x10, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x24, 0x0a, 0x0d, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0d, 0x6c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x63, 0x65, 0x49, 0x44, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0a, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x63, 0x65, 0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x44, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x49, 0x44, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x54, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x05, 0x63, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb5, 0x02, 0x0a,
	0x19, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x70,
	0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a,
	0x72, 0x70, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x68, 0x74,
	0x74, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x0b, 0x68, 0x74, 0x74, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3f, 0x0a, 0x0b,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x02, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x56, 0x0a,
	0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f,
	0x64, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64, 0x65, 0x52, 0x6f, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x08, 0x4e, 0x41, 0x4d, 0x45, 0x4e, 0x4f, 0x44, 0x45, 0x52,
	0x04, 0x72, 0x6f, 0x6c, 0x65, 0x22, 0x3d, 0x0a, 0x11, 0x4e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x64,
	0x65, 0x52, 0x6f, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x41,
	0x4d, 0x45, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x41, 0x43, 0x4b,
	0x55, 0x50, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x50, 0x4f, 0x49,
	0x4e, 0x54, 0x10, 0x03, 0x22, 0xa1, 0x01, 0x0a, 0x18, 0x4e, 0x4e, 0x48, 0x41, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x41, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4e,
	0x4e, 0x48, 0x41, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65,
	0x61, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x78, 0x69, 0x64, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x04, 0x52, 0x04, 0x74, 0x78, 0x69, 0x64, 0x22, 0x2e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x42, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x42,
	0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x02, 0x2a, 0x4c, 0x0a, 0x11, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x53, 0x74, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0d, 0x0a,
	0x09, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03,
	0x52, 0x42, 0x57, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x52, 0x57, 0x52, 0x10, 0x02, 0x12, 0x07,
	0x0a, 0x03, 0x52, 0x55, 0x52, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x45, 0x4d, 0x50, 0x4f,
	0x52, 0x41, 0x52, 0x59, 0x10, 0x04, 0x42, 0x78, 0x0a, 0x25, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42,
	0x10, 0x48, 0x64, 0x66, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x5a, 0x3a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f,
	0x6c, 0x69, 0x6e, 0x6d, 0x61, 0x72, 0x63, 0x2f, 0x68, 0x64, 0x66, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x2f, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x5f, 0x68, 0x64, 0x66, 0x73, 0xa0, 0x01, 0x01,
}

var (
	file_HdfsServer_proto_rawDescOnce sync.Once
	file_HdfsServer_proto_rawDescData = file_HdfsServer_proto_rawDesc
)

func file_HdfsServer_proto_rawDescGZIP() []byte {
	file_HdfsServer_proto_rawDescOnce.Do(func() {
		file_HdfsServer_proto_rawDescData = protoimpl.X.CompressGZIP(file_HdfsServer_proto_rawDescData)
	})
	return file_HdfsServer_proto_rawDescData
}

var file_HdfsServer_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_HdfsServer_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_HdfsServer_proto_goTypes = []interface{}{
	(ReplicaStateProto)(0),                           // 0: hadoop.hdfs.ReplicaStateProto
	(NamenodeCommandProto_Type)(0),                   // 1: hadoop.hdfs.NamenodeCommandProto.Type
	(NamenodeRegistrationProto_NamenodeRoleProto)(0), // 2: hadoop.hdfs.NamenodeRegistrationProto.NamenodeRoleProto
	(NNHAStatusHeartbeatProto_State)(0),              // 3: hadoop.hdfs.NNHAStatusHeartbeatProto.State
	(*BlockKeyProto)(nil),                            // 4: hadoop.hdfs.BlockKeyProto
	(*ExportedBlockKeysProto)(nil),                   // 5: hadoop.hdfs.ExportedBlockKeysProto
	(*BlockWithLocationsProto)(nil),                  // 6: hadoop.hdfs.BlockWithLocationsProto
	(*BlocksWithLocationsProto)(nil),                 // 7: hadoop.hdfs.BlocksWithLocationsProto
	(*RemoteEditLogProto)(nil),                       // 8: hadoop.hdfs.RemoteEditLogProto
	(*RemoteEditLogManifestProto)(nil),               // 9: hadoop.hdfs.RemoteEditLogManifestProto
	(*NamespaceInfoProto)(nil),                       // 10: hadoop.hdfs.NamespaceInfoProto
	(*RecoveringBlockProto)(nil),                     // 11: hadoop.hdfs.RecoveringBlockProto
	(*CheckpointSignatureProto)(nil),                 // 12: hadoop.hdfs.CheckpointSignatureProto
	(*CheckpointCommandProto)(nil),                   // 13: hadoop.hdfs.CheckpointCommandProto
	(*NamenodeCommandProto)(nil),                     // 14: hadoop.hdfs.NamenodeCommandProto
	(*VersionRequestProto)(nil),                      // 15: hadoop.hdfs.VersionRequestProto
	(*VersionResponseProto)(nil),                     // 16: hadoop.hdfs.VersionResponseProto
	(*StorageInfoProto)(nil),                         // 17: hadoop.hdfs.StorageInfoProto
	(*NamenodeRegistrationProto)(nil),                // 18: hadoop.hdfs.NamenodeRegistrationProto
	(*NNHAStatusHeartbeatProto)(nil),                 // 19: hadoop.hdfs.NNHAStatusHeartbeatProto
	(*BlockProto)(nil),                               // 20: hadoop.hdfs.BlockProto
	(StorageTypeProto)(0),                            // 21: hadoop.hdfs.StorageTypeProto
	(*LocatedBlockProto)(nil),                        // 22: hadoop.hdfs.LocatedBlockProto
	(*ErasureCodingPolicyProto)(nil),                 // 23: hadoop.hdfs.ErasureCodingPolicyProto
}
var file_HdfsServer_proto_depIdxs = []int32{
	4,  // 0: hadoop.hdfs.ExportedBlockKeysProto.currentKey:type_name -> hadoop.hdfs.BlockKeyProto
	4,  // 1: hadoop.hdfs.ExportedBlockKeysProto.allKeys:type_name -> hadoop.hdfs.BlockKeyProto
	20, // 2: hadoop.hdfs.BlockWithLocationsProto.block:type_name -> hadoop.hdfs.BlockProto
	21, // 3: hadoop.hdfs.BlockWithLocationsProto.storageTypes:type_name -> hadoop.hdfs.StorageTypeProto
	6,  // 4: hadoop.hdfs.BlocksWithLocationsProto.blocks:type_name -> hadoop.hdfs.BlockWithLocationsProto
	8,  // 5: hadoop.hdfs.RemoteEditLogManifestProto.logs:type_name -> hadoop.hdfs.RemoteEditLogProto
	17, // 6: hadoop.hdfs.NamespaceInfoProto.storageInfo:type_name -> hadoop.hdfs.StorageInfoProto
	3,  // 7: hadoop.hdfs.NamespaceInfoProto.state:type_name -> hadoop.hdfs.NNHAStatusHeartbeatProto.State
	22, // 8: hadoop.hdfs.RecoveringBlockProto.block:type_name -> hadoop.hdfs.LocatedBlockProto
	20, // 9: hadoop.hdfs.RecoveringBlockProto.truncateBlock:type_name -> hadoop.hdfs.BlockProto
	23, // 10: hadoop.hdfs.RecoveringBlockProto.ecPolicy:type_name -> hadoop.hdfs.ErasureCodingPolicyProto
	17, // 11: hadoop.hdfs.CheckpointSignatureProto.storageInfo:type_name -> hadoop.hdfs.StorageInfoProto
	12, // 12: hadoop.hdfs.CheckpointCommandProto.signature:type_name -> hadoop.hdfs.CheckpointSignatureProto
	1,  // 13: hadoop.hdfs.NamenodeCommandProto.type:type_name -> hadoop.hdfs.NamenodeCommandProto.Type
	13, // 14: hadoop.hdfs.NamenodeCommandProto.checkpointCmd:type_name -> hadoop.hdfs.CheckpointCommandProto
	10, // 15: hadoop.hdfs.VersionResponseProto.info:type_name -> hadoop.hdfs.NamespaceInfoProto
	17, // 16: hadoop.hdfs.NamenodeRegistrationProto.storageInfo:type_name -> hadoop.hdfs.StorageInfoProto
	2,  // 17: hadoop.hdfs.NamenodeRegistrationProto.role:type_name -> hadoop.hdfs.NamenodeRegistrationProto.NamenodeRoleProto
	3,  // 18: hadoop.hdfs.NNHAStatusHeartbeatProto.state:type_name -> hadoop.hdfs.NNHAStatusHeartbeatProto.State
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_HdfsServer_proto_init() }
func file_HdfsServer_proto_init() {
	if File_HdfsServer_proto != nil {
		return
	}
	file_hdfs_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_HdfsServer_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlockKeyProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportedBlockKeysProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlockWithLocationsProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlocksWithLocationsProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteEditLogProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteEditLogManifestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecoveringBlockProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckpointSignatureProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckpointCommandProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamenodeCommandProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionRequestProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamenodeRegistrationProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_HdfsServer_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NNHAStatusHeartbeatProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_HdfsServer_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_HdfsServer_proto_goTypes,
		DependencyIndexes: file_HdfsServer_proto_depIdxs,
		EnumInfos:         file_HdfsServer_proto_enumTypes,
		MessageInfos:      file_HdfsServer_proto_msgTypes,
	}.Build()
	File_HdfsServer_proto = out.File
	file_HdfsServer_proto_rawDesc = nil
	file_HdfsServer_proto_goTypes = nil
	file_HdfsServer_proto_depIdxs = nil
}
