# QingStor SDK for Go

[![Build Status](https://travis-ci.org/yunify/qingstor-sdk-go.svg?branch=master)](https://travis-ci.org/yunify/qingstor-sdk-go)
[![Go Report Card](https://goreportcard.com/badge/github.com/yunify/qingstor-sdk-go)](https://goreportcard.com/report/github.com/yunify/qingstor-sdk-go)
[![API Reference](http://img.shields.io/badge/api-reference-green.svg)](http://docs.qingcloud.com/qingstor/)
[![License](http://img.shields.io/badge/license-apache%20v2-blue.svg)](https://github.com/yunify/qingstor-sdk-go/blob/master/LICENSE)

English | [中文](README_zh-CN.md)

The official QingStor SDK for the Go programming language.

Before you start using the SDK, make sure you have a basic understanding of the concepts of [QingStor object storage](https://docs.qingcloud.com/qingstor/api/common/overview.html) (such as Zone, Service, Bucket, Object, etc.).

This SDK try to keep a one-to-one correspondence with the methods on the [QingCloud QingStor object storage documentation](https://docs.qingcloud.com/qingstor/api/). For details of each method, please refer to the corresponding chapter in the link.

## Quick Start

Now you are ready to code. You can read the detailed guides in the list below to have a clear understanding.

- [Preparation](./docs/prepare.md)
- [Installation](./docs/install.md)
- [Configuration](./docs/config.md)
- [Service Initialization](./docs/service.md)
- [Code Examples](./docs/examples.md)

Checkout our [releases](https://github.com/yunify/qingstor-sdk-go/releases) and [change log](./CHANGELOG.md) for information about the latest features, bug fixes and new ideas.

## Reference Documentations

- [QingStor Documentation](https://docs.qingcloud.com/qingstor/index.html)
- [QingStor Guide](https://docs.qingcloud.com/qingstor/guide/index.html)
- [QingStor APIs](https://docs.qingcloud.com/qingstor/api/index.html)

## Contributing

1. Fork it ( https://github.com/yunify/qingstor-sdk-go/fork )
2. Create your feature branch (`git checkout -b new-feature`)
3. Commit your changes (`git commit -asm 'Add some feature'`)
4. Push to the branch (`git push origin new-feature`)
5. Create a new Pull Request

## LICENSE

The Apache License (Version 2.0, January 2004).
