SYD-PTY(1)

# NAME

syd-pty - PTY to STDIO bidirectional forwarder

# SYNOPSIS

*syd-pty* _[-dh]_ _[-x <x-size>]_ _[-y <y-size>]_ _-p <pid-fd>_ _-i <pty-fd>_

# DESCRIPTION

Forwards data between the given _pty_(7) main file descriptor,
and _stdio_(3).

PID file descriptor is used to track the exit of Syd process.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-d*
:< Run in debug mode without confinement.
|[ *-p* *pid-fd*
:< PID file descriptor of Syd process.
|[ *-i* *pty-fd*
:< PTY main file descriptor.
|[ *-x* *x-size*
:< Specify window row size (default: inherit).
|[ *-y* *y-size*
:< Specify window column size (default: inherit).

# USAGE

_syd-pty_(1) is not meant to be used as a standalone tool. Syd invokes
_syd-pty_(1) at startup when PTY sandboxing is set to on with
*sandbox/pty:on*. See the PTY SANDBOXING section in _syd_(7) manual page
for more information. If you want to use _syd-pty_(1) in your own
project, what you need to do first is to pass it a _non-blocking_ PID fd
of your own process with the *-p <pid-fd>* argument so _syd-pty_(1) can
simultaneously exit with it. Care should be given at this stage as PID
file descriptors are *O_CLOEXEC* by default. Next create a new
pseudoterminal with _posix_openpt_(3) or _openpty_(3) and pass the main
end of the file descriptor pair to _syd-pty_(1) with the *-i <pty-fd>*
argument.

# IMPLEMENTATION

_syd-pty_(1) is designed with performance, security, and privacy in
mind, utilizing advanced techniques such as edge-triggered _epoll_(7)
for efficient event notification and full asynchronous operations to
handle pseudoterminal activities without blocking. It employs zero-copy
data transfer using the _splice_(2) system call to move data directly
between file descriptors within the kernel, ensuring high performance
and data privacy. To facilitate bidirectional communication,
_syd-pty_(1) uses two pairs of pipes, allowing seamless data flow
between _pty_(7) and _stdio_(3). Additionally, _syd-pty_(1) confines its
execution environment using seccomp and Landlock, restricting system
calls and file accesses to minimize the attack surface.

# SECURITY

_syd-pty_(1) implements comprehensive security measures to mitigate
risks associated with running outside the Syd sandbox, thus preventing
potential Meddler-in-the-Middle (MITM) attacks against containers.
Seccomp filters are meticulously configured to allow only necessary
syscalls. Moreover, executable memory is disallowed to prevent code
injection attacks and reading the timestamp counter is prevented on x86
to make timing attacks harder to realize. Landlock and namespaces, if
available, enforce further restrictions by disallowing all filesystem
and network access, providing an additional layer of security.
Additionally, the main PTY file descriptor is placed into exclusive
mode via the *TIOCEXCL* _ioctl_(2) request. This prevents any further
opens of the secondary PTY device (save for processes with the
*CAP_SYS_ADMIN* capability), thereby reducing the attack surface for
unauthorized eavesdropping or input injection at the device layer as
part of a defense-in-depth strategy. These combined techniques ensure
that even if _syd-pty_(1) is compromised, the scope of malicious actions
is significantly limited, maintaining the integrity and security of the
overall system.

# ENVIRONMENT

|[ *SYD_PTY_DEBUG*
:< Run in debug mode without confinement, equivalent to the *-d* option
|[ *SYD_PTY_RULES*
:< Print seccomp rules in human-readable format to standard error at startup

# BUGS

_splice_(2) support for ttys was removed in commit
36e2c7421f02a22f71c9283e55fdb672a9eb58e7 (merged for Linux 6.5) and later
restored in commit 9bb48c82aced07698a2d08ee0f1475a6c4f6b266 (merged for Linux
6.6). When running under a problematic Linux kernel _syd-pty_(1) will exit with
22, aka *EINVAL* or *Invalid argument*. See the following links for more
information:

- https://git.kernel.org/linus/36e2c7421f02a22f71c9283e55fdb672a9eb58e7
- https://git.kernel.org/linus/9bb48c82aced07698a2d08ee0f1475a6c4f6b266

# SEE ALSO

_syd_(1), _syd_(2), _syd_(7), _stdio_(3), _pty_(7)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
