// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteACLFrontendAcceptedCode is the HTTP code returned for type DeleteACLFrontendAccepted
const DeleteACLFrontendAcceptedCode int = 202

/*
DeleteACLFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteAclFrontendAccepted
*/
type DeleteACLFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteACLFrontendAccepted creates DeleteACLFrontendAccepted with default headers values
func NewDeleteACLFrontendAccepted() *DeleteACLFrontendAccepted {

	return &DeleteACLFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete Acl frontend accepted response
func (o *DeleteACLFrontendAccepted) WithReloadID(reloadID string) *DeleteACLFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Acl frontend accepted response
func (o *DeleteACLFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteACLFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteACLFrontendNoContentCode is the HTTP code returned for type DeleteACLFrontendNoContent
const DeleteACLFrontendNoContentCode int = 204

/*
DeleteACLFrontendNoContent ACL line deleted

swagger:response deleteAclFrontendNoContent
*/
type DeleteACLFrontendNoContent struct {
}

// NewDeleteACLFrontendNoContent creates DeleteACLFrontendNoContent with default headers values
func NewDeleteACLFrontendNoContent() *DeleteACLFrontendNoContent {

	return &DeleteACLFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteACLFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteACLFrontendNotFoundCode is the HTTP code returned for type DeleteACLFrontendNotFound
const DeleteACLFrontendNotFoundCode int = 404

/*
DeleteACLFrontendNotFound The specified resource was not found

swagger:response deleteAclFrontendNotFound
*/
type DeleteACLFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteACLFrontendNotFound creates DeleteACLFrontendNotFound with default headers values
func NewDeleteACLFrontendNotFound() *DeleteACLFrontendNotFound {

	return &DeleteACLFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Acl frontend not found response
func (o *DeleteACLFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteACLFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Acl frontend not found response
func (o *DeleteACLFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Acl frontend not found response
func (o *DeleteACLFrontendNotFound) WithPayload(payload *models.Error) *DeleteACLFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Acl frontend not found response
func (o *DeleteACLFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteACLFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteACLFrontendDefault General Error

swagger:response deleteAclFrontendDefault
*/
type DeleteACLFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteACLFrontendDefault creates DeleteACLFrontendDefault with default headers values
func NewDeleteACLFrontendDefault(code int) *DeleteACLFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteACLFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete Acl frontend default response
func (o *DeleteACLFrontendDefault) WithStatusCode(code int) *DeleteACLFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete Acl frontend default response
func (o *DeleteACLFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete Acl frontend default response
func (o *DeleteACLFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteACLFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Acl frontend default response
func (o *DeleteACLFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Acl frontend default response
func (o *DeleteACLFrontendDefault) WithPayload(payload *models.Error) *DeleteACLFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Acl frontend default response
func (o *DeleteACLFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteACLFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
