// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetLogTargetBackendOKCode is the HTTP code returned for type GetLogTargetBackendOK
const GetLogTargetBackendOKCode int = 200

/*
GetLogTargetBackendOK Successful operation

swagger:response getLogTargetBackendOK
*/
type GetLogTargetBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewGetLogTargetBackendOK creates GetLogTargetBackendOK with default headers values
func NewGetLogTargetBackendOK() *GetLogTargetBackendOK {

	return &GetLogTargetBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target backend o k response
func (o *GetLogTargetBackendOK) WithConfigurationVersion(configurationVersion string) *GetLogTargetBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target backend o k response
func (o *GetLogTargetBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target backend o k response
func (o *GetLogTargetBackendOK) WithPayload(payload *models.LogTarget) *GetLogTargetBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target backend o k response
func (o *GetLogTargetBackendOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetLogTargetBackendNotFoundCode is the HTTP code returned for type GetLogTargetBackendNotFound
const GetLogTargetBackendNotFoundCode int = 404

/*
GetLogTargetBackendNotFound The specified resource was not found

swagger:response getLogTargetBackendNotFound
*/
type GetLogTargetBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetBackendNotFound creates GetLogTargetBackendNotFound with default headers values
func NewGetLogTargetBackendNotFound() *GetLogTargetBackendNotFound {

	return &GetLogTargetBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target backend not found response
func (o *GetLogTargetBackendNotFound) WithConfigurationVersion(configurationVersion string) *GetLogTargetBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target backend not found response
func (o *GetLogTargetBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target backend not found response
func (o *GetLogTargetBackendNotFound) WithPayload(payload *models.Error) *GetLogTargetBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target backend not found response
func (o *GetLogTargetBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetLogTargetBackendDefault General Error

swagger:response getLogTargetBackendDefault
*/
type GetLogTargetBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetBackendDefault creates GetLogTargetBackendDefault with default headers values
func NewGetLogTargetBackendDefault(code int) *GetLogTargetBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogTargetBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log target backend default response
func (o *GetLogTargetBackendDefault) WithStatusCode(code int) *GetLogTargetBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log target backend default response
func (o *GetLogTargetBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get log target backend default response
func (o *GetLogTargetBackendDefault) WithConfigurationVersion(configurationVersion string) *GetLogTargetBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target backend default response
func (o *GetLogTargetBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target backend default response
func (o *GetLogTargetBackendDefault) WithPayload(payload *models.Error) *GetLogTargetBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target backend default response
func (o *GetLogTargetBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
