// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package quic_initial_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllQUICInitialRuleFrontendOKCode is the HTTP code returned for type ReplaceAllQUICInitialRuleFrontendOK
const ReplaceAllQUICInitialRuleFrontendOKCode int = 200

/*
ReplaceAllQUICInitialRuleFrontendOK All TTP After Response Rules lines replaced

swagger:response replaceAllQuicInitialRuleFrontendOK
*/
type ReplaceAllQUICInitialRuleFrontendOK struct {

	/*
	  In: Body
	*/
	Payload models.QUICInitialRules `json:"body,omitempty"`
}

// NewReplaceAllQUICInitialRuleFrontendOK creates ReplaceAllQUICInitialRuleFrontendOK with default headers values
func NewReplaceAllQUICInitialRuleFrontendOK() *ReplaceAllQUICInitialRuleFrontendOK {

	return &ReplaceAllQUICInitialRuleFrontendOK{}
}

// WithPayload adds the payload to the replace all Quic initial rule frontend o k response
func (o *ReplaceAllQUICInitialRuleFrontendOK) WithPayload(payload models.QUICInitialRules) *ReplaceAllQUICInitialRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Quic initial rule frontend o k response
func (o *ReplaceAllQUICInitialRuleFrontendOK) SetPayload(payload models.QUICInitialRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllQUICInitialRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.QUICInitialRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllQUICInitialRuleFrontendAcceptedCode is the HTTP code returned for type ReplaceAllQUICInitialRuleFrontendAccepted
const ReplaceAllQUICInitialRuleFrontendAcceptedCode int = 202

/*
ReplaceAllQUICInitialRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceAllQuicInitialRuleFrontendAccepted
*/
type ReplaceAllQUICInitialRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.QUICInitialRules `json:"body,omitempty"`
}

// NewReplaceAllQUICInitialRuleFrontendAccepted creates ReplaceAllQUICInitialRuleFrontendAccepted with default headers values
func NewReplaceAllQUICInitialRuleFrontendAccepted() *ReplaceAllQUICInitialRuleFrontendAccepted {

	return &ReplaceAllQUICInitialRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Quic initial rule frontend accepted response
func (o *ReplaceAllQUICInitialRuleFrontendAccepted) WithReloadID(reloadID string) *ReplaceAllQUICInitialRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Quic initial rule frontend accepted response
func (o *ReplaceAllQUICInitialRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Quic initial rule frontend accepted response
func (o *ReplaceAllQUICInitialRuleFrontendAccepted) WithPayload(payload models.QUICInitialRules) *ReplaceAllQUICInitialRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Quic initial rule frontend accepted response
func (o *ReplaceAllQUICInitialRuleFrontendAccepted) SetPayload(payload models.QUICInitialRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllQUICInitialRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.QUICInitialRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllQUICInitialRuleFrontendBadRequestCode is the HTTP code returned for type ReplaceAllQUICInitialRuleFrontendBadRequest
const ReplaceAllQUICInitialRuleFrontendBadRequestCode int = 400

/*
ReplaceAllQUICInitialRuleFrontendBadRequest Bad request

swagger:response replaceAllQuicInitialRuleFrontendBadRequest
*/
type ReplaceAllQUICInitialRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllQUICInitialRuleFrontendBadRequest creates ReplaceAllQUICInitialRuleFrontendBadRequest with default headers values
func NewReplaceAllQUICInitialRuleFrontendBadRequest() *ReplaceAllQUICInitialRuleFrontendBadRequest {

	return &ReplaceAllQUICInitialRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Quic initial rule frontend bad request response
func (o *ReplaceAllQUICInitialRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllQUICInitialRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Quic initial rule frontend bad request response
func (o *ReplaceAllQUICInitialRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Quic initial rule frontend bad request response
func (o *ReplaceAllQUICInitialRuleFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceAllQUICInitialRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Quic initial rule frontend bad request response
func (o *ReplaceAllQUICInitialRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllQUICInitialRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllQUICInitialRuleFrontendDefault General Error

swagger:response replaceAllQuicInitialRuleFrontendDefault
*/
type ReplaceAllQUICInitialRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllQUICInitialRuleFrontendDefault creates ReplaceAllQUICInitialRuleFrontendDefault with default headers values
func NewReplaceAllQUICInitialRuleFrontendDefault(code int) *ReplaceAllQUICInitialRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllQUICInitialRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all QUIC initial rule frontend default response
func (o *ReplaceAllQUICInitialRuleFrontendDefault) WithStatusCode(code int) *ReplaceAllQUICInitialRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all QUIC initial rule frontend default response
func (o *ReplaceAllQUICInitialRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all QUIC initial rule frontend default response
func (o *ReplaceAllQUICInitialRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllQUICInitialRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all QUIC initial rule frontend default response
func (o *ReplaceAllQUICInitialRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all QUIC initial rule frontend default response
func (o *ReplaceAllQUICInitialRuleFrontendDefault) WithPayload(payload *models.Error) *ReplaceAllQUICInitialRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all QUIC initial rule frontend default response
func (o *ReplaceAllQUICInitialRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllQUICInitialRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
