// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetTCPRequestRuleFrontendOKCode is the HTTP code returned for type GetTCPRequestRuleFrontendOK
const GetTCPRequestRuleFrontendOKCode int = 200

/*
GetTCPRequestRuleFrontendOK Successful operation

swagger:response getTcpRequestRuleFrontendOK
*/
type GetTCPRequestRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.TCPRequestRule `json:"body,omitempty"`
}

// NewGetTCPRequestRuleFrontendOK creates GetTCPRequestRuleFrontendOK with default headers values
func NewGetTCPRequestRuleFrontendOK() *GetTCPRequestRuleFrontendOK {

	return &GetTCPRequestRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Tcp request rule frontend o k response
func (o *GetTCPRequestRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetTCPRequestRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Tcp request rule frontend o k response
func (o *GetTCPRequestRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Tcp request rule frontend o k response
func (o *GetTCPRequestRuleFrontendOK) WithPayload(payload *models.TCPRequestRule) *GetTCPRequestRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Tcp request rule frontend o k response
func (o *GetTCPRequestRuleFrontendOK) SetPayload(payload *models.TCPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPRequestRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetTCPRequestRuleFrontendNotFoundCode is the HTTP code returned for type GetTCPRequestRuleFrontendNotFound
const GetTCPRequestRuleFrontendNotFoundCode int = 404

/*
GetTCPRequestRuleFrontendNotFound The specified resource was not found

swagger:response getTcpRequestRuleFrontendNotFound
*/
type GetTCPRequestRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTCPRequestRuleFrontendNotFound creates GetTCPRequestRuleFrontendNotFound with default headers values
func NewGetTCPRequestRuleFrontendNotFound() *GetTCPRequestRuleFrontendNotFound {

	return &GetTCPRequestRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Tcp request rule frontend not found response
func (o *GetTCPRequestRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *GetTCPRequestRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Tcp request rule frontend not found response
func (o *GetTCPRequestRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Tcp request rule frontend not found response
func (o *GetTCPRequestRuleFrontendNotFound) WithPayload(payload *models.Error) *GetTCPRequestRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Tcp request rule frontend not found response
func (o *GetTCPRequestRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPRequestRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetTCPRequestRuleFrontendDefault General Error

swagger:response getTcpRequestRuleFrontendDefault
*/
type GetTCPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTCPRequestRuleFrontendDefault creates GetTCPRequestRuleFrontendDefault with default headers values
func NewGetTCPRequestRuleFrontendDefault(code int) *GetTCPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetTCPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get TCP request rule frontend default response
func (o *GetTCPRequestRuleFrontendDefault) WithStatusCode(code int) *GetTCPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get TCP request rule frontend default response
func (o *GetTCPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get TCP request rule frontend default response
func (o *GetTCPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetTCPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get TCP request rule frontend default response
func (o *GetTCPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get TCP request rule frontend default response
func (o *GetTCPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *GetTCPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get TCP request rule frontend default response
func (o *GetTCPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
