// Code generated by sdkgen. DO NOT EDIT.

// nolint
package containerregistry

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	containerregistry "github.com/yandex-cloud/go-genproto/yandex/cloud/containerregistry/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// RepositoryServiceClient is a containerregistry.RepositoryServiceClient with
// lazy GRPC connection initialization.
type RepositoryServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Delete implements containerregistry.RepositoryServiceClient
func (c *RepositoryServiceClient) Delete(ctx context.Context, in *containerregistry.DeleteRepositoryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRepositoryServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements containerregistry.RepositoryServiceClient
func (c *RepositoryServiceClient) Get(ctx context.Context, in *containerregistry.GetRepositoryRequest, opts ...grpc.CallOption) (*containerregistry.Repository, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRepositoryServiceClient(conn).Get(ctx, in, opts...)
}

// GetByName implements containerregistry.RepositoryServiceClient
func (c *RepositoryServiceClient) GetByName(ctx context.Context, in *containerregistry.GetRepositoryByNameRequest, opts ...grpc.CallOption) (*containerregistry.Repository, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRepositoryServiceClient(conn).GetByName(ctx, in, opts...)
}

// List implements containerregistry.RepositoryServiceClient
func (c *RepositoryServiceClient) List(ctx context.Context, in *containerregistry.ListRepositoriesRequest, opts ...grpc.CallOption) (*containerregistry.ListRepositoriesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRepositoryServiceClient(conn).List(ctx, in, opts...)
}

type RepositoryIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RepositoryServiceClient
	request *containerregistry.ListRepositoriesRequest

	items []*containerregistry.Repository
}

func (c *RepositoryServiceClient) RepositoryIterator(ctx context.Context, req *containerregistry.ListRepositoriesRequest, opts ...grpc.CallOption) *RepositoryIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RepositoryIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RepositoryIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Repositories
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RepositoryIterator) Take(size int64) ([]*containerregistry.Repository, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containerregistry.Repository

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RepositoryIterator) TakeAll() ([]*containerregistry.Repository, error) {
	return it.Take(0)
}

func (it *RepositoryIterator) Value() *containerregistry.Repository {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RepositoryIterator) Error() error {
	return it.err
}

// ListAccessBindings implements containerregistry.RepositoryServiceClient
func (c *RepositoryServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRepositoryServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type RepositoryAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RepositoryServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *RepositoryServiceClient) RepositoryAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *RepositoryAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RepositoryAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RepositoryAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RepositoryAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RepositoryAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *RepositoryAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RepositoryAccessBindingsIterator) Error() error {
	return it.err
}

// SetAccessBindings implements containerregistry.RepositoryServiceClient
func (c *RepositoryServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRepositoryServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// UpdateAccessBindings implements containerregistry.RepositoryServiceClient
func (c *RepositoryServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRepositoryServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}

// Upsert implements containerregistry.RepositoryServiceClient
func (c *RepositoryServiceClient) Upsert(ctx context.Context, in *containerregistry.UpsertRepositoryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewRepositoryServiceClient(conn).Upsert(ctx, in, opts...)
}
