// Code generated by sdkgen. DO NOT EDIT.

// nolint
package datatransfer

import (
	"context"

	"google.golang.org/grpc"

	datatransfer "github.com/yandex-cloud/go-genproto/yandex/cloud/datatransfer/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// TransferServiceClient is a datatransfer.TransferServiceClient with
// lazy GRPC connection initialization.
type TransferServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Activate implements datatransfer.TransferServiceClient
func (c *TransferServiceClient) Activate(ctx context.Context, in *datatransfer.ActivateTransferRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewTransferServiceClient(conn).Activate(ctx, in, opts...)
}

// Create implements datatransfer.TransferServiceClient
func (c *TransferServiceClient) Create(ctx context.Context, in *datatransfer.CreateTransferRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewTransferServiceClient(conn).Create(ctx, in, opts...)
}

// Deactivate implements datatransfer.TransferServiceClient
func (c *TransferServiceClient) Deactivate(ctx context.Context, in *datatransfer.DeactivateTransferRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewTransferServiceClient(conn).Deactivate(ctx, in, opts...)
}

// Delete implements datatransfer.TransferServiceClient
func (c *TransferServiceClient) Delete(ctx context.Context, in *datatransfer.DeleteTransferRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewTransferServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements datatransfer.TransferServiceClient
func (c *TransferServiceClient) Get(ctx context.Context, in *datatransfer.GetTransferRequest, opts ...grpc.CallOption) (*datatransfer.Transfer, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewTransferServiceClient(conn).Get(ctx, in, opts...)
}

// List implements datatransfer.TransferServiceClient
func (c *TransferServiceClient) List(ctx context.Context, in *datatransfer.ListTransfersRequest, opts ...grpc.CallOption) (*datatransfer.ListTransfersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewTransferServiceClient(conn).List(ctx, in, opts...)
}

type TransferIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *TransferServiceClient
	request *datatransfer.ListTransfersRequest

	items []*datatransfer.Transfer
}

func (c *TransferServiceClient) TransferIterator(ctx context.Context, req *datatransfer.ListTransfersRequest, opts ...grpc.CallOption) *TransferIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &TransferIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *TransferIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Transfers
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *TransferIterator) Take(size int64) ([]*datatransfer.Transfer, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*datatransfer.Transfer

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *TransferIterator) TakeAll() ([]*datatransfer.Transfer, error) {
	return it.Take(0)
}

func (it *TransferIterator) Value() *datatransfer.Transfer {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *TransferIterator) Error() error {
	return it.err
}

// Update implements datatransfer.TransferServiceClient
func (c *TransferServiceClient) Update(ctx context.Context, in *datatransfer.UpdateTransferRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return datatransfer.NewTransferServiceClient(conn).Update(ctx, in, opts...)
}
