/* wmcms - WindowMaker CPU / Mem Usage Monitor DockApp
 * wmcms.c
 * Copyright (C) 2001 Fabio Pugliese Ornellas <fabio.ornellas@poli.usp.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <unistd.h>
#include <dockapp.h>
#include "state_linux.h"
#include "wmcms.xpm"

char *displayName = "";
int delay = 500;

GC gc;
Pixmap pixmap;
Pixmap backdrop;

int advanced;
int up;
int no_nice;
char *exe = "";

/* command line */
static DAProgramOption options[] = {
     {"-d", "--display", "display to use", DOString, False, {&displayName} },
     {"-i", "--interval", "interval between updates (in miliseconds)", DONatural, False, {&delay} },
     {"-a", "--advanced", "show more accurate info", DONone, False, {NULL}},
     {"-e", "--effect", "3D bars effect on", DONone, False, {NULL}},
     {"-n", "--nonice", "do not consider CPU nice usage", DONone, False, {NULL}},
     {"-p", "--program", "program to run on CPU click", DOString, False, {&exe} }
     };

/* draw bars */
void bar ( int size, int x, int y, int barx, int bary )
{
  if ( size != 0 )
  {
    /* bar */
    XCopyArea ( DADisplay, backdrop, pixmap, gc, barx, bary, size, 8, x, y );
    /* gray back */
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 4, 14, 55 - size, 8, size + 2, y );
  }
}

/* 3D effect */
void upmaker ( int size, int x, int y )
{
  if ( size != 0 )
  {
    /* up / down / right / left */
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 3, 74, size, 1, x, y );
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 3, 81, size, 1, x, y + 7 );
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 58, 75, 1, 6, x + size -1, y + 1 );
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 3, 75, 1, 6, x, y + 1 );
  }
}

/* draw asked number */
void number ( int num, int x, int y )
{
  if ( num == 10 )
    /* 1 from 100% */
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 12, 65, 1, 7, x, y );
  else
    /* other digits */
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 3 + (num * 5), 65, 5, 7, x, y );
}

/* draw % values */
void percent ( int pc, int x, int y )
{
  if ( pc == 100 )
  {
    number ( 10, x, y );
    number ( 0, x + 2, y );
    number ( 0, x + 8, y );
  }
  else
  {
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 5, 5, 13, 7, x, y );
    if ( pc > 9)
    {
      number ( pc / 10, x + 2, y );
      number ( pc % 10, x + 8, y );
    }
    else
    {
      number ( pc , x + 8, y );
    }
  }
}

void change ( int button, int state, int x, int y )
{
  if ( x > 0 && x < 21 && y > 0 && y < 10 )
    if ( no_nice )
      no_nice--;
    else
      no_nice++;
  else
    if ( x > 20 && x < 58 && y > 0 && y < 10 )
      if ( exe != "" )
      {
        system ( exe );
      }
      else
        fprintf ( stderr, "Warning: no program defined! ( try -p option )\n" );
    else
      if ( button == 1)
        if ( advanced )
          advanced--;
        else
          advanced++;
      else
        if ( up )
          up--;
        else
          up++;
}
int main (int argc, char **argv)
{
  static unsigned b_width = 64;
  static unsigned b_height = 137;

  int cpu_total;
  int old_cpu_user;
  int old_cpu_nice;
  int old_cpu_kernel;
  int old_cpu_idle;
  int cpu_bar_size;
  int cpu_user_bar_size;
  int cpu_nice_bar_size;
  int cpu_kernel_bar_size;

  int mem_bar_size;
  int mem_used_bar_size;
  int mem_buffers_bar_size;
  int mem_cached_bar_size;

  int swap_bar_size;

  /* define callbacks */
  DACallbacks callbacks = { NULL, change, NULL, NULL, NULL, NULL };

  advanced = 0;
  up = 0;
  no_nice = 0;

  /* Parse CommandLine */
  DAParseArguments(argc, argv, options, sizeof(options) / sizeof(DAProgramOption), "WindowMaker CPU / Mem Usage Monitor DockApp", "wmcms 0.3.5");

  /* welcome messages */
  printf ( "wmcms - WindowMaker CPU / Mem Usage Monitor Dock App\nVersion 0.3.5\nTHIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY! USE AT YOUR OWN RISK!\n\n");

  /* invalid delay is fixed */
  if ( delay == 0 )
  {
    fprintf ( stderr, "Warning: invalid interval 0,  reseting to 500 ms\n" );
    delay = 500;
  }

  /* set advanced mode on if asked */
  if (options[2].used)
    advanced = 1;

  /* set 3D bars effect mode on if asked */
  if (options[3].used)
    up = 1;

  /* set nice */
  if (options[4].used)
   no_nice = 1;

  /* fix exe */
  if (options[5].used)
    sprintf ( exe, "%s &", exe );

  /* convert microseconds to miliseconds */
  delay = delay * 1000 ;

  /* Initialize Application */
  DAInitialize(displayName, "wmcms", 58, 58, argc, argv);
  DAMakePixmapFromData(wmcms_xpm, &backdrop, None, &b_width, &b_height);
  pixmap = DAMakePixmap();
  gc = DefaultGC(DADisplay, DefaultScreen(DADisplay));
  DASetCallbacks (&callbacks);
  DAShow();

  /* splash screen */
  XCopyArea ( DADisplay, backdrop, pixmap, gc, 3, 140, 58, 58, 0, 0);
  DASetPixmap(pixmap);

  /* initial cpu total while splash */
  get_cpuinfo();
  old_cpu_user = cpu_user;
  old_cpu_nice = cpu_nice;
  old_cpu_kernel = cpu_kernel;
  old_cpu_idle = cpu_idle;
  usleep ( delay );
  get_cpuinfo();
  cpu_total = cpu_user - old_cpu_user + cpu_nice - old_cpu_nice + cpu_kernel - old_cpu_kernel + cpu_idle - old_cpu_idle;

  /* draw background */
  XCopyArea ( DADisplay, backdrop, pixmap, gc, 3, 3, 58, 58, 0, 0);
  DASetPixmap(pixmap);

  /* update loop */
  for(;;)
  {
    /* starts xevents */
    XEvent ev;

    /* clear bars here */
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 4, 14, 56, 8, 1, 11 );
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 4, 14, 56, 8, 1, 30 );
    XCopyArea ( DADisplay, backdrop, pixmap, gc, 4, 14, 56, 8, 1, 49 );

    /* read values */
    get_cpuinfo ();
    get_meminfo ();

    /* cpu total */
    cpu_total = cpu_user - old_cpu_user + cpu_nice - old_cpu_nice + cpu_kernel - old_cpu_kernel + cpu_idle - old_cpu_idle;

    /* get bars size */
    if ( advanced || ( advanced == 0 && no_nice == 0 ) )
      cpu_bar_size = ( int ) ( ( float ) ( cpu_user - old_cpu_user + cpu_nice - old_cpu_nice + cpu_kernel - old_cpu_kernel ) / ( float ) cpu_total * 56.0 );
    else
      if (no_nice )
        cpu_bar_size = ( int ) ( ( float ) ( cpu_user - old_cpu_user + cpu_kernel - old_cpu_kernel ) / ( float ) cpu_total * 56.0 );
    mem_bar_size = ( int ) ( ( float ) mem_used / ( float ) mem_total * 56.0);
    swap_bar_size = ( int ) ( ( float ) swap_used / ( float ) swap_total * 56.0 );

    if ( advanced )
    {
      /* cpu bars size */
      cpu_kernel_bar_size = ( int ) ( ( float ) ( cpu_kernel - old_cpu_kernel ) / ( float ) cpu_total * 56.0 );
      cpu_nice_bar_size = ( int ) ( ( float ) ( cpu_nice - old_cpu_nice ) / ( float ) cpu_total * 56.0 );
      cpu_user_bar_size = cpu_bar_size - cpu_kernel_bar_size - cpu_nice_bar_size;

      /* draw cpu bars */
      if ( cpu_bar_size != 0 )
      {
        XCopyArea ( DADisplay, backdrop, pixmap, gc, 3, 101, cpu_kernel_bar_size, 8, 1, 11 );
        XCopyArea ( DADisplay, backdrop, pixmap, gc, 3 + cpu_kernel_bar_size, 110, cpu_user_bar_size, 8, 1 + cpu_kernel_bar_size, 11 );
        XCopyArea ( DADisplay, backdrop, pixmap, gc, 3 + cpu_kernel_bar_size + cpu_user_bar_size, 92, cpu_nice_bar_size, 8, 1 + cpu_kernel_bar_size + cpu_user_bar_size, 11 );
        XCopyArea ( DADisplay, backdrop, pixmap, gc, 4, 14, 56 - cpu_bar_size, 8, cpu_bar_size + 1, 11 );
      }

      /* mem bars size*/
      mem_buffers_bar_size = ( int ) ( ( float ) mem_buffers / ( float ) mem_total * 56.0 );
      mem_cached_bar_size = ( int ) ( ( float ) mem_cached / ( float ) mem_total * 56.0 );
      mem_used_bar_size = mem_bar_size - mem_buffers_bar_size - mem_cached_bar_size;

      /* draw mem bars */
      if ( mem_bar_size != 0 )
      {
        XCopyArea ( DADisplay, backdrop, pixmap, gc, 3, 110, mem_used_bar_size, 8, 1, 30 );
        XCopyArea ( DADisplay, backdrop, pixmap, gc, 3 + mem_used_bar_size, 92, mem_buffers_bar_size, 8, 1 + mem_used_bar_size, 30 );
        XCopyArea ( DADisplay, backdrop, pixmap, gc, 3 + mem_used_bar_size + mem_buffers_bar_size, 119, mem_cached_bar_size, 8, 1 + mem_used_bar_size + mem_buffers_bar_size, 30 );
        XCopyArea ( DADisplay, backdrop, pixmap, gc, 4, 14, 56 - mem_bar_size, 8, mem_bar_size + 1, 30 );
      }

      /* draw swap bar */
      bar ( swap_bar_size, 1, 49, 3, 128 );
    }
    else
    {
      /* cpu */
      bar ( cpu_bar_size, 1, 11, 3, 83 );
      /* mem */
      bar ( mem_bar_size, 1, 30, 3, 83 );
      /* swap  */
      bar ( swap_bar_size, 1, 49, 3, 83 );
    }

    /* percents */
    if ( no_nice )
      percent ( ( int ) ( ( float ) ( cpu_user - old_cpu_user + cpu_kernel - old_cpu_kernel ) / ( float ) cpu_total * 100.0), 2, 2 );
    else
      percent ( ( int ) ( ( float ) ( cpu_user - old_cpu_user + cpu_nice - old_cpu_nice + cpu_kernel - old_cpu_kernel ) / ( float ) cpu_total * 100.0), 2, 2 );
    percent ( ( int ) ( ( float ) mem_used / (float) mem_total * 100.0 ), 2, 21 );
    percent ( ( int ) ( ( float ) swap_used / (float) swap_total * 100.0 ), 2, 40 );

    /* draw up effect if asked */
    if ( up )
    {
      upmaker ( cpu_bar_size, 1, 11 );
      upmaker ( mem_bar_size, 1, 30 );
      upmaker ( swap_bar_size, 1, 49 );
    }

    /* do pending xevents */
    while ( XPending ( DADisplay ) )
    {
      XNextEvent(DADisplay, &ev);
      DAProcessEvent(&ev);
    }

    /* apply updates */
    DASetPixmap(pixmap);

    /* update cpu info */
    old_cpu_user = cpu_user;
    old_cpu_nice = cpu_nice;
    old_cpu_kernel = cpu_kernel;
    old_cpu_idle = cpu_idle;

    /* run delay */
    usleep(delay);
  }

  /* this should never be seen... */
  fprintf(stderr, "Congratulations, something truely awful has happened.\n");
  return -1;
}
