#include "estrings.h"

#ifdef __MINGW32__

static std::string unknown = "UNKNOWN ERROR";

ESTRINGS emap[] = {
	{NO_ERROR, "NO ERROR"},
	{ERROR_INVALID_FUNCTION, "INVALID_FUNCTION"},
	{ERROR_FILE_NOT_FOUND, "FILE_NOT_FOUND"},
	{ERROR_PATH_NOT_FOUND, "PATH_NOT_FOUND"},
	{ERROR_TOO_MANY_OPEN_FILES, "TOO_MANY_OPEN_FILES"},
	{ERROR_ACCESS_DENIED, "ACCESS_DENIED"},
	{ERROR_INVALID_HANDLE, "INVALID_HANDLE"},
	{ERROR_ARENA_TRASHED, "ARENA_TRASHED"},
	{ERROR_NOT_ENOUGH_MEMORY, "NOT_ENOUGH_MEMORY"},
	{ERROR_INVALID_BLOCK, "INVALID_BLOCK"},
	{ERROR_BAD_ENVIRONMENT, "BAD_ENVIRONMENT"},
	{ERROR_BAD_FORMAT, "BAD_FORMAT"},
	{ERROR_INVALID_ACCESS, "INVALID_ACCESS"},
	{ERROR_INVALID_DATA, "INVALID_DATA"},
	{ERROR_OUTOFMEMORY, "OUTOFMEMORY"},
	{ERROR_INVALID_DRIVE, "INVALID_DRIVE"},
	{ERROR_CURRENT_DIRECTORY, "CURRENT_DIRECTORY"},
	{ERROR_NOT_SAME_DEVICE, "NOT_SAME_DEVICE"},
	{ERROR_NO_MORE_FILES, "NO_MORE_FILES"},
	{ERROR_WRITE_PROTECT, "WRITE_PROTECT"},
	{ERROR_BAD_UNIT, "BAD_UNIT"},
	{ERROR_NOT_READY, "NOT_READY"},
	{ERROR_BAD_COMMAND, "BAD_COMMAND"},
	{ERROR_CRC, "CRC"},
	{ERROR_BAD_LENGTH, "BAD_LENGTH"},
	{ERROR_SEEK, "SEEK"},
	{ERROR_NOT_DOS_DISK, "NOT_DOS_DISK"},
	{ERROR_SECTOR_NOT_FOUND, "SECTOR_NOT_FOUND"},
	{ERROR_OUT_OF_PAPER, "OUT_OF_PAPER"},
	{ERROR_WRITE_FAULT, "WRITE_FAULT"},
	{ERROR_READ_FAULT, "READ_FAULT"},
	{ERROR_GEN_FAILURE, "GEN_FAILURE"},
	{ERROR_SHARING_VIOLATION, "SHARING_VIOLATION"},
	{ERROR_LOCK_VIOLATION, "LOCK_VIOLATION"},
	{ERROR_WRONG_DISK, "WRONG_DISK"},
	{ERROR_SHARING_BUFFER_EXCEEDED, "SHARING_BUFFER_EXCEEDED"},
	{ERROR_HANDLE_EOF, "HANDLE_EOF"},
	{ERROR_HANDLE_DISK_FULL, "HANDLE_DISK_FULL"},
	{ERROR_NOT_SUPPORTED, "NOT_SUPPORTED"},
	{ERROR_REM_NOT_LIST, "REM_NOT_LIST"},
	{ERROR_DUP_NAME, "DUP_NAME"},
	{ERROR_BAD_NETPATH, "BAD_NETPATH"},
	{ERROR_NETWORK_BUSY, "NETWORK_BUSY"},
	{ERROR_DEV_NOT_EXIST, "DEV_NOT_EXIST"},
	{ERROR_TOO_MANY_CMDS, "TOO_MANY_CMDS"},
	{ERROR_ADAP_HDW_ERR, "ADAP_HDW_ERR"},
	{ERROR_BAD_NET_RESP, "BAD_NET_RESP"},
	{ERROR_UNEXP_NET_ERR, "UNEXP_NET_ERR"},
	{ERROR_BAD_REM_ADAP, "BAD_REM_ADAP"},
	{ERROR_PRINTQ_FULL, "PRINTQ_FULL"},
	{ERROR_NO_SPOOL_SPACE, "NO_SPOOL_SPACE"},
	{ERROR_PRINT_CANCELLED, "PRINT_CANCELLED"},
	{ERROR_NETNAME_DELETED, "NETNAME_DELETED"},
	{ERROR_NETWORK_ACCESS_DENIED, "NETWORK_ACCESS_DENIED"},
	{ERROR_BAD_DEV_TYPE, "BAD_DEV_TYPE"},
	{ERROR_BAD_NET_NAME, "BAD_NET_NAME"},
	{ERROR_TOO_MANY_NAMES, "TOO_MANY_NAMES"},
	{ERROR_TOO_MANY_SESS, "TOO_MANY_SESS"},
	{ERROR_SHARING_PAUSED, "SHARING_PAUSED"},
	{ERROR_REQ_NOT_ACCEP, "REQ_NOT_ACCEP"},
	{ERROR_REDIR_PAUSED, "REDIR_PAUSED"},
	{ERROR_FILE_EXISTS, "FILE_EXISTS"},
	{ERROR_CANNOT_MAKE, "CANNOT_MAKE"},
	{ERROR_FAIL_I24, "FAIL_I24"},
	{ERROR_OUT_OF_STRUCTURES, "OUT_OF_STRUCTURES"},
	{ERROR_ALREADY_ASSIGNED, "ALREADY_ASSIGNED"},
	{ERROR_INVALID_PASSWORD, "INVALID_PASSWORD"},
	{ERROR_INVALID_PARAMETER, "INVALID_PARAMETER"},
	{ERROR_NET_WRITE_FAULT, "NET_WRITE_FAULT"},
	{ERROR_NO_PROC_SLOTS, "NO_PROC_SLOTS"},
	{ERROR_TOO_MANY_SEMAPHORES, "TOO_MANY_SEMAPHORES"},
	{ERROR_EXCL_SEM_ALREADY_OWNED, "EXCL_SEM_ALREADY_OWNED"},
	{ERROR_SEM_IS_SET, "SEM_IS_SET"},
	{ERROR_TOO_MANY_SEM_REQUESTS, "TOO_MANY_SEM_REQUESTS"},
	{ERROR_INVALID_AT_INTERRUPT_TIME, "INVALID_AT_INTERRUPT_TIME"},
	{ERROR_SEM_OWNER_DIED, "SEM_OWNER_DIED"},
	{ERROR_SEM_USER_LIMIT, "SEM_USER_LIMIT"},
	{ERROR_DISK_CHANGE, "DISK_CHANGE"},
	{ERROR_DRIVE_LOCKED, "DRIVE_LOCKED"},
	{ERROR_BROKEN_PIPE, "BROKEN_PIPE"},
	{ERROR_OPEN_FAILED, "OPEN_FAILED"},
	{ERROR_BUFFER_OVERFLOW, "BUFFER_OVERFLOW"},
	{ERROR_DISK_FULL, "DISK_FULL"},
	{ERROR_NO_MORE_SEARCH_HANDLES, "NO_MORE_SEARCH_HANDLES"},
	{ERROR_INVALID_TARGET_HANDLE, "INVALID_TARGET_HANDLE"},
	{ERROR_INVALID_CATEGORY, "INVALID_CATEGORY"},
	{ERROR_INVALID_VERIFY_SWITCH, "INVALID_VERIFY_SWITCH"},
	{ERROR_BAD_DRIVER_LEVEL, "BAD_DRIVER_LEVEL"},
	{ERROR_CALL_NOT_IMPLEMENTED, "CALL_NOT_IMPLEMENTED"},
	{ERROR_SEM_TIMEOUT, "SEM_TIMEOUT"},
	{ERROR_INSUFFICIENT_BUFFER, "INSUFFICIENT_BUFFER"},
	{ERROR_INVALID_NAME, "INVALID_NAME"},
	{ERROR_INVALID_LEVEL, "INVALID_LEVEL"},
};

/*
ERROR_NO_VOLUME_LABEL 125L
ERROR_MOD_NOT_FOUND 126L
ERROR_PROC_NOT_FOUND 127L
ERROR_WAIT_NO_CHILDREN 128L
ERROR_CHILD_NOT_COMPLETE 129L
ERROR_DIRECT_ACCESS_HANDLE 130L
ERROR_NEGATIVE_SEEK 131L
ERROR_SEEK_ON_DEVICE 132L
ERROR_IS_JOIN_TARGET 133L
ERROR_IS_JOINED 134L
ERROR_IS_SUBSTED 135L
ERROR_NOT_JOINED 136L
ERROR_NOT_SUBSTED 137L
ERROR_JOIN_TO_JOIN 138L
ERROR_SUBST_TO_SUBST 139L
ERROR_JOIN_TO_SUBST 140L
ERROR_SUBST_TO_JOIN 141L
ERROR_BUSY_DRIVE 142L
ERROR_SAME_DRIVE 143L
ERROR_DIR_NOT_ROOT 144L
ERROR_DIR_NOT_EMPTY 145L
ERROR_IS_SUBST_PATH 146L
ERROR_IS_JOIN_PATH 147L
ERROR_PATH_BUSY 148L
ERROR_IS_SUBST_TARGET 149L
ERROR_SYSTEM_TRACE 150L
ERROR_INVALID_EVENT_COUNT 151L
ERROR_TOO_MANY_MUXWAITERS 152L
ERROR_INVALID_LIST_FORMAT 153L
ERROR_LABEL_TOO_LONG 154L
ERROR_TOO_MANY_TCBS 155L
ERROR_SIGNAL_REFUSED 156L
ERROR_DISCARDED 157L
ERROR_NOT_LOCKED 158L
ERROR_BAD_THREADID_ADDR 159L
ERROR_BAD_ARGUMENTS 160L
ERROR_BAD_PATHNAME 161L
ERROR_SIGNAL_PENDING 162L
ERROR_MAX_THRDS_REACHED 164L
ERROR_LOCK_FAILED 167L
ERROR_BUSY 170L
ERROR_CANCEL_VIOLATION 173L
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED 174L
ERROR_INVALID_SEGMENT_NUMBER 180L
ERROR_INVALID_ORDINAL 182L
ERROR_ALREADY_EXISTS 183L
ERROR_INVALID_FLAG_NUMBER 186L
ERROR_SEM_NOT_FOUND 187L
ERROR_INVALID_STARTING_CODESEG 188L
ERROR_INVALID_STACKSEG 189L
ERROR_INVALID_MODULETYPE 190L
ERROR_INVALID_EXE_SIGNATURE 191L
ERROR_EXE_MARKED_INVALID 192L
ERROR_BAD_EXE_FORMAT 193L
ERROR_ITERATED_DATA_EXCEEDS_64k 194L
ERROR_INVALID_MINALLOCSIZE 195L
ERROR_DYNLINK_FROM_INVALID_RING 196L
ERROR_IOPL_NOT_ENABLED 197L
ERROR_INVALID_SEGDPL 198L
ERROR_AUTODATASEG_EXCEEDS_64k 199L
ERROR_RING2SEG_MUST_BE_MOVABLE 200L
ERROR_RELOC_CHAIN_XEEDS_SEGLIM 201L
ERROR_INFLOOP_IN_RELOC_CHAIN 202L
ERROR_ENVVAR_NOT_FOUND 203L
ERROR_NO_SIGNAL_SENT 205L
ERROR_FILENAME_EXCED_RANGE 206L
ERROR_RING2_STACK_IN_USE 207L
ERROR_META_EXPANSION_TOO_LONG 208L
ERROR_INVALID_SIGNAL_NUMBER 209L
ERROR_THREAD_1_INACTIVE 210L
ERROR_LOCKED 212L
ERROR_TOO_MANY_MODULES 214L
ERROR_NESTING_NOT_ALLOWED 215L
ERROR_EXE_MACHINE_TYPE_MISMATCH 216L
ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY 217L
ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY 218L
ERROR_BAD_PIPE 230L
ERROR_PIPE_BUSY 231L
ERROR_NO_DATA 232L
ERROR_PIPE_NOT_CONNECTED 233L
ERROR_MORE_DATA 234L
ERROR_VC_DISCONNECTED 240L
ERROR_INVALID_EA_NAME 254L
ERROR_EA_LIST_INCONSISTENT 255L
WAIT_TIMEOUT 258L
ERROR_NO_MORE_ITEMS 259L
ERROR_CANNOT_COPY 266L
ERROR_DIRECTORY 267L
ERROR_EAS_DIDNT_FIT 275L
ERROR_EA_FILE_CORRUPT 276L
ERROR_EA_TABLE_FULL 277L
ERROR_INVALID_EA_HANDLE 278L
ERROR_EAS_NOT_SUPPORTED 282L
ERROR_NOT_OWNER 288L
ERROR_TOO_MANY_POSTS 298L
ERROR_PARTIAL_COPY 299L
ERROR_OPLOCK_NOT_GRANTED 300L
ERROR_INVALID_OPLOCK_PROTOCOL 301L
ERROR_DISK_TOO_FRAGMENTED 302L
ERROR_DELETE_PENDING 303L
ERROR_MR_MID_NOT_FOUND 317L
ERROR_SCOPE_NOT_FOUND 318L
ERROR_INVALID_ADDRESS 487L
ERROR_ARITHMETIC_OVERFLOW 534L
ERROR_PIPE_CONNECTED 535L
ERROR_PIPE_LISTENING 536L
ERROR_EA_ACCESS_DENIED 994L
ERROR_OPERATION_ABORTED 995L
ERROR_IO_INCOMPLETE 996L
ERROR_IO_PENDING 997L
ERROR_NOACCESS 998L
ERROR_SWAPERROR 999L
ERROR_STACK_OVERFLOW 1001L
ERROR_INVALID_MESSAGE 1002L
ERROR_CAN_NOT_COMPLETE 1003L
ERROR_INVALID_FLAGS 1004L
ERROR_UNRECOGNIZED_VOLUME 1005L
ERROR_FILE_INVALID 1006L
ERROR_FULLSCREEN_MODE 1007L
ERROR_NO_TOKEN 1008L
ERROR_BADDB 1009L
ERROR_BADKEY 1010L
ERROR_CANTOPEN 1011L
ERROR_CANTREAD 1012L
ERROR_CANTWRITE 1013L
ERROR_REGISTRY_RECOVERED 1014L
ERROR_REGISTRY_CORRUPT 1015L
ERROR_REGISTRY_IO_FAILED 1016L
ERROR_NOT_REGISTRY_FILE 1017L
ERROR_KEY_DELETED 1018L
ERROR_NO_LOG_SPACE 1019L
ERROR_KEY_HAS_CHILDREN 1020L
ERROR_CHILD_MUST_BE_VOLATILE 1021L
ERROR_NOTIFY_ENUM_DIR 1022L
ERROR_DEPENDENT_SERVICES_RUNNING 1051L
ERROR_INVALID_SERVICE_CONTROL 1052L
ERROR_SERVICE_REQUEST_TIMEOUT 1053L
ERROR_SERVICE_NO_THREAD 1054L
ERROR_SERVICE_DATABASE_LOCKED 1055L
ERROR_SERVICE_ALREADY_RUNNING 1056L
ERROR_INVALID_SERVICE_ACCOUNT 1057L
ERROR_SERVICE_DISABLED 1058L
ERROR_CIRCULAR_DEPENDENCY 1059L
ERROR_SERVICE_DOES_NOT_EXIST 1060L
ERROR_SERVICE_CANNOT_ACCEPT_CTRL 1061L
ERROR_SERVICE_NOT_ACTIVE 1062L
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT 1063L
ERROR_EXCEPTION_IN_SERVICE 1064L
ERROR_DATABASE_DOES_NOT_EXIST 1065L
ERROR_SERVICE_SPECIFIC_ERROR 1066L
ERROR_PROCESS_ABORTED 1067L
ERROR_SERVICE_DEPENDENCY_FAIL 1068L
ERROR_SERVICE_LOGON_FAILED 1069L
ERROR_SERVICE_START_HANG 1070L
ERROR_INVALID_SERVICE_LOCK 1071L
ERROR_SERVICE_MARKED_FOR_DELETE 1072L
ERROR_SERVICE_EXISTS 1073L
ERROR_ALREADY_RUNNING_LKG 1074L
ERROR_SERVICE_DEPENDENCY_DELETED 1075L
ERROR_BOOT_ALREADY_ACCEPTED 1076L
ERROR_SERVICE_NEVER_STARTED 1077L
ERROR_DUPLICATE_SERVICE_NAME 1078L
ERROR_DIFFERENT_SERVICE_ACCOUNT 1079L
ERROR_CANNOT_DETECT_DRIVER_FAILURE 1080L
ERROR_CANNOT_DETECT_PROCESS_ABORT 1081L
ERROR_NO_RECOVERY_PROGRAM 1082L
ERROR_SERVICE_NOT_IN_EXE 1083L
ERROR_NOT_SAFEBOOT_SERVICE 1084L
ERROR_END_OF_MEDIA 1100L
ERROR_FILEMARK_DETECTED 1101L
ERROR_BEGINNING_OF_MEDIA 1102L
ERROR_SETMARK_DETECTED 1103L
ERROR_NO_DATA_DETECTED 1104L
ERROR_PARTITION_FAILURE 1105L
ERROR_INVALID_BLOCK_LENGTH 1106L
ERROR_DEVICE_NOT_PARTITIONED 1107L
ERROR_UNABLE_TO_LOCK_MEDIA 1108L
ERROR_UNABLE_TO_UNLOAD_MEDIA 1109L
ERROR_MEDIA_CHANGED 1110L
ERROR_BUS_RESET 1111L
ERROR_NO_MEDIA_IN_DRIVE 1112L
ERROR_NO_UNICODE_TRANSLATION 1113L
ERROR_DLL_INIT_FAILED 1114L
ERROR_SHUTDOWN_IN_PROGRESS 1115L
ERROR_NO_SHUTDOWN_IN_PROGRESS 1116L
ERROR_IO_DEVICE 1117L
ERROR_SERIAL_NO_DEVICE 1118L
ERROR_IRQ_BUSY 1119L
ERROR_MORE_WRITES 1120L
ERROR_COUNTER_TIMEOUT 1121L
ERROR_FLOPPY_ID_MARK_NOT_FOUND 1122L
ERROR_FLOPPY_WRONG_CYLINDER 1123L
ERROR_FLOPPY_UNKNOWN_ERROR 1124L
ERROR_FLOPPY_BAD_REGISTERS 1125L
ERROR_DISK_RECALIBRATE_FAILED 1126L
ERROR_DISK_OPERATION_FAILED 1127L
ERROR_DISK_RESET_FAILED 1128L
ERROR_EOM_OVERFLOW 1129L
ERROR_NOT_ENOUGH_SERVER_MEMORY 1130L
ERROR_POSSIBLE_DEADLOCK 1131L
ERROR_MAPPED_ALIGNMENT 1132L
ERROR_SET_POWER_STATE_VETOED 1140L
ERROR_SET_POWER_STATE_FAILED 1141L
ERROR_TOO_MANY_LINKS 1142L
ERROR_OLD_WIN_VERSION 1150L
ERROR_APP_WRONG_OS 1151L
ERROR_SINGLE_INSTANCE_APP 1152L
ERROR_RMODE_APP 1153L
ERROR_INVALID_DLL 1154L
ERROR_NO_ASSOCIATION 1155L
ERROR_DDE_FAIL 1156L
ERROR_DLL_NOT_FOUND 1157L
ERROR_NO_MORE_USER_HANDLES 1158L
ERROR_MESSAGE_SYNC_ONLY 1159L
ERROR_SOURCE_ELEMENT_EMPTY 1160L
ERROR_DESTINATION_ELEMENT_FULL 1161L
ERROR_ILLEGAL_ELEMENT_ADDRESS 1162L
ERROR_MAGAZINE_NOT_PRESENT 1163L
ERROR_DEVICE_REINITIALIZATION_NEEDED 1164L
ERROR_DEVICE_REQUIRES_CLEANING 1165L
ERROR_DEVICE_DOOR_OPEN 1166L
ERROR_DEVICE_NOT_CONNECTED 1167L
ERROR_NOT_FOUND 1168L
ERROR_NO_MATCH 1169L
ERROR_SET_NOT_FOUND 1170L
ERROR_POINT_NOT_FOUND 1171L
ERROR_NO_TRACKING_SERVICE 1172L
ERROR_NO_VOLUME_ID 1173L
ERROR_UNABLE_TO_REMOVE_REPLACED 1175L
ERROR_UNABLE_TO_MOVE_REPLACEMENT 1176L
ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 1177L
ERROR_JOURNAL_DELETE_IN_PROGRESS 1178L
ERROR_JOURNAL_NOT_ACTIVE 1179L
ERROR_POTENTIAL_FILE_FOUND 1180L
ERROR_JOURNAL_ENTRY_DELETED 1181L
ERROR_BAD_DEVICE 1200L
ERROR_CONNECTION_UNAVAIL 1201L
ERROR_DEVICE_ALREADY_REMEMBERED 1202L
ERROR_NO_NET_OR_BAD_PATH 1203L
ERROR_BAD_PROVIDER 1204L
ERROR_CANNOT_OPEN_PROFILE 1205L
ERROR_BAD_PROFILE 1206L
ERROR_NOT_CONTAINER 1207L
ERROR_EXTENDED_ERROR 1208L
ERROR_INVALID_GROUPNAME 1209L
ERROR_INVALID_COMPUTERNAME 1210L
ERROR_INVALID_EVENTNAME 1211L
ERROR_INVALID_DOMAINNAME 1212L
ERROR_INVALID_SERVICENAME 1213L
ERROR_INVALID_NETNAME 1214L
ERROR_INVALID_SHARENAME 1215L
ERROR_INVALID_PASSWORDNAME 1216L
ERROR_INVALID_MESSAGENAME 1217L
ERROR_INVALID_MESSAGEDEST 1218L
ERROR_SESSION_CREDENTIAL_CONFLICT 1219L
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED 1220L
ERROR_DUP_DOMAINNAME 1221L
ERROR_NO_NETWORK 1222L
ERROR_CANCELLED 1223L
ERROR_USER_MAPPED_FILE 1224L
ERROR_CONNECTION_REFUSED 1225L
ERROR_GRACEFUL_DISCONNECT 1226L
ERROR_ADDRESS_ALREADY_ASSOCIATED 1227L
ERROR_ADDRESS_NOT_ASSOCIATED 1228L
ERROR_CONNECTION_INVALID 1229L
ERROR_CONNECTION_ACTIVE 1230L
ERROR_NETWORK_UNREACHABLE 1231L
ERROR_HOST_UNREACHABLE 1232L
ERROR_PROTOCOL_UNREACHABLE 1233L
ERROR_PORT_UNREACHABLE 1234L
ERROR_REQUEST_ABORTED 1235L
ERROR_CONNECTION_ABORTED 1236L
ERROR_RETRY 1237L
ERROR_CONNECTION_COUNT_LIMIT 1238L
ERROR_LOGIN_TIME_RESTRICTION 1239L
ERROR_LOGIN_WKSTA_RESTRICTION 1240L
ERROR_INCORRECT_ADDRESS 1241L
ERROR_ALREADY_REGISTERED 1242L
ERROR_SERVICE_NOT_FOUND 1243L
ERROR_NOT_AUTHENTICATED 1244L
ERROR_NOT_LOGGED_ON 1245L
ERROR_CONTINUE 1246L
ERROR_ALREADY_INITIALIZED 1247L
ERROR_NO_MORE_DEVICES 1248L
ERROR_NO_SUCH_SITE 1249L
ERROR_DOMAIN_CONTROLLER_EXISTS 1250L
ERROR_ONLY_IF_CONNECTED 1251L
ERROR_OVERRIDE_NOCHANGES 1252L
ERROR_BAD_USER_PROFILE 1253L
ERROR_NOT_SUPPORTED_ON_SBS 1254L
ERROR_SERVER_SHUTDOWN_IN_PROGRESS 1255L
ERROR_HOST_DOWN 1256L
ERROR_NON_ACCOUNT_SID 1257L
ERROR_NON_DOMAIN_SID 1258L
ERROR_APPHELP_BLOCK 1259L
ERROR_ACCESS_DISABLED_BY_POLICY 1260L
ERROR_REG_NAT_CONSUMPTION 1261L
ERROR_CSCSHARE_OFFLINE 1262L
ERROR_PKINIT_FAILURE 1263L
ERROR_SMARTCARD_SUBSYSTEM_FAILURE 1264L
ERROR_DOWNGRADE_DETECTED 1265L
SEC_E_SMARTCARD_CERT_REVOKED 1266L
SEC_E_ISSUING_CA_UNTRUSTED 1267L
SEC_E_REVOCATION_OFFLINE_C 1268L
SEC_E_PKINIT_CLIENT_FAILUR 1269L
SEC_E_SMARTCARD_CERT_EXPIRED 1270L
ERROR_MACHINE_LOCKED 1271L
ERROR_CALLBACK_SUPPLIED_INVALID_DATA 1273L
ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED 1274L
ERROR_DRIVER_BLOCKED 1275L
ERROR_INVALID_IMPORT_OF_NON_DLL 1276L
ERROR_ACCESS_DISABLED_WEBBLADE 1277L
ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER 1278L
ERROR_RECOVERY_FAILURE 1279L
ERROR_ALREADY_FIBER 1280L
ERROR_ALREADY_THREAD 1281L
ERROR_STACK_BUFFER_OVERRUN 1282L
ERROR_PARAMETER_QUOTA_EXCEEDED 1283L
ERROR_DEBUGGER_INACTIVE 1284L
ERROR_NOT_ALL_ASSIGNED 1300L
ERROR_SOME_NOT_MAPPED 1301L
ERROR_NO_QUOTAS_FOR_ACCOUNT 1302L
ERROR_LOCAL_USER_SESSION_KEY 1303L
ERROR_NULL_LM_PASSWORD 1304L
ERROR_UNKNOWN_REVISION 1305L
ERROR_REVISION_MISMATCH 1306L
ERROR_INVALID_OWNER 1307L
ERROR_INVALID_PRIMARY_GROUP 1308L
ERROR_NO_IMPERSONATION_TOKEN 1309L
ERROR_CANT_DISABLE_MANDATORY 1310L
ERROR_NO_LOGON_SERVERS 1311L
ERROR_NO_SUCH_LOGON_SESSION 1312L
ERROR_NO_SUCH_PRIVILEGE 1313L
ERROR_PRIVILEGE_NOT_HELD 1314L
ERROR_INVALID_ACCOUNT_NAME 1315L
ERROR_USER_EXISTS 1316L
ERROR_NO_SUCH_USER 1317L
ERROR_GROUP_EXISTS 1318L
ERROR_NO_SUCH_GROUP 1319L
ERROR_MEMBER_IN_GROUP 1320L
ERROR_MEMBER_NOT_IN_GROUP 1321L
ERROR_LAST_ADMIN 1322L
ERROR_WRONG_PASSWORD 1323L
ERROR_ILL_FORMED_PASSWORD 1324L
ERROR_PASSWORD_RESTRICTION 1325L
ERROR_LOGON_FAILURE 1326L
ERROR_ACCOUNT_RESTRICTION 1327L
ERROR_INVALID_LOGON_HOURS 1328L
ERROR_INVALID_WORKSTATION 1329L
ERROR_PASSWORD_EXPIRED 1330L
ERROR_ACCOUNT_DISABLED 1331L
ERROR_NONE_MAPPED 1332L
ERROR_TOO_MANY_LUIDS_REQUESTED 1333L
ERROR_LUIDS_EXHAUSTED 1334L
ERROR_INVALID_SUB_AUTHORITY 1335L
ERROR_INVALID_ACL 1336L
ERROR_INVALID_SID 1337L
ERROR_INVALID_SECURITY_DESCR 1338L
ERROR_BAD_INHERITANCE_ACL 1340L
ERROR_SERVER_DISABLED 1341L
ERROR_SERVER_NOT_DISABLED 1342L
ERROR_INVALID_ID_AUTHORITY 1343L
ERROR_ALLOTTED_SPACE_EXCEEDED 1344L
ERROR_INVALID_GROUP_ATTRIBUTES 1345L
ERROR_BAD_IMPERSONATION_LEVEL 1346L
ERROR_CANT_OPEN_ANONYMOUS 1347L
ERROR_BAD_VALIDATION_CLASS 1348L
ERROR_BAD_TOKEN_TYPE 1349L
ERROR_NO_SECURITY_ON_OBJECT 1350L
ERROR_CANT_ACCESS_DOMAIN_INFO 1351L
ERROR_INVALID_SERVER_STATE 1352L
ERROR_INVALID_DOMAIN_STATE 1353L
ERROR_INVALID_DOMAIN_ROLE 1354L
ERROR_NO_SUCH_DOMAIN 1355L
ERROR_DOMAIN_EXISTS 1356L
ERROR_DOMAIN_LIMIT_EXCEEDED 1357L
ERROR_INTERNAL_DB_CORRUPTION 1358L
ERROR_INTERNAL_ERROR 1359L
ERROR_GENERIC_NOT_MAPPED 1360L
ERROR_BAD_DESCRIPTOR_FORMAT 1361L
ERROR_NOT_LOGON_PROCESS 1362L
ERROR_LOGON_SESSION_EXISTS 1363L
ERROR_NO_SUCH_PACKAGE 1364L
ERROR_BAD_LOGON_SESSION_STATE 1365L
ERROR_LOGON_SESSION_COLLISION 1366L
ERROR_INVALID_LOGON_TYPE 1367L
ERROR_CANNOT_IMPERSONATE 1368L
ERROR_RXACT_INVALID_STATE 1369L
ERROR_RXACT_COMMIT_FAILURE 1370L
ERROR_SPECIAL_ACCOUNT 1371L
ERROR_SPECIAL_GROUP 1372L
ERROR_SPECIAL_USER 1373L
ERROR_MEMBERS_PRIMARY_GROUP 1374L
ERROR_TOKEN_ALREADY_IN_USE 1375L
ERROR_NO_SUCH_ALIAS 1376L
ERROR_MEMBER_NOT_IN_ALIAS 1377L
ERROR_MEMBER_IN_ALIAS 1378L
ERROR_ALIAS_EXISTS 1379L
ERROR_LOGON_NOT_GRANTED 1380L
ERROR_TOO_MANY_SECRETS 1381L
ERROR_SECRET_TOO_LONG 1382L
ERROR_INTERNAL_DB_ERROR 1383L
ERROR_TOO_MANY_CONTEXT_IDS 1384L
ERROR_LOGON_TYPE_NOT_GRANTED 1385L
ERROR_NT_CROSS_ENCRYPTION_REQUIRED 1386L
ERROR_NO_SUCH_MEMBER 1387L
ERROR_INVALID_MEMBER 1388L
ERROR_TOO_MANY_SIDS 1389L
ERROR_LM_CROSS_ENCRYPTION_REQUIRED 1390L
ERROR_NO_INHERITANCE 1391L
ERROR_FILE_CORRUPT 1392L
ERROR_DISK_CORRUPT 1393L
ERROR_NO_USER_SESSION_KEY 1394L
ERROR_LICENSE_QUOTA_EXCEEDED 1395L
ERROR_WRONG_TARGET_NAME 1396L
ERROR_MUTUAL_AUTH_FAILED 1397L
ERROR_TIME_SKEW 1398L
ERROR_CURRENT_DOMAIN_NOT_ALLOWED 1399L
ERROR_INVALID_WINDOW_HANDLE 1400L
ERROR_INVALID_MENU_HANDLE 1401L
ERROR_INVALID_CURSOR_HANDLE 1402L
ERROR_INVALID_ACCEL_HANDLE 1403L
ERROR_INVALID_HOOK_HANDLE 1404L
ERROR_INVALID_DWP_HANDLE 1405L
ERROR_TLW_WITH_WSCHILD 1406L
ERROR_CANNOT_FIND_WND_CLASS 1407L
ERROR_WINDOW_OF_OTHER_THREAD 1408L
ERROR_HOTKEY_ALREADY_REGISTERED 1409L
ERROR_CLASS_ALREADY_EXISTS 1410L
ERROR_CLASS_DOES_NOT_EXIST 1411L
ERROR_CLASS_HAS_WINDOWS 1412L
ERROR_INVALID_INDEX 1413L
ERROR_INVALID_ICON_HANDLE 1414L
ERROR_PRIVATE_DIALOG_INDEX 1415L
ERROR_LISTBOX_ID_NOT_FOUND 1416L
ERROR_NO_WILDCARD_CHARACTERS 1417L
ERROR_CLIPBOARD_NOT_OPEN 1418L
ERROR_HOTKEY_NOT_REGISTERED 1419L
ERROR_WINDOW_NOT_DIALOG 1420L
ERROR_CONTROL_ID_NOT_FOUND 1421L
ERROR_INVALID_COMBOBOX_MESSAGE 1422L
ERROR_WINDOW_NOT_COMBOBOX 1423L
ERROR_INVALID_EDIT_HEIGHT 1424L
ERROR_DC_NOT_FOUND 1425L
ERROR_INVALID_HOOK_FILTER 1426L
ERROR_INVALID_FILTER_PROC 1427L
ERROR_HOOK_NEEDS_HMOD 1428L
ERROR_GLOBAL_ONLY_HOOK 1429L
ERROR_JOURNAL_HOOK_SET 1430L
ERROR_HOOK_NOT_INSTALLED 1431L
ERROR_INVALID_LB_MESSAGE 1432L
ERROR_SETCOUNT_ON_BAD_LB 1433L
ERROR_LB_WITHOUT_TABSTOPS 1434L
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD 1435L
ERROR_CHILD_WINDOW_MENU 1436L
ERROR_NO_SYSTEM_MENU 1437L
ERROR_INVALID_MSGBOX_STYLE 1438L
ERROR_INVALID_SPI_VALUE 1439L
ERROR_SCREEN_ALREADY_LOCKED 1440L
ERROR_HWNDS_HAVE_DIFF_PARENT 1441L
ERROR_NOT_CHILD_WINDOW 1442L
ERROR_INVALID_GW_COMMAND 1443L
ERROR_INVALID_THREAD_ID 1444L
ERROR_NON_MDICHILD_WINDOW 1445L
ERROR_POPUP_ALREADY_ACTIVE 1446L
ERROR_NO_SCROLLBARS 1447L
ERROR_INVALID_SCROLLBAR_RANGE 1448L
ERROR_INVALID_SHOWWIN_COMMAND 1449L
ERROR_NO_SYSTEM_RESOURCES 1450L
ERROR_NONPAGED_SYSTEM_RESOURCES 1451L
ERROR_PAGED_SYSTEM_RESOURCES 1452L
ERROR_WORKING_SET_QUOTA 1453L
ERROR_PAGEFILE_QUOTA 1454L
ERROR_COMMITMENT_LIMIT 1455L
ERROR_MENU_ITEM_NOT_FOUND 1456L
ERROR_INVALID_KEYBOARD_HANDLE 1457L
ERROR_HOOK_TYPE_NOT_ALLOWED 1458L
ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION 1459L
ERROR_TIMEOUT 1460L
ERROR_INVALID_MONITOR_HANDLE 1461L
ERROR_EVENTLOG_FILE_CORRUPT 1500L
ERROR_EVENTLOG_CANT_START 1501L
ERROR_LOG_FILE_FULL 1502L
ERROR_EVENTLOG_FILE_CHANGED 1503L
ERROR_INSTALL_SERVICE_FAILURE 1601L
ERROR_INSTALL_USEREXIT 1602L
ERROR_INSTALL_FAILURE 1603L
ERROR_INSTALL_SUSPEND 1604L
ERROR_UNKNOWN_PRODUCT 1605L
ERROR_UNKNOWN_FEATURE 1606L
ERROR_UNKNOWN_COMPONENT 1607L
ERROR_UNKNOWN_PROPERTY 1608L
ERROR_INVALID_HANDLE_STATE 1609L
ERROR_BAD_CONFIGURATION 1610L
ERROR_INDEX_ABSENT 1611L
ERROR_INSTALL_SOURCE_ABSENT 1612L
ERROR_INSTALL_PACKAGE_VERSION 1613L
ERROR_PRODUCT_UNINSTALLED 1614L
ERROR_BAD_QUERY_SYNTAX 1615L
ERROR_INVALID_FIELD 1616L
ERROR_DEVICE_REMOVED 1617L
ERROR_INSTALL_ALREADY_RUNNING 1618L
ERROR_INSTALL_PACKAGE_OPEN_FAILED 1619L
ERROR_INSTALL_PACKAGE_INVALID 1620L
ERROR_INSTALL_UI_FAILURE 1621L
ERROR_INSTALL_LOG_FAILURE 1622L
ERROR_INSTALL_LANGUAGE_UNSUPPORTED 1623L
ERROR_INSTALL_TRANSFORM_FAILURE 1624L
ERROR_INSTALL_PACKAGE_REJECTED 1625L
ERROR_FUNCTION_NOT_CALLED 1626L
ERROR_FUNCTION_FAILED 1627L
ERROR_INVALID_TABLE 1628L
ERROR_DATATYPE_MISMATCH 1629L
ERROR_UNSUPPORTED_TYPE 1630L
ERROR_CREATE_FAILED 1631L
ERROR_INSTALL_TEMP_UNWRITABLE 1632L
ERROR_INSTALL_PLATFORM_UNSUPPORTED 1633L
ERROR_INSTALL_NOTUSED 1634L
ERROR_PATCH_PACKAGE_OPEN_FAILED 1635L
ERROR_PATCH_PACKAGE_INVALID 1636L
ERROR_PATCH_PACKAGE_UNSUPPORTED 1637L
ERROR_PRODUCT_VERSION 1638L
ERROR_INVALID_COMMAND_LINE 1639L
ERROR_INSTALL_REMOTE_DISALLOWED 1640L
ERROR_SUCCESS_REBOOT_INITIATED 1641L
ERROR_PATCH_TARGET_NOT_FOUND 1642L
ERROR_PATCH_PACKAGE_REJECTED 1643L
ERROR_INSTALL_TRANSFORM_REJECTED 1644L
ERROR_INSTALL_REMOTE_PROHIBITED 1645L
*/

static int esize = static_cast<int>(sizeof(emap) / sizeof(ESTRINGS));

std::string &win_error_string(long err) {
	int mark = -1;
	for (int i = 0; i < esize; i++) {
		if (emap[i].ecode == err) {
			mark = i;
			break;
		}
	}
	if (mark == -1) return unknown;
	return emap[mark].estring;
}

#endif
