---
title: "Privacy Policy"
description: "Rclone Privacy Policy"
---

# Rclone Privacy Policy

## What is this Privacy Policy for?

This privacy policy is for this website <https://rclone.org> and governs the
privacy of its users who choose to use it.

The policy sets out the different areas where user privacy is concerned and
outlines the obligations & requirements of the users, the website and website
owners. Furthermore the way this website processes, stores and protects user
data and information will also be detailed within this policy.

## The Website

This website and its owners take a proactive approach to user privacy and
ensure the necessary steps are taken to protect the privacy of its users
throughout their visiting experience. This website complies to all UK national
laws and requirements for user privacy.

## Use of Cookies

This website uses cookies to better the users experience while visiting the
website. Where applicable this website uses a cookie control system allowing
the user on their first visit to the website to allow or disallow the use of
cookies on their computer / device. This complies with recent legislation
requirements for websites to obtain explicit consent from users before leaving
behind or reading files such as cookies on a user's computer / device.

Cookies are small files saved to the user's computers hard drive that track,
save and store information about the user's interactions and usage of the
website. This allows the website, through its server to provide the users with
a tailored experience within this website.

Users are advised that if they wish to deny the use and saving of cookies from
this website on to their computers hard drive they should take necessary steps
within their web browsers security settings to block all cookies from this
website and its external serving vendors.

This website uses tracking software to monitor its visitors to better
understand how they use it. This software is provided by Google Analytics which
uses cookies to track visitor usage. The software will save a cookie to your
computers hard drive in order to track and monitor your engagement and usage of
the website, but will not store, save or collect personal information. You can
read [Google's privacy policy here](https://www.google.com/privacy.html) for
further information.

Other cookies may be stored to your computers hard drive by external vendors
when this website uses referral programs, sponsored links or adverts. Such
cookies are used for conversion and referral tracking and typically expire
after 30 days, though some may take longer. No personal information is stored,
saved or collected.

## Contact & Communication

Users contacting this website and/or its owners do so at their own discretion
and provide any such personal details requested at their own risk. Your
personal information is kept private and stored securely until a time it is no
longer required or has no use, as detailed in the Data Protection Act 1998.

This website and its owners use any information submitted to provide you with
further information about the products / services they offer or to assist you
in answering any questions or queries you may have submitted.

## External Links

Although this website only looks to include quality, safe and relevant external
links, users are advised adopt a policy of caution before clicking any external
web links mentioned throughout this website.

The owners of this website cannot guarantee or verify the contents of any
externally linked website despite their best efforts. Users should therefore
note they click on external links at their own risk and this website and its
owners cannot be held liable for any damages or implications caused by visiting
any external links mentioned.

## Adverts and Sponsored Links

This website may contain sponsored links and adverts. These will typically be
served through our advertising partners, to whom may have detailed privacy
policies relating directly to the adverts they serve.

Clicking on any such adverts will send you to the advertisers website through a
referral program which may use cookies and will track the number of referrals
sent from this website. This may include the use of cookies which may in turn
be saved on your computers hard drive. Users should therefore note they click
on sponsored external links at their own risk and this website and its owners
cannot be held liable for any damages or implications caused by visiting any
external links mentioned.

### Social Media Platforms

Communication, engagement and actions taken through external social media
platforms that this website and its owners participate on are subject to the
terms and conditions as well as the privacy policies held with each social media
platform respectively.

Users are advised to use social media platforms wisely and communicate / engage
upon them with due care and caution in regard to their own privacy and personal
details. This website nor its owners will ever ask for personal or sensitive
information through social media platforms and encourage users wishing to
discuss sensitive details to contact them through primary communication channels
such as email.

This website may use social sharing buttons which help share web content
directly from web pages to the social media platform in question. Users are
advised before using such social sharing buttons that they do so at their own
discretion and note that the social media platform may track and save your
request to share a web page respectively through your social media platform
account.

## Use of Cloud API User Data

Rclone is a command-line program to manage files on cloud storage. Its sole
purpose is to access and manipulate user content in the [supported](/overview/)
cloud storage systems from a local machine of the end user. For accessing the
user content via the cloud provider API, Rclone uses authentication mechanisms,
such as OAuth or HTTP Cookies, depending on the particular cloud provider
offerings. Use of these authentication mechanisms and user data is governed by
the privacy policies mentioned in the [Resources & Further Information](/privacy/#resources-further-information)
section and followed by the privacy policy of Rclone.

- Rclone provides the end user with access to their files available in a storage
  system associated by the authentication credentials via the publicly exposed API
  of the storage system.
- Rclone allows storing the authentication credentials on the user machine in the
  local configuration file.
- Rclone does not share any user data with third parties.

## Resources & Further Information

- [Data Protection Act 1998](http://www.legislation.gov.uk/ukpga/1998/29/contents)
- [Privacy and Electronic Communications Regulations 2003](http://www.legislation.gov.uk/uksi/2003/2426/contents/made)
- [Privacy and Electronic Communications Regulations 2003 - The Guide](https://ico.org.uk/for-organisations/guide-to-pecr/)
- [Twitter Privacy Policy](https://twitter.com/privacy)
- [Facebook Privacy Policy](https://www.facebook.com/about/privacy/)
- [Google Privacy Policy](https://www.google.com/privacy.html)
- [Google API Services User Data Policy](https://developers.google.com/terms/api-services-user-data-policy)
- [Sample Website Privacy Policy](http://www.jamieking.co.uk/resources/free_sample_privacy_policy.html)
