import { t as e } from "./tag-mixin-QzWi2jRe.js";
var t = { mixins: [e], methods: { getItemTypeLabel(e2) {
  let t2 = e2.type;
  return e2.type === "Group" && e2.groupType && (t2 += " (".concat(e2.groupType), e2.function.name && (t2 += ":".concat(e2.function.name), e2.function.params && (t2 += "(".concat(e2.function.params.join(","), ")"))), t2 += ")"), t2;
}, getItemTypeAndMetaLabel(e2) {
  let t2 = this.getItemTypeLabel(e2);
  if (e2.metadata && e2.metadata.semantics) {
    t2 += " \xB7 ";
    let n = e2.metadata.semantics.value.split("_");
    if (t2 += n[0], n.length > 1 && (t2 += " > " + n.pop(), e2.metadata.semantics.config && e2.metadata.semantics.config.relatesTo)) {
      let n2 = e2.metadata.semantics.config.relatesTo.split("_");
      n2.length > 1 && (t2 += " > " + n2.pop());
    }
  }
  return t2;
}, getNonSemanticTags(e2) {
  return e2.tags ? e2.tags.filter((e3) => !this.isSemanticTag(e3)) : [];
}, validateItemName(e2) {
  if (/^[A-Za-z_][A-Za-z0-9_]*$/.test(e2)) {
    if (this.items && this.items.some((t2) => t2.name === e2)) return "An Item with this name already exists";
  } else return "Required. Must not start with a number. A-Z,a-z,0-9,_ only";
  return "";
}, saveItem(e2) {
  e2.groupType === "None" && delete e2.groupType, e2.function === "None" && delete e2.groupType;
  let t2 = e2.unit;
  delete e2.unit;
  let n = e2.stateDescriptionPattern;
  return delete e2.stateDescriptionPattern, this.$oh.api.put("/rest/items/" + e2.name, e2).then(() => this.saveUnit(e2, t2)).then(() => this.saveStateDescription(e2, n)).catch((e3) => Promise.reject(e3));
}, saveUnit(e2, t2) {
  var _a;
  if ((e2.type.startsWith("Number:") || ((_a = e2.groupType) == null ? void 0 : _a.startsWith("Number:"))) && t2) {
    let n = { value: t2, config: {} };
    return this.saveMetadata(e2, "unit", n);
  } else return Promise.resolve();
}, saveStateDescription(e2, t2) {
  var _a;
  if ((e2.type.startsWith("Number:") || ((_a = e2.groupType) == null ? void 0 : _a.startsWith("Number:"))) && t2) {
    let n = { value: " ", config: { pattern: t2 } };
    return this.saveMetadata(e2, "stateDescription", n);
  } else return Promise.resolve();
}, saveMetadata(e2, t2, n) {
  return this.$oh.api.put("/rest/items/" + e2.name + "/metadata/" + t2, n);
}, deleteMetadata(e2, t2) {
  return this.$oh.api.delete("/rest/items/" + e2.name + "/metadata/" + t2);
} } };
export {
  t
};
