/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type m64p_dynlib_handle = *mut ::std::os::raw::c_void;
pub const m64p_error_M64ERR_SUCCESS: m64p_error = 0;
pub const m64p_error_M64ERR_NOT_INIT: m64p_error = 1;
pub const m64p_error_M64ERR_ALREADY_INIT: m64p_error = 2;
pub const m64p_error_M64ERR_INCOMPATIBLE: m64p_error = 3;
pub const m64p_error_M64ERR_INPUT_ASSERT: m64p_error = 4;
pub const m64p_error_M64ERR_INPUT_INVALID: m64p_error = 5;
pub const m64p_error_M64ERR_INPUT_NOT_FOUND: m64p_error = 6;
pub const m64p_error_M64ERR_NO_MEMORY: m64p_error = 7;
pub const m64p_error_M64ERR_FILES: m64p_error = 8;
pub const m64p_error_M64ERR_INTERNAL: m64p_error = 9;
pub const m64p_error_M64ERR_INVALID_STATE: m64p_error = 10;
pub const m64p_error_M64ERR_PLUGIN_FAIL: m64p_error = 11;
pub const m64p_error_M64ERR_SYSTEM_FAIL: m64p_error = 12;
pub const m64p_error_M64ERR_UNSUPPORTED: m64p_error = 13;
pub const m64p_error_M64ERR_WRONG_TYPE: m64p_error = 14;
pub type m64p_error = ::std::os::raw::c_int;
pub const m64p_plugin_type_M64PLUGIN_NULL: m64p_plugin_type = 0;
pub const m64p_plugin_type_M64PLUGIN_RSP: m64p_plugin_type = 1;
pub const m64p_plugin_type_M64PLUGIN_GFX: m64p_plugin_type = 2;
pub const m64p_plugin_type_M64PLUGIN_AUDIO: m64p_plugin_type = 3;
pub const m64p_plugin_type_M64PLUGIN_INPUT: m64p_plugin_type = 4;
pub const m64p_plugin_type_M64PLUGIN_CORE: m64p_plugin_type = 5;
pub type m64p_plugin_type = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CONTROL {
    pub Present: ::std::os::raw::c_int,
    pub RawData: ::std::os::raw::c_int,
    pub Plugin: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_CONTROL() {
    assert_eq!(
        ::std::mem::size_of::<CONTROL>(),
        12usize,
        concat!("Size of: ", stringify!(CONTROL))
    );
    assert_eq!(
        ::std::mem::align_of::<CONTROL>(),
        4usize,
        concat!("Alignment of ", stringify!(CONTROL))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CONTROL>())).Present as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CONTROL),
            "::",
            stringify!(Present)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CONTROL>())).RawData as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(CONTROL),
            "::",
            stringify!(RawData)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CONTROL>())).Plugin as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CONTROL),
            "::",
            stringify!(Plugin)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union BUTTONS {
    pub Value: ::std::os::raw::c_uint,
    pub __bindgen_anon_1: BUTTONS__bindgen_ty_1,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct BUTTONS__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_BUTTONS__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<BUTTONS__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(BUTTONS__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<BUTTONS__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(BUTTONS__bindgen_ty_1))
    );
}
impl BUTTONS__bindgen_ty_1 {
    #[inline]
    pub fn R_DPAD(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_R_DPAD(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn L_DPAD(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_L_DPAD(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn D_DPAD(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_D_DPAD(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn U_DPAD(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_U_DPAD(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn START_BUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_START_BUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Z_TRIG(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Z_TRIG(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn B_BUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_B_BUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn A_BUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_A_BUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn R_CBUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_R_CBUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn L_CBUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_L_CBUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn D_CBUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_D_CBUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn U_CBUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_U_CBUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn R_TRIG(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_R_TRIG(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn L_TRIG(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_L_TRIG(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Reserved1(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Reserved1(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Reserved2(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Reserved2(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn X_AXIS(&self) -> ::std::os::raw::c_int {
        u32::cast_signed(self._bitfield_1.get(16usize, 8u8) as u32)
    }
    #[inline]
    pub fn set_X_AXIS(&mut self, val: ::std::os::raw::c_int) {
        let val: u32 = i32::cast_unsigned(val);
        self._bitfield_1.set(16usize, 8u8, val as u64)
    }
    #[inline]
    pub fn Y_AXIS(&self) -> ::std::os::raw::c_int {
        u32::cast_signed(self._bitfield_1.get(24usize, 8u8) as u32)
    }
    #[inline]
    pub fn set_Y_AXIS(&mut self, val: ::std::os::raw::c_int) {
        let val: u32 = i32::cast_unsigned(val);
        self._bitfield_1.set(24usize, 8u8, val as u64)
    }
    #[inline]
    pub fn new_bitfield_1(
        R_DPAD: ::std::os::raw::c_uint,
        L_DPAD: ::std::os::raw::c_uint,
        D_DPAD: ::std::os::raw::c_uint,
        U_DPAD: ::std::os::raw::c_uint,
        START_BUTTON: ::std::os::raw::c_uint,
        Z_TRIG: ::std::os::raw::c_uint,
        B_BUTTON: ::std::os::raw::c_uint,
        A_BUTTON: ::std::os::raw::c_uint,
        R_CBUTTON: ::std::os::raw::c_uint,
        L_CBUTTON: ::std::os::raw::c_uint,
        D_CBUTTON: ::std::os::raw::c_uint,
        U_CBUTTON: ::std::os::raw::c_uint,
        R_TRIG: ::std::os::raw::c_uint,
        L_TRIG: ::std::os::raw::c_uint,
        Reserved1: ::std::os::raw::c_uint,
        Reserved2: ::std::os::raw::c_uint,
        X_AXIS: ::std::os::raw::c_int,
        Y_AXIS: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let R_DPAD: u32 = unsafe { ::std::mem::transmute(R_DPAD) };
            R_DPAD as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let L_DPAD: u32 = unsafe { ::std::mem::transmute(L_DPAD) };
            L_DPAD as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let D_DPAD: u32 = unsafe { ::std::mem::transmute(D_DPAD) };
            D_DPAD as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let U_DPAD: u32 = unsafe { ::std::mem::transmute(U_DPAD) };
            U_DPAD as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let START_BUTTON: u32 = unsafe { ::std::mem::transmute(START_BUTTON) };
            START_BUTTON as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let Z_TRIG: u32 = unsafe { ::std::mem::transmute(Z_TRIG) };
            Z_TRIG as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let B_BUTTON: u32 = unsafe { ::std::mem::transmute(B_BUTTON) };
            B_BUTTON as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let A_BUTTON: u32 = unsafe { ::std::mem::transmute(A_BUTTON) };
            A_BUTTON as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let R_CBUTTON: u32 = unsafe { ::std::mem::transmute(R_CBUTTON) };
            R_CBUTTON as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let L_CBUTTON: u32 = unsafe { ::std::mem::transmute(L_CBUTTON) };
            L_CBUTTON as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let D_CBUTTON: u32 = unsafe { ::std::mem::transmute(D_CBUTTON) };
            D_CBUTTON as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let U_CBUTTON: u32 = unsafe { ::std::mem::transmute(U_CBUTTON) };
            U_CBUTTON as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let R_TRIG: u32 = unsafe { ::std::mem::transmute(R_TRIG) };
            R_TRIG as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let L_TRIG: u32 = unsafe { ::std::mem::transmute(L_TRIG) };
            L_TRIG as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let Reserved1: u32 = unsafe { ::std::mem::transmute(Reserved1) };
            Reserved1 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let Reserved2: u32 = unsafe { ::std::mem::transmute(Reserved2) };
            Reserved2 as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let X_AXIS: u32 = i32::cast_unsigned(X_AXIS);
            X_AXIS as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let Y_AXIS: u32 = i32::cast_unsigned(Y_AXIS);
            Y_AXIS as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_BUTTONS() {
    assert_eq!(
        ::std::mem::size_of::<BUTTONS>(),
        4usize,
        concat!("Size of: ", stringify!(BUTTONS))
    );
    assert_eq!(
        ::std::mem::align_of::<BUTTONS>(),
        4usize,
        concat!("Alignment of ", stringify!(BUTTONS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BUTTONS>())).Value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BUTTONS),
            "::",
            stringify!(Value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CONTROL_INFO {
    pub Controls: *mut CONTROL,
}
#[test]
fn bindgen_test_layout_CONTROL_INFO() {
    assert_eq!(
        ::std::mem::size_of::<CONTROL_INFO>(),
        8usize,
        concat!("Size of: ", stringify!(CONTROL_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<CONTROL_INFO>(),
        8usize,
        concat!("Alignment of ", stringify!(CONTROL_INFO))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CONTROL_INFO>())).Controls as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CONTROL_INFO),
            "::",
            stringify!(Controls)
        )
    );
}
