/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	resourcev1 "k8s.io/api/resource/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	applyconfigurationsresourcev1 "k8s.io/client-go/applyconfigurations/resource/v1"
	gentype "k8s.io/client-go/gentype"
	scheme "k8s.io/client-go/kubernetes/scheme"
)

// ResourceClaimsGetter has a method to return a ResourceClaimInterface.
// A group's client should implement this interface.
type ResourceClaimsGetter interface {
	ResourceClaims(namespace string) ResourceClaimInterface
}

// ResourceClaimInterface has methods to work with ResourceClaim resources.
type ResourceClaimInterface interface {
	Create(ctx context.Context, resourceClaim *resourcev1.ResourceClaim, opts metav1.CreateOptions) (*resourcev1.ResourceClaim, error)
	Update(ctx context.Context, resourceClaim *resourcev1.ResourceClaim, opts metav1.UpdateOptions) (*resourcev1.ResourceClaim, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, resourceClaim *resourcev1.ResourceClaim, opts metav1.UpdateOptions) (*resourcev1.ResourceClaim, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*resourcev1.ResourceClaim, error)
	List(ctx context.Context, opts metav1.ListOptions) (*resourcev1.ResourceClaimList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *resourcev1.ResourceClaim, err error)
	Apply(ctx context.Context, resourceClaim *applyconfigurationsresourcev1.ResourceClaimApplyConfiguration, opts metav1.ApplyOptions) (result *resourcev1.ResourceClaim, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, resourceClaim *applyconfigurationsresourcev1.ResourceClaimApplyConfiguration, opts metav1.ApplyOptions) (result *resourcev1.ResourceClaim, err error)
	ResourceClaimExpansion
}

// resourceClaims implements ResourceClaimInterface
type resourceClaims struct {
	*gentype.ClientWithListAndApply[*resourcev1.ResourceClaim, *resourcev1.ResourceClaimList, *applyconfigurationsresourcev1.ResourceClaimApplyConfiguration]
}

// newResourceClaims returns a ResourceClaims
func newResourceClaims(c *ResourceV1Client, namespace string) *resourceClaims {
	return &resourceClaims{
		gentype.NewClientWithListAndApply[*resourcev1.ResourceClaim, *resourcev1.ResourceClaimList, *applyconfigurationsresourcev1.ResourceClaimApplyConfiguration](
			"resourceclaims",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *resourcev1.ResourceClaim { return &resourcev1.ResourceClaim{} },
			func() *resourcev1.ResourceClaimList { return &resourcev1.ResourceClaimList{} },
			gentype.PrefersProtobuf[*resourcev1.ResourceClaim](),
		),
	}
}
