// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package fft

import (
	"math/bits"

	"github.com/consensys/gnark-crypto/field/babybear"
	fext "github.com/consensys/gnark-crypto/field/babybear/extensions"
)

type SmallField interface {
	babybear.Element | fext.E4
}

// BitReverse applies the bit-reversal permutation to v.
// len(v) must be a power of 2
func BitReverse[T SmallField](v []T) {
	n := uint64(len(v))
	if bits.OnesCount64(n) != 1 {
		panic("len(a) must be a power of 2")
	}

	bitReverseNaive(v)
}

// bitReverseNaive applies the bit-reversal permutation to v.
// len(v) must be a power of 2
func bitReverseNaive[T SmallField](v []T) {
	n := uint64(len(v))
	nn := uint64(64 - bits.TrailingZeros64(n))

	for i := uint64(0); i < n; i++ {
		iRev := bits.Reverse64(i) >> nn
		if iRev > i {
			v[i], v[iRev] = v[iRev], v[i]
		}
	}
}
