if(DEFLATE_PREFER_STATIC_LIB)
    set(DEFLATE_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})
    if(WIN32)
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a .lib ${CMAKE_FIND_LIBRARY_SUFFIXES})
    else()
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
    endif()
endif()

if(UNIX)
    find_package(PkgConfig QUIET)
    # pkg-config support added in libdeflate v1.9
    pkg_check_modules(_DEFLATE QUIET libdeflate)
endif()

find_path(DEFLATE_INCLUDE_DIR
    NAMES libdeflate.h
    HINTS ${_DEFLATE_INCLUDEDIR})
find_library(DEFLATE_LIBRARY
    NAMES deflate
    HINTS ${_DEFLATE_LIBDIR})

set(DEFLATE_INCLUDE_DIRS ${DEFLATE_INCLUDE_DIR})
set(DEFLATE_LIBRARIES ${DEFLATE_LIBRARY})

if(_DEFLATE_VERSION)
    set(DEFLATE_VERSION ${_DEFLATE_VERSION})
elseif(DEFLATE_INCLUDE_DIR)
    file(STRINGS "${DEFLATE_INCLUDE_DIR}/libdeflate.h" DEFLATE_VERSION_STR
        REGEX "^#define[\t ]+LIBDEFLATE_VERSION_STRING[\t ]+\"[^\"]+\"")
    if(DEFLATE_VERSION_STR MATCHES "\"([^\"]+)\"")
        set(DEFLATE_VERSION "${CMAKE_MATCH_1}")
    endif()
endif()

include(FindPackageHandleStandardArgs)

find_package_handle_standard_args(DEFLATE
    REQUIRED_VARS
        DEFLATE_INCLUDE_DIR
        DEFLATE_LIBRARY
    VERSION_VAR DEFLATE_VERSION)

mark_as_advanced(DEFLATE_INCLUDE_DIR DEFLATE_LIBRARY)

if(DEFLATE_PREFER_STATIC_LIB)
    set(CMAKE_FIND_LIBRARY_SUFFIXES ${DEFLATE_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES})
    unset(DEFLATE_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES)
endif()
