/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.hql;

import java.util.HashSet;
import java.util.Set;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.hql.Parser;
import net.sf.hibernate.hql.ParserHelper;
import net.sf.hibernate.hql.PathExpressionParser;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.hql.SelectPathExpressionParser;
import net.sf.hibernate.type.Type;

public class SelectParser
implements Parser {
    private static final Set AGGREGATE_FUNCTIONS = new HashSet();
    private static final Set COUNT_MODIFIERS = new HashSet();
    private boolean ready;
    private boolean aggregate;
    private boolean count;
    private boolean avg;
    private boolean first;
    private boolean afterNew;
    private Class holderClass;
    private SelectPathExpressionParser pathExpressionParser = new SelectPathExpressionParser();
    private PathExpressionParser aggregatePathExpressionParser = new PathExpressionParser();

    public void token(String token, QueryTranslator q) throws QueryException {
        String lctoken = token.toLowerCase();
        if (this.first) {
            this.first = false;
            if (lctoken.equals("distinct")) {
                q.setDistinct(true);
                return;
            }
            if (lctoken.equals("all")) {
                q.setDistinct(false);
                return;
            }
        }
        if (this.afterNew) {
            this.afterNew = false;
            this.holderClass = q.getImportedClass(token);
            if (this.holderClass == null) {
                throw new QueryException("class not found: " + token);
            }
            q.setHolderClass(this.holderClass);
        } else if (token.equals(",")) {
            if (this.ready) {
                throw new QueryException("alias or expression expected in SELECT");
            }
            q.appendScalarSelectToken(", ");
            this.ready = true;
        } else if ("new".equals(lctoken)) {
            this.afterNew = true;
            this.ready = false;
        } else if ("(".equals(token)) {
            if (!this.aggregate && this.holderClass != null && !this.ready) {
                this.ready = true;
            } else if (this.aggregate) {
                q.appendScalarSelectToken(token);
            } else {
                throw new QueryException("aggregate function expected before ( in SELECT");
            }
            this.ready = true;
        } else if (")".equals(token)) {
            if (this.holderClass == null || this.ready) {
                if (this.aggregate && this.ready) {
                    q.appendScalarSelectToken(token);
                } else {
                    throw new QueryException("( expected before ) in select");
                }
            }
            this.count = false;
            this.aggregate = false;
            this.ready = false;
        } else if (COUNT_MODIFIERS.contains(lctoken)) {
            if (!this.ready || !this.aggregate) {
                throw new QueryException(token + " only allowed inside aggregate function in SELECT");
            }
            q.appendScalarSelectToken(token);
        } else if (AGGREGATE_FUNCTIONS.contains(lctoken)) {
            if (!this.ready) {
                throw new QueryException(", expected before aggregate function in SELECT: " + token);
            }
            if (lctoken.equals("count")) {
                q.addSelectScalar(Hibernate.INTEGER);
                this.count = true;
            } else if (lctoken.equals("avg")) {
                this.avg = true;
            }
            this.aggregate = true;
            this.ready = false;
            q.appendScalarSelectToken(token);
        } else if (this.aggregate) {
            if (!this.ready) {
                throw new QueryException("( expected after aggregate function in SELECT");
            }
            ParserHelper.parse(this.aggregatePathExpressionParser, q.unalias(token), ".", q);
            if (this.aggregatePathExpressionParser.isCollectionValued()) {
                q.addCollection(this.aggregatePathExpressionParser.getCollectionName(), this.aggregatePathExpressionParser.getCollectionRole());
            }
            q.appendScalarSelectToken(this.aggregatePathExpressionParser.getWhereColumn());
            if (!this.count) {
                q.addSelectScalar(this.aggregateType(this.aggregatePathExpressionParser.getWhereColumnType(), q));
            }
            this.aggregatePathExpressionParser.addAssociation(q);
        } else {
            if (!this.ready) {
                throw new QueryException(", expected in SELECT");
            }
            ParserHelper.parse(this.pathExpressionParser, q.unalias(token), ".", q);
            if (this.pathExpressionParser.isCollectionValued()) {
                q.addCollection(this.pathExpressionParser.getCollectionName(), this.pathExpressionParser.getCollectionRole());
            } else if (this.pathExpressionParser.getWhereColumnType().isEntityType()) {
                q.addSelectClass(this.pathExpressionParser.getSelectName());
            }
            q.appendScalarSelectTokens(this.pathExpressionParser.getWhereColumns());
            q.addSelectScalar(this.pathExpressionParser.getWhereColumnType());
            this.pathExpressionParser.addAssociation(q);
            this.ready = false;
        }
    }

    public Type aggregateType(Type type, QueryTranslator q) throws QueryException {
        if (this.count) {
            throw new AssertionFailure("count(*) must be handled differently");
        }
        if (this.avg) {
            int[] sqlTypes;
            try {
                sqlTypes = type.sqlTypes(q.getFactory());
            }
            catch (MappingException me) {
                throw new QueryException((Exception)((Object)me));
            }
            if (sqlTypes.length != 1) {
                throw new QueryException("multi-column type in avg()");
            }
            int sqlType = sqlTypes[0];
            if (sqlType == 4 || sqlType == -5 || sqlType == -6) {
                return Hibernate.FLOAT;
            }
            return type;
        }
        return type;
    }

    public void start(QueryTranslator q) {
        this.ready = true;
        this.first = true;
        this.aggregate = false;
        this.count = false;
        this.avg = false;
        this.afterNew = false;
        this.holderClass = null;
    }

    public void end(QueryTranslator q) {
    }

    static {
        AGGREGATE_FUNCTIONS.add("count");
        AGGREGATE_FUNCTIONS.add("avg");
        AGGREGATE_FUNCTIONS.add("max");
        AGGREGATE_FUNCTIONS.add("min");
        AGGREGATE_FUNCTIONS.add("sum");
        COUNT_MODIFIERS.add("distinct");
        COUNT_MODIFIERS.add("all");
        COUNT_MODIFIERS.add("*");
    }
}

