/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class InFragment {
    private String columnName;
    private Set values = new HashSet();

    public InFragment addValue(String value) {
        this.values.add(value);
        return this;
    }

    public InFragment setColumn(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public InFragment setColumn(String alias, String columnName) {
        this.columnName = alias + '.' + columnName;
        return this.setColumn(this.columnName);
    }

    public String toFragmentString() {
        StringBuffer buf = new StringBuffer(this.values.size() * 5);
        buf.append(this.columnName);
        if (this.values.size() > 1) {
            boolean allowNull = false;
            buf.append(" in (");
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                if ("null".equals(value)) {
                    allowNull = true;
                    continue;
                }
                buf.append(value);
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(")");
            if (allowNull) {
                buf.insert(0, " is null or ").insert(0, this.columnName).insert(0, "(").append(")");
            }
        } else {
            String value = (String)this.values.iterator().next();
            if ("null".equals(value)) {
                buf.append(" is null");
            } else {
                buf.append("=").append(this.values.iterator().next());
            }
        }
        return buf.toString();
    }
}

