/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.util.JDBCExceptionReporter;

public class SchemaExport {
    private String[] dropSQL;
    private String[] createSQL;
    private Properties connectionProperties;
    private String outputFile = null;
    private Dialect dialect;
    private String delimiter;

    public SchemaExport(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaExport(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.connectionProperties = connectionProperties;
        this.dialect = Dialect.getDialect(connectionProperties);
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
    }

    public SchemaExport setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    public SchemaExport setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public void create(boolean script, boolean export) throws HibernateException {
        this.execute(script, export, false, true);
    }

    public void drop(boolean script, boolean export) throws HibernateException {
        this.execute(script, export, true, true);
    }

    private void execute(boolean script, boolean export, boolean justDrop, boolean format) throws HibernateException {
        Connection connection = null;
        FileWriter fileOutput = null;
        ConnectionProvider connectionProvider = null;
        Statement statement = null;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)this.connectionProperties);
        boolean jdbc2 = false;
        try {
            if (this.outputFile != null) {
                fileOutput = new FileWriter(this.outputFile);
            }
            if (export) {
                connectionProvider = ConnectionProviderFactory.newConnectionProvider(props);
                connection = connectionProvider.getConnection();
                connection.commit();
                connection.setAutoCommit(true);
                statement = connection.createStatement();
            }
            int i = 0;
            while (i < this.dropSQL.length) {
                try {
                    String formatted = this.dropSQL[i];
                    if (this.delimiter != null) {
                        formatted = formatted + this.delimiter;
                    }
                    if (script) {
                        System.out.println(formatted);
                    }
                    if (this.outputFile != null) {
                        fileOutput.write(formatted + "\n");
                    }
                    if (export) {
                        if (jdbc2) {
                            statement.addBatch(this.dropSQL[i]);
                        } else {
                            statement.executeUpdate(this.dropSQL[i]);
                        }
                    }
                }
                catch (SQLException e) {
                    if (!script) {
                        System.out.println(this.dropSQL[i]);
                    }
                    System.out.println("Unsuccessful: " + e.getMessage());
                }
                ++i;
            }
            if (!justDrop) {
                int j = 0;
                while (j < this.createSQL.length) {
                    try {
                        String formatted;
                        String string = formatted = format ? SchemaExport.format(this.createSQL[j]) : this.createSQL[j];
                        if (this.delimiter != null) {
                            formatted = formatted + this.delimiter;
                        }
                        if (script) {
                            System.out.println(formatted);
                        }
                        if (this.outputFile != null) {
                            fileOutput.write(formatted + "\n");
                        }
                        if (export) {
                            if (jdbc2) {
                                statement.addBatch(this.createSQL[j]);
                            } else {
                                statement.executeUpdate(this.createSQL[j]);
                            }
                        }
                    }
                    catch (SQLException e) {
                        if (!script) {
                            System.out.println(this.createSQL[j]);
                        }
                        System.out.println("Unsuccessful: " + e.getMessage());
                    }
                    ++j;
                }
            }
            if (jdbc2) {
                statement.executeBatch();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HibernateException(e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    JDBCExceptionReporter.logWarnings(connection.getWarnings());
                    connection.clearWarnings();
                    connectionProvider.closeConnection(connection);
                    connectionProvider.close();
                }
            }
            catch (SQLException e) {
                System.err.println("Could not close connection: " + e.getMessage());
            }
            if (fileOutput != null) {
                try {
                    fileOutput.close();
                }
                catch (IOException ioe) {
                    System.err.println("Error closing output file " + this.outputFile + ": " + ioe.getMessage());
                }
            }
        }
    }

    private static String format(String sql) {
        String formatted;
        if (sql.indexOf("\"") > 0 || sql.indexOf("'") > 0) {
            return sql;
        }
        if (sql.toLowerCase().startsWith("create table")) {
            StringBuffer result = new StringBuffer(60);
            StringTokenizer tokens = new StringTokenizer(sql, "(,)", true);
            int depth = 0;
            while (tokens.hasMoreTokens()) {
                String tok = tokens.nextToken();
                if (")".equals(tok) && --depth == 0) {
                    result.append("\n");
                }
                result.append(tok);
                if (",".equals(tok) && depth == 1) {
                    result.append("\n  ");
                }
                if (!"(".equals(tok) || ++depth != 1) continue;
                result.append("\n   ");
            }
            formatted = result.toString();
        } else {
            formatted = sql;
        }
        return formatted;
    }

    public static void main(String[] args) {
        block23: {
            try {
                Configuration cfg = new Configuration();
                boolean script = true;
                boolean drop = false;
                boolean export = true;
                String outFile = null;
                String propFile = null;
                boolean formatSQL = false;
                String delim = null;
                int i = 0;
                while (i < args.length) {
                    if (args[i].startsWith("--")) {
                        if (args[i].equals("--quiet")) {
                            script = false;
                        } else if (args[i].equals("--drop")) {
                            drop = true;
                        } else if (args[i].equals("--text")) {
                            export = false;
                        } else if (args[i].startsWith("--output=")) {
                            outFile = args[i].substring(9);
                        } else if (args[i].startsWith("--properties=")) {
                            propFile = args[i].substring(13);
                        } else if (args[i].equals("--format")) {
                            formatSQL = true;
                        } else if (args[i].startsWith("--delimiter=")) {
                            delim = args[i].substring(12);
                        } else if (args[i].startsWith("--config=")) {
                            cfg.configure(args[i].substring(9));
                        }
                    } else {
                        String filename = args[i];
                        if (filename.endsWith(".jar")) {
                            cfg.addJar(filename);
                        } else {
                            cfg.addFile(filename);
                        }
                    }
                    ++i;
                }
                if (propFile != null) {
                    Properties props = new Properties();
                    props.load(new FileInputStream(propFile));
                    new SchemaExport(cfg, props).setOutputFile(outFile).setDelimiter(delim).execute(script, export, drop, formatSQL);
                    break block23;
                }
                new SchemaExport(cfg).setOutputFile(outFile).setDelimiter(delim).execute(script, export, drop, formatSQL);
            }
            catch (Exception e) {
                System.err.println("Error creating schema " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

