/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.type.MutableType;

public class BinaryType
extends MutableType {
    static /* synthetic */ Class array$B;

    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (Environment.useStreamsForBinary()) {
            st.setBinaryStream(index, (InputStream)new ByteArrayInputStream((byte[])value), ((byte[])value).length);
        } else {
            st.setBytes(index, (byte[])value);
        }
    }

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        if (Environment.useStreamsForBinary()) {
            InputStream inputStream = rs.getBinaryStream(name);
            if (inputStream == null) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);
            byte[] buffer = new byte[2048];
            try {
                int amountRead;
                while ((amountRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, amountRead);
                }
                inputStream.close();
                outputStream.close();
            }
            catch (IOException ioe) {
                throw new HibernateException("IOException occurred reading a binary value", ioe);
            }
            return outputStream.toByteArray();
        }
        return rs.getBytes(name);
    }

    public int sqlType() {
        return -3;
    }

    public Class getReturnedClass() {
        return array$B == null ? (array$B = BinaryType.class$("[B")) : array$B;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public String getName() {
        return "binary";
    }

    public String toXML(Object val) throws HibernateException {
        byte[] bytes = (byte[])val;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String hexStr = Integer.toHexString(bytes[i] - -128);
            if (hexStr.length() == 1) {
                buf.append('0');
            }
            buf.append(hexStr);
            ++i;
        }
        return buf.toString();
    }

    public Object deepCopyNotNull(Object value) throws HibernateException {
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

