/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ModuleFactory;
import org.dita.dost.module.XmlFilterModule;
import org.dita.dost.module.XsltModule;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.store.Store;
import org.dita.dost.store.StreamStore;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;

public final class ExtensibleAntInvoker
extends Task {
    private DITAOTAntLogger logger;
    private final ModuleFactory factory = ModuleFactory.instance();
    private final Map<String, String> attrs = new HashMap<String, String>();
    private final ArrayList<ParamElem> pipelineParams = new ArrayList();
    private final ArrayList<ModuleElem> modules = new ArrayList();
    private File tempDir;
    private Configuration.Mode processingMode;

    public void setMessage(String m) {
        this.attrs.put("message", m);
    }

    public void setInputmap(String inputmap) {
        this.attrs.put("inputmap", inputmap);
    }

    public void setTempdir(File tempdir) {
        this.tempDir = tempdir.getAbsoluteFile();
        this.attrs.put("tempDir", tempdir.getAbsolutePath());
    }

    public ParamElem createParam() {
        ParamElem p = new ParamElem();
        this.pipelineParams.add(p);
        return p;
    }

    public void addConfiguredModule(ModuleElem m) {
        this.modules.add(m);
    }

    public void addConfiguredXslt(XsltElem xslt) {
        this.modules.add(xslt);
    }

    public void addConfiguredSax(SaxPipeElem filters) {
        this.modules.add(filters);
    }

    private void initialize() throws BuildException {
        if (this.tempDir == null) {
            this.tempDir = new File(this.getProject().getProperty("dita.temp.dir"));
            if (!this.tempDir.isAbsolute()) {
                this.tempDir = new File(this.getProject().getBaseDir(), this.tempDir.getPath());
            }
        }
        if (this.modules.isEmpty()) {
            throw new BuildException("ModuleElem must be specified");
        }
        this.attrs.computeIfAbsent("basedir", k -> this.getProject().getBaseDir().getAbsolutePath());
        for (ParamElem p : this.pipelineParams) {
            if (!p.isValid()) {
                throw new BuildException("Incomplete parameter");
            }
            if (!ExtensibleAntInvoker.isValid(this.getProject(), this.getLocation(), p.getIf(), p.getUnless())) continue;
            this.attrs.put(p.getName(), p.getValue());
        }
        this.logger = new DITAOTAntLogger(this.getProject());
        this.logger.setTask(this);
        String mode = this.getProject().getUserProperty("processing-mode");
        if (mode == null) {
            mode = this.getProject().getProperty("processing-mode");
        }
        if (mode == null) {
            mode = Configuration.Mode.LAX.name();
        }
        this.processingMode = Configuration.Mode.valueOf(mode.toUpperCase());
    }

    public void execute() throws BuildException {
        this.initialize();
        Job job = ExtensibleAntInvoker.getJob(this.getProject());
        XMLUtils xmlUtils = this.getXmlUtils();
        try {
            for (ModuleElem m : this.modules) {
                String processingMode;
                m.setProject(this.getProject());
                m.setLocation(this.getLocation());
                PipelineHashIO pipelineInput = new PipelineHashIO();
                for (Map.Entry<String, String> e : this.attrs.entrySet()) {
                    pipelineInput.setAttribute(e.getKey(), e.getValue());
                }
                AbstractPipelineModule mod = this.getPipelineModule(m, pipelineInput);
                if (pipelineInput.getAttribute("processing-mode") == null && (processingMode = Objects.requireNonNullElse(this.getProject().getUserProperty("processing-mode"), this.getProject().getProperty("processing-mode"))) != null) {
                    pipelineInput.setAttribute("processing-mode", processingMode);
                }
                long start = System.currentTimeMillis();
                mod.setLogger(this.logger);
                mod.setJob(job);
                mod.setXmlUtils(xmlUtils);
                mod.execute(pipelineInput);
                long end = System.currentTimeMillis();
                this.logger.debug("{0} processing took {1} ms", (Object)mod.getClass().getSimpleName(), (Object)(end - start));
            }
        }
        catch (DITAOTException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private AbstractPipelineModule getPipelineModule(ModuleElem m, PipelineHashIO pipelineInput) throws DITAOTException {
        if (m instanceof XsltElem) {
            XsltElem xm = (XsltElem)m;
            if (xm.reloadstylesheet && xm.parallel) {
                throw new BuildException("Both reloadstylesheet and parallel cannot be true");
            }
            if (xm.parallel && xm.xmlcatalog != null) {
                throw new DITAOTException("Pipeline XSLT task with parallel=true cannot be used with Ant's xmlcatalog");
            }
            XsltModule module = new XsltModule();
            module.setStyle(this.toSource(xm.xslResource));
            if (xm.in != null) {
                module.setSource(xm.in);
                module.setResult(xm.out);
            } else if (!xm.fileInfoFilters.isEmpty()) {
                module.setFileInfoFilter(ExtensibleAntInvoker.combine(xm.fileInfoFilters));
                module.setDestinationDir(xm.destDir != null ? xm.destDir : this.tempDir);
            } else {
                Iterator<OutputPropertyElem> inc = this.readListFile(xm.includes, this.logger);
                inc.removeAll(this.readListFile(xm.excludes, this.logger));
                module.setIncludes((Collection<File>)((Object)inc));
                module.setDestinationDir(xm.destDir != null ? xm.destDir : xm.baseDir);
                module.setSorceDir(xm.baseDir);
            }
            module.setFilenameParam(xm.filenameparameter);
            module.setFiledirParam(xm.filedirparameter);
            module.setReloadstylesheet(xm.reloadstylesheet);
            module.setParallel(xm.parallel);
            module.setProcessingMode(this.processingMode);
            module.setXMLCatalog(xm.xmlcatalog);
            if (xm.mapper != null) {
                module.setMapper(xm.mapper.getImplementation());
            }
            if (xm.extension != null) {
                module.setExtension(xm.extension);
            }
            for (ParamElem p : m.params) {
                if (!p.isValid()) {
                    throw new BuildException("Incomplete parameter");
                }
                if (!ExtensibleAntInvoker.isValid(this.getProject(), this.getLocation(), p.getIf(), p.getUnless())) continue;
                module.setParam(p.getName(), p.getValue());
            }
            for (OutputPropertyElem o : ((XsltElem)m).outputProperties) {
                if (!o.isValid()) {
                    throw new BuildException("Incomplete outputproperty");
                }
                module.setOutputProperty(o.name, o.value);
            }
            return module;
        }
        if (m instanceof SaxPipeElem) {
            SaxPipeElem fm = (SaxPipeElem)m;
            XmlFilterModule module = new XmlFilterModule();
            module.setParallel(fm.parallel);
            module.setProcessingMode(this.processingMode);
            ArrayList<FileInfoFilterElem> predicates = new ArrayList<FileInfoFilterElem>(fm.getFormat());
            predicates.addAll(m.fileInfoFilters);
            module.setFileInfoFilter(ExtensibleAntInvoker.combine(predicates));
            module.setProcessingPipe(fm.getFilters());
            return module;
        }
        for (ParamElem p : m.params) {
            if (!p.isValid()) {
                throw new BuildException("Incomplete parameter");
            }
            if (!ExtensibleAntInvoker.isValid(this.getProject(), this.getLocation(), p.getIf(), p.getUnless())) continue;
            pipelineInput.setAttribute(p.getName(), p.getValue());
        }
        AbstractPipelineModule module = this.factory.createModule(m.getImplementation());
        module.setProcessingPipe(m.getFilters());
        if (!m.fileInfoFilters.isEmpty()) {
            module.setFileInfoFilter(ExtensibleAntInvoker.combine(m.fileInfoFilters));
        }
        module.setParallel(m.parallel);
        module.setProcessingMode(this.processingMode);
        return module;
    }

    private Source toSource(Resource style) {
        if (style instanceof FileResource) {
            return new StreamSource(((FileResource)style).getFile());
        }
        throw new BuildException(String.format("%s not supported", style.getClass().toString()));
    }

    private static Predicate<Job.FileInfo> combine(Collection<FileInfoFilterElem> filters) {
        if (filters.isEmpty()) {
            return f -> true;
        }
        List<Predicate> res = filters.stream().map(FileInfoFilterElem::toFilter).toList();
        return f -> {
            for (Predicate filter : res) {
                if (!filter.test(f)) continue;
                return true;
            }
            return false;
        };
    }

    public static Job getJob(Project project) {
        File tempDir = URLUtils.toFile(project.getUserProperty("dita.temp.dir"));
        if (tempDir == null) {
            tempDir = URLUtils.toFile(project.getProperty("dita.temp.dir"));
        }
        if (tempDir == null) {
            throw new IllegalStateException(String.format("Ant property %s not set", "dita.temp.dir"));
        }
        Job job = (Job)project.getReference("job");
        if (job != null) {
            if (job.isStale()) {
                project.log("Reload stale job configuration reference", 0);
                try {
                    job = new Job(tempDir, job.getStore());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
                project.addReference("job", (Object)job);
            }
        } else {
            Store store;
            XMLUtils xmlUtils = (XMLUtils)project.getReference("xmlutils");
            if (xmlUtils == null) {
                project.log("XML utils not found from Ant project reference", 0);
                xmlUtils = new XMLUtils();
                xmlUtils.setLogger(new DITAOTAntLogger(project));
            }
            if ((store = (Store)project.getReference("store")) == null) {
                project.log("Store not found from Ant project reference", 0);
                store = new StreamStore(tempDir, xmlUtils);
            }
            project.log("Job not found from Ant project reference", 3);
            try {
                job = new Job(tempDir, store);
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe);
            }
            project.addReference("job", (Object)job);
        }
        return job;
    }

    @Deprecated
    public static Job getJob(File tempDir, Project project) {
        return ExtensibleAntInvoker.getJob(project);
    }

    public XMLUtils getXmlUtils() {
        XMLUtils xmlUtils = (XMLUtils)this.getProject().getReference("xmlutils");
        if (xmlUtils == null) {
            xmlUtils = new XMLUtils();
            xmlUtils.setLogger(this.logger);
            this.getProject().addReference("xmlutils", (Object)xmlUtils);
        }
        return xmlUtils;
    }

    private Set<File> readListFile(List<IncludesFileElem> includes, DITAOTAntLogger logger) {
        HashSet<File> inc = new HashSet<File>();
        for (IncludesFileElem i : includes) {
            if (!ExtensibleAntInvoker.isValid(this.getProject(), this.getLocation(), i.ifProperty, null)) continue;
            try {
                BufferedReader r = Files.newBufferedReader(i.file.toPath());
                try {
                    String l = r.readLine();
                    while (l != null) {
                        inc.add(new File(l));
                        l = r.readLine();
                    }
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
            catch (IOException e) {
                logger.error("Failed to read includes file " + String.valueOf(i.file) + ": " + e.getMessage(), e);
            }
        }
        return inc;
    }

    public static boolean isValid(Project project, Location location, String ifProperty, String unlessProperty) {
        String msg;
        if (ifProperty != null) {
            msg = MessageUtils.getMessage("DOTA014W", "if", "if:set").setLocation(location).toString();
            project.log(msg, 1);
        }
        if (unlessProperty != null) {
            msg = MessageUtils.getMessage("DOTA014W", "unless", "unless:set").setLocation(location).toString();
            project.log(msg, 1);
        }
        return !(ifProperty != null && !project.getProperties().containsKey(ifProperty) || unlessProperty != null && project.getProperties().containsKey(unlessProperty));
    }

    public static class ParamElem
    extends ConfElem {
        private String name;
        private String value;
        private final List<ResourceCollection> rcs = new ArrayList<ResourceCollection>();

        public String getName() {
            return this.name;
        }

        public boolean isValid() {
            return this.name != null && (this.value != null || !this.rcs.isEmpty());
        }

        public void setName(String s) {
            this.name = s;
        }

        public String getValue() {
            if (!this.rcs.isEmpty()) {
                return this.rcs.stream().flatMap(ResourceCollection::stream).map(ParamElem::resourceToString).collect(Collectors.joining(File.pathSeparator));
            }
            return this.value;
        }

        private static String resourceToString(Resource r) {
            if (r instanceof FileResource) {
                return ((FileResource)r).getFile().getAbsolutePath();
            }
            throw new BuildException(String.format("%s not supported as param value", r.getClass()));
        }

        public void setExpression(String v) {
            this.value = v;
        }

        public void setValue(String v) {
            this.value = v;
        }

        public void setLocation(File v) {
            this.value = v.getPath();
        }

        public void add(ResourceCollection res) {
            this.rcs.add(res);
        }
    }

    public static class ModuleElem {
        public final List<XmlFilterElem> filters = new ArrayList<XmlFilterElem>();
        public final List<ParamElem> params = new ArrayList<ParamElem>();
        private Class<? extends AbstractPipelineModule> cls;
        public final Collection<FileInfoFilterElem> fileInfoFilters = new ArrayList<FileInfoFilterElem>();
        private Project project;
        private Location location;
        protected boolean parallel;

        public void setClass(Class<? extends AbstractPipelineModule> cls) {
            this.cls = cls;
        }

        public void addConfiguredParam(ParamElem p) {
            this.params.add(p);
        }

        public void addConfiguredDitaFileset(FileInfoFilterElem fileInfoFilter) {
            this.fileInfoFilters.add(fileInfoFilter);
        }

        public void addConfiguredFilter(XmlFilterElem filter) {
            this.filters.add(filter);
        }

        public List<XmlFilterModule.FilterPair> getFilters() {
            return this.filters.stream().filter(f -> ExtensibleAntInvoker.isValid(this.getProject(), this.getLocation(), f.getIf(), f.getUnless())).map(f -> {
                Map<String, String> params = f.params.stream().filter(p -> {
                    if (!p.isValid()) {
                        throw new IllegalArgumentException(new BuildException("Incomplete parameter"));
                    }
                    return ExtensibleAntInvoker.isValid(this.getProject(), this.getLocation(), p.getIf(), p.getUnless());
                }).collect(Collectors.toMap(ParamElem::getName, ParamElem::getValue));
                ArrayList<FileInfoFilterElem> predicates = new ArrayList<FileInfoFilterElem>(f.fileInfoFilters);
                Predicate<Job.FileInfo> fs = ExtensibleAntInvoker.combine(predicates);
                return new XmlFilterModule.FilterPair(f.getImplementation(), fs, params);
            }).collect(Collectors.toList());
        }

        public Class<? extends AbstractPipelineModule> getImplementation() {
            return this.cls;
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public Project getProject() {
            return this.project;
        }

        public void setLocation(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public void setParallel(boolean parallel) {
            this.parallel = parallel;
        }
    }

    public static class XsltElem
    extends ModuleElem {
        private File baseDir;
        private File destDir;
        private File in;
        private File out;
        private final List<IncludesFileElem> includes = new ArrayList<IncludesFileElem>();
        private final List<IncludesFileElem> excludes = new ArrayList<IncludesFileElem>();
        private final List<OutputPropertyElem> outputProperties = new ArrayList<OutputPropertyElem>();
        private Mapper mapper;
        private String extension;
        private String filenameparameter;
        private String filedirparameter;
        private XMLCatalog xmlcatalog;
        private boolean reloadstylesheet;
        private boolean parallel;
        private Resource xslResource;

        public void setStyle(File style) {
            FileResource fr = new FileResource();
            fr.setProject(this.getProject());
            fr.setFile(style);
            this.xslResource = fr;
        }

        public void setBasedir(File baseDir) {
            this.baseDir = baseDir;
        }

        public void setDestdir(File destDir) {
            this.destDir = destDir;
        }

        public void setTaskname(String taskname) {
        }

        public void setClasspathref(String classpath) {
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public void setReloadstylesheet(boolean reloadstylesheet) {
            this.reloadstylesheet = reloadstylesheet;
        }

        @Override
        public void setParallel(boolean parallel) {
            this.parallel = parallel;
        }

        public void setIn(File in) {
            this.in = in;
        }

        public void setOut(File out) {
            this.out = out;
        }

        public void setIncludesfile(File includesfile) {
            IncludesFileElem i = new IncludesFileElem();
            i.setName(includesfile);
            this.includes.add(i);
        }

        public void setExcludesfile(File excludesfile) {
            IncludesFileElem i = new IncludesFileElem();
            i.setName(excludesfile);
            this.excludes.add(i);
        }

        public void setFilenameparameter(String filenameparameter) {
            this.filenameparameter = filenameparameter;
        }

        public void setFiledirparameter(String filedirparameter) {
            this.filedirparameter = filedirparameter;
        }

        public void addConfiguredStyle(Resources rc) {
            if (rc.size() != 1) {
                throw new BuildException("The style element must be specified with exactly one nested resource.");
            }
            this.xslResource = (Resource)rc.iterator().next();
        }

        public void addConfiguredXmlcatalog(XMLCatalog xmlcatalog) {
            this.xmlcatalog = xmlcatalog;
        }

        public void addConfiguredMapper(Mapper mapper) {
            if (this.mapper != null) {
                throw new BuildException("Cannot define more than one mapper");
            }
            this.mapper = mapper;
        }

        public void addConfiguredIncludesFile(IncludesFileElem includesFile) {
            this.includes.add(includesFile);
        }

        public void addConfiguredExcludesFile(IncludesFileElem excludesFile) {
            this.excludes.add(excludesFile);
        }

        public void addOutputProperty(OutputPropertyElem outputProperty) {
            this.outputProperties.add(outputProperty);
        }
    }

    public static class OutputPropertyElem
    extends ConfElem {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isValid() {
            return this.name != null && this.value != null;
        }
    }

    public static class SaxPipeElem
    extends ModuleElem {
        private List<String> format;

        public void setFormat(String format) {
            this.format = Collections.singletonList(format);
        }

        @Override
        public List<XmlFilterModule.FilterPair> getFilters() {
            return this.filters.stream().filter(f -> ExtensibleAntInvoker.isValid(this.getProject(), this.getLocation(), f.getIf(), f.getUnless())).map(f -> {
                Map<String, String> params = f.params.stream().filter(p -> {
                    if (!p.isValid()) {
                        throw new IllegalArgumentException(new BuildException("Incomplete parameter"));
                    }
                    return ExtensibleAntInvoker.isValid(this.getProject(), this.getLocation(), p.getIf(), p.getUnless());
                }).collect(Collectors.toMap(ParamElem::getName, ParamElem::getValue));
                ArrayList<FileInfoFilterElem> predicates = new ArrayList<FileInfoFilterElem>(f.fileInfoFilters);
                predicates.addAll(this.getFormat());
                assert (!predicates.isEmpty());
                Predicate<Job.FileInfo> fs = ExtensibleAntInvoker.combine(predicates);
                return new XmlFilterModule.FilterPair(f.getImplementation(), fs, params);
            }).collect(Collectors.toList());
        }

        public List<FileInfoFilterElem> getFormat() {
            return (this.format != null ? this.format : Arrays.asList("dita", "ditamap")).stream().map(f -> {
                FileInfoFilterElem ff = new FileInfoFilterElem();
                ff.setFormat((String)f);
                return ff;
            }).collect(Collectors.toList());
        }
    }

    public static class IncludesFileElem
    extends ConfElem {
        private File file;

        public void setName(File file) {
            this.file = file;
        }
    }

    @Deprecated
    public static abstract class ConfElem {
        String ifProperty;
        String unlessProperty;

        public String getIf() {
            return this.ifProperty;
        }

        public void setIf(String p) {
            this.ifProperty = p;
        }

        public String getUnless() {
            return this.unlessProperty;
        }

        public void setUnless(String p) {
            this.unlessProperty = p;
        }
    }

    public static class XmlFilterElem
    extends ConfElem {
        public final List<FileInfoFilterElem> fileInfoFilters = new ArrayList<FileInfoFilterElem>();
        public final List<ParamElem> params = new ArrayList<ParamElem>();
        private Class<? extends AbstractXMLFilter> cls;

        public void setClass(Class<? extends AbstractXMLFilter> cls) {
            this.cls = cls;
        }

        public void addConfiguredParam(ParamElem p) {
            this.params.add(p);
        }

        public void addConfiguredDitaFileset(FileInfoFilterElem fileInfoFilter) {
            this.fileInfoFilters.add(fileInfoFilter);
        }

        public Class<? extends AbstractXMLFilter> getImplementation() {
            if (this.cls == null) {
                throw new IllegalArgumentException("class not defined");
            }
            return this.cls;
        }
    }

    public static class FileInfoFilterElem
    extends ConfElem {
        private Set<String> formats = Collections.emptySet();
        private Boolean hasConref;
        private Boolean isInput;
        private Boolean isInputResource;
        private Boolean isResourceOnly;

        public void setFormat(String format) {
            HashSet<String> builder = new HashSet<String>();
            builder.add(format);
            if (format.equals("image")) {
                FileUtils.supportedImageExtensions.stream().map(ext -> ext.substring(1)).forEach(builder::add);
            }
            this.formats = Collections.unmodifiableSet(builder);
        }

        public void setConref(boolean conref) {
            this.hasConref = conref;
        }

        public void setInput(boolean isInput) {
            this.isInput = isInput;
        }

        public void setInputResource(boolean isInputResource) {
            this.isInputResource = isInputResource;
        }

        public void setProcessingRole(String processingRole) {
            this.isResourceOnly = processingRole.equals("resource-only");
        }

        public Predicate<Job.FileInfo> toFilter() {
            return f -> !(!this.formats.isEmpty() && !this.formats.contains(f.format != null ? f.format : "dita") || this.hasConref != null && f.hasConref != this.hasConref || this.isInput != null && f.isInput != this.isInput || this.isInputResource != null && f.isInputResource != this.isInputResource || this.isResourceOnly != null && f.isResourceOnly != this.isResourceOnly);
        }
    }

    public static class StyleElem
    extends ConfElem {
        private final List<FileSet> filesets = new ArrayList<FileSet>();

        public void addFileset(FileSet fileset) {
            this.filesets.add(fileset);
        }
    }
}

