/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.stream;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.AbstractTextPanelEditor;
import org.jkiss.dbeaver.ui.editors.xml.XMLEditor;
import org.jkiss.utils.CommonUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLPanelEditor
extends AbstractTextPanelEditor<XMLEditor> {
    protected XMLEditor createEditorParty(IValueController valueController) {
        return new XMLEditor(this){

            public void init(IEditorSite site, IEditorInput input) throws PartInitException {
                this.setSite((IWorkbenchPartSite)site);
                try {
                    this.doSetInput(input);
                }
                catch (CoreException e) {
                    throw new PartInitException("Error initializing panel XML editor", (Throwable)e);
                }
            }
        };
    }

    protected String getFileFolderName() {
        return "dbeaver-xml";
    }

    protected String getFileExtension() {
        return ".xml";
    }

    public boolean supportMinify() {
        return true;
    }

    public String minify(String value) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(value)));
            XMLPanelEditor.removeWhitespaceNodes(document.getDocumentElement());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "no");
            if (!value.contains("<?xml")) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            String resultString = writer.toString();
            if (CommonUtils.isEmpty((String)resultString)) {
                return value;
            }
            return resultString;
        }
        catch (Throwable e) {
            return value;
        }
    }

    private static void removeWhitespaceNodes(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = childNodes.getLength() - 1; i >= 0; --i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 3) {
                if (!child.getNodeValue().isBlank()) continue;
                node.removeChild(child);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            XMLPanelEditor.removeWhitespaceNodes(child);
        }
    }
}

