/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.pkcs.PKCS8Key;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAUtil;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class RSAPrivateKeyImpl
extends PKCS8Key
implements RSAPrivateKey {
    private static final long serialVersionUID = -33106691987952810L;
    private final BigInteger n;
    private final BigInteger d;
    private final AlgorithmParameterSpec keyParams;

    RSAPrivateKeyImpl(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        RSAKeyFactory.checkRSAProviderKeyLengths(bigInteger.bitLength(), null);
        this.n = bigInteger;
        this.d = bigInteger2;
        this.keyParams = RSAUtil.getParamSpec(algorithmId);
        this.algid = algorithmId;
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(bigInteger2);
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(0);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.d;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    public String toString() {
        return "Sun " + this.getAlgorithm() + " private key, " + this.n.bitLength() + " bits\n  params: " + this.keyParams + "\n  modulus: " + this.n + "\n  private exponent: " + this.d;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("RSAPrivateKeyImpl keys are not directly deserializable");
    }
}

