# 0.77.1 release notes

**Release date:** 2021-08-28

## How to upgrade

Download and launch the latest version:

<div class="compact" markdown>

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

At the`Z:\>` prompt, run `config -wc` to write the new configuration file. Any
existing settings will be retained, however, extraneous comments will be
dropped.


## Bugfixes

The following user-visible bugs were fixed in 0.77.1 *(reported-by; fixed-by)*:

- Fix crash when using 32-bit build and the dynamic-core on Windows 10
  *(Banjo-Oz; kklobe)*.

- Fix crash when using 32-bit build and the dynamic-core on Raspbian *(nemo93;
  kklobe)*.

- Fix degraded joystick control during once-a-month integer time-rollover
  event *(cimarronm)*.

- Fix inability for a program to use its own bundled `HELP` and `CHOICE`
  executables *(SmilingSpectre; Wengier)*.

- Fix inability to map joystick events when joysticktype was configured as
  `none` *(GranMinigun; kcgen)*.

- Fix incorrect setup of the joystick when type configured as `2axis` *(choum;
  kcgen)*.

- Fix input control lag on some Windows systems and on macOS when the "Magnet"
  GUI management program is running *(Burrito78; kcgen)*.

- Fix mouse control in **Alive -- Behind the Moon** *(DOSBox SVN
  r4461/ripsaw8080)*.

- Fix performance regression when building releases on arm-based Linux SBC
  *(mrfixit2001)*.

- Fix potential Tseng ET3000 video mode corruption *(DOSBox SVN r4460;
  ripsaw8080)*.

- Fix resizing of window impacting the debugger TUI on Windows *(DOSBox SVN
  r4462; ripsaw8080)*.

- Fix potential crash when quickly ++alt+tab++ing on Windows *(kklobe)*.

- Fix size and placement of video content when using a resizeable window mode
  *(bmunger; kcgen)*.

- Fix unformattable content in translation files *(dreamer; kcgen)*.
- Synchronize Italian translation files *(Kappa971)*.
- Synchronize German translation files *(Burrito78)*.
- Generate macOS Universal Binary supporting x86_64 and arm64 *(Kirk Klobe*)


## Translations pack included

French, German, Italian, Polish, Russian, and Spanish users: move the bundled
`translations` directory into your DOSBox Staging configuration directory.

!!! tip "macOS users"

    Right click the dosbox-staging.app file and select "Show Package
    Contents". The `translations` folder is inside `Contents/resources/`.

After the move, you will have:

<div class="compact" markdown>

| <!-- --> | <!-- --> |
|----------|----------|
| Linux    | `/home/username/.config/dosbox/translations/` |
| macOS    | `~/Library/Preferences/DOSBox/translations/` |
| Windows  | `C:\Users\<username>\AppData\Local\DOSBox\translations\` |

</div>

Load your language on the command-line:

``` shell
dosbox -lang de
dosbox -lang es
dosbox -lang fr
dosbox -lang it
dosbox -lang pl
dosbox -lang ru
```

Or via primary or local config file:


``` ini
[dosbox]
language = de
# de, es, fr, it, pl, ru
```

!!! tip

    Use `dosbox -editconf` to open your config file.

For future reference, the above is also discussed in the README.


## Thank you

We are extremely grateful for all contributions, including the invaluable
improvements merged in from the DOSBox Team and the DOSBox-X Team.

DOSBox Staging maintains original authorship on all commits to ensure
attribution is recorded in the version control system (git).

