.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
hopffibration \- Draws the Hopf fibration of the 4d hypersphere
.SH SYNOPSIS
.B hopffibration
[\-\-display \fIhost:display.screen\fP]
[\-\-install]
[\-\-visual \fIvisual\fP]
[\-\-window]
[\-\-root]
[\-\-window\-id \fInumber\fP]
[\-\-delay \fIusecs\fP]
[\-\-fps]
[\-\-shadows]
[\-\-details coarse | medium | fine]
[\-\-base-space]
[\-\-anti-aliasing]
[\-\-perspective]
[\-\-orthographic]
.SH DESCRIPTION
The \fIhopffibration\fP program shows the Hopf fibration of the 4d
hypersphere.  The Hopf fibration is based on the Hopf map, a
many-to-one continuous function from the 4d hypersphere (the 3-sphere)
onto the the ordinary 3d sphere (the 2-sphere) such that each distinct
point of the 2-sphere is mapped from a distinct great circle (a
1-sphere) of the 3-sphere.  Hence, the inverse image of a point on the
2-sphere corresponds to a great circle on the 3-sphere.  The 2-sphere
is called the base space, each circle corresponding to a point on the
2-sphere is called a fiber, and the 3-sphere is called the total
space.
.PP
The program displays the base space (the 2-sphere) as a
semi-transparent gray sphere in the bottom right corner of the
display.  The points on the base space are displayed as small colored
spheres.  The fibers in the total space are displayed in the same
color as the corresponding points on the base space.
.PP
The fibers in the total space are projected from 4d to 3d using
stereographic projection and then compressing the infinite 3d space to
a finite 3d ball to display the fibers compactly.  All fibers except
one fiber that passes through the north pole of the 3-sphere are thus
projected to deformed circles in 3d.  The program displays these
deformed circles as closed tubes (topological tori).  The single fiber
that passes through the north pole of the 3-sphere is projected to an
infinite line by the stereographic projection.  This line passes
through infinity in 3d and therefore topologically is a circle.
Compressing this infinite line to a finite ball maps it to a straight
line segment.  The program displays this line segment as a cylinder.
However, it should be thought of as a circle through infinity.
.PP
The fibers, base space, and base points are then projected to the
screen either perspectively or orthographically.
.PP
The program displays various interesting configurations of base points
and fibers.  Look out for the following configurations:
.nr PI 2n
.IP \[bu]
Any two fibers form a Hopf link.
.IP \[bu]
More generally, each fiber is linked with each other fiber exactly
once.
.IP \[bu]
Each circle on the 2-sphere creates a set of fibers that forms a
Clifford torus on the 3-sphere (i.e., in 4d).  Clifford tori are flat
(in the same sense that the surface of a cylinder is flat).
.IP \[bu]
If a circle on the 2-sphere is not a circle of latitude, the
projection of the Clifford torus to 3d results in a (compressed) Dupin
cyclide.
.IP \[bu]
More generally, any closed curve on the 2-sphere creates a torus-like
surface on the 3-sphere that is flat.  These surfaces are called Hopf
tori or Bianchi-Pinkall flat tori.  Look for the wave-like curve on
the 2-sphere to see a Hopf torus.
.IP \[bu]
A circular arc on the 2-sphere creates a Hopf band on the 3-sphere.
The Hopf band is a Seifert surface of the Hopf link that forms the
boundaries of the Hopf band.
.IP \[bu]
Two or more circles of latitude on the 2-sphere create two or more
nested Clifford tori on the 3-sphere.
.IP \[bu]
More generally, two or more disjoint circles on the 2-sphere create
two or more linked Clifford tori on the 3-sphere.
.IP \[bu]
A great circle through the north pole of the 2-sphere creates a
parabolic ring cyclide (which is compressed to lie within the ball in
the 3d projection).  A parabolic ring cyclide divides the entire 3d
space into two congruent parts that are interlocked, i.e., linked.
.IP \[bu]
By turning a circle on the 2-sphere so that it passes through the
north pole of the 2-sphere, the projection of the corresponding
Clifford torus reverses its inside and outside in 3d.
.IP \[bu]
The Clifford torus corresponding to a great circle on the 2-sphere
divides the 3-sphere into two congruent solid tori that fill the
entire 3-sphere.  The two solid tori on the 3-sphere correspond to the
two hemispheres into which the great circle divides the 2-sphere.  The
solid tori in the 3-sphere are attached to each other at the Clifford
torus.  The congruence of the solid tori is visible in a particularly
striking manner if the great circle that creates the Clifford torus is
rotated so that it passes through the north pole of the 2-sphere,
thereby creating a parabolic ring cyclide via the projection of the
Clifford torus to 3d (see above).
.PP
During the animations, two kinds of motions are used.  Usually, the
points on the base space are moved or rotated to particular
configurations.  This is apparent by the small spheres that represent
the base points changing their position on the base space, which leads
to a corresponding change of the configuration of the fibers.  The
base space itself, however, is not moved or rotated, i.e., its
orientation remains fixed.  Sometimes, only the projection of the
fibers is rotated in 3d to show some interesting configurations more
clearly, e.g., that a Hopf torus has a hole like a regular torus.  In
this case, the base space also maintains its orientation in space.
Since a rotation in 3d does not change the configuration of the
fibers, in this kind of animation, the points on the base space also
remain fixed.  Sometimes, both types of animations are combined, e.g.,
when the projection of one or more Clifford tori is rotated in 3d
while the base points of the Clifford tori also rotate on the base
space.  In this case, the base space will only show the movement of
the base points on the base space and not the 3d rotation of the
projection of the fibers.
.PP
To enhance the 3d depth impression, the program displays the shadows
of the fibers and base points by default.  This is done by way of a
two-pass rendering algorithm in which the geometry is rendered twice.
Depending on the speed of the GPU, displaying shadows might slow down
the rendering significantly.  If this is the case, the rendering of
shadows can be switched off, saving one render pass and thus speeding
up the rendering.
.PP
Some of the animations render complex geometries with a very large
number of polygons. This can cause the rendering to become slow on
some types of GPU.  To speed up the rendering process, the amount of
details that are rendered can be controlled in three granularities
(coarse, medium, and fine).  Devices with relatively small screens and
relatively low-powered GPUs, such as phones or tablets, should
typically select coarse details.  Standard GPUs should select medium
details (the default).  High-powered GPUs on large screens may benefit
from fine details.
.PP
By default, the base space and base points are displayed as described
above.  If desired, the display of the base space and base points can
be switched off so that only the fibers are displayed.
.PP
During the animation of the Hopf fibration, sometimes multiple fibers
that are very close to each other are displayed.  This can create
disturbing aliasing artifacts that are especially noticeable when the
fibers are moving or turning slowly.  Therefore, by default, the
rendering is performed using anti-aliasing.  This typically has a
negligible effect on the rendering speed.  However, if shadows have
already been switched off, coarse details have been selected, and the
rendering is still slow, anti-aliasing also can be switched off to
check whether it has a noticeable effect on the rendering speed.
.PP
This program was inspired by Niles Johnson's visualization of the Hopf
fibration (https://nilesjohnson.net/hopf.html).
.SH OPTIONS
.I hopffibration
accepts the following options:
.TP 8
.B \-\-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-\-root
Draw on the root window.
.TP 8
.B \-\-window\-id \fInumber\fP
Draw on the specified window.
.TP 8
.B \-\-install
Install a private colormap for the window.
.TP 8
.B \-\-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual
class, or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-\-delay \fImicroseconds\fP
How much of a delay should be introduced between steps of the
animation.  Default 20000, or 1/50th second.
.PP
The following options determine whether shadows are displayed.
.TP 8
.B \-\-shadows
Display the fibers, base space, and base points with shadows
(default).
.TP 8
.B \-\-no-shadows
Display the fibers, base space, and base points without shadows.
.PP
The following three options are mutually exclusive.  They determine
with what level of detail the fibers, base space, and base points are
rendered.
.TP 8
.B \-\-details coarse
Render the fibers, base space, and base points with a level of detail
that is suitable for low-powered GPUs and small screens, e.g., phones
or tablets.
.TP 8
.B \-\-details medium
Render the fibers, base space, and base points with a level of detail
that is suitable for regular GPUs (default).
.TP 8
.B \-\-details fine
Render the fibers, base space, and base points with a level of detail
that is suitable for high-powered GPUs and large screens.
.PP
The following options determine whether the base space and base points
are displayed.
.TP 8
.B \-\-base-space
Display the base space and base points (default).
.TP 8
.B \-\-no-base-space
Do not display the base space and base points.
.PP
The following options determine whether anti-aliasing is used to
display the fibers, base space, and base points.
.TP 8
.B \-\-anti-aliasing
Display the fibers, base space, and base points with anti-aliasing
(default).
.TP 8
.B \-\-no-anti-aliasing
Display the fibers, base space, and base points without anti-aliasing.
.PP
The following two options are mutually exclusive.  They determine how
the fibers, base space, and base points are projected from 3d to 2d
(i.e., to the screen).
.TP 8
.B \-\-perspective
Project the fibers, base space, and base points from 3d to 2d using a
perspective projection (default).
.TP 8
.B \-\-orthographic
Project the fibers, base space, and base points from 3d to 2d using a
orthographic projection.
.TP 8
.B \-\-fps
Display the current frame rate, CPU load, and polygon count.
.SH INTERACTION
If you run this program in standalone mode, you can rotate the fibers
by dragging the mouse while pressing the left mouse button.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B XSCREENSAVER_WINDOW
The window ID to use with \fI\-\-root\fP.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR hypertorus (1)
.SH FURTHER INFORMATION
.nr PI 2n
.IP \[bu]
https://en.wikipedia.org/wiki/Hopf_fibration
.IP \[bu]
https://en.wikipedia.org/wiki/Hopf_link
.IP \[bu]
https://en.wikipedia.org/wiki/Clifford_torus
.IP \[bu]
https://en.wikipedia.org/wiki/Seifert_surface
.IP \[bu]
https://en.wikipedia.org/wiki/Dupin_cyclide
.IP \[bu]
https://en.wikipedia.org/wiki/3-sphere
.SH COPYRIGHT
Copyright \(co 2025 by Carsten Steger.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Carsten Steger <carsten@mirsanmir.org>, 06-feb-2025.
