/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Hash;
import java.util.NoSuchElementException;

final class StrippedLongSet {
    public transient long[] keys;
    private transient int mask;
    private transient boolean containsNull;
    private transient int n;
    private transient int maxFill;
    private int size;
    private final float loadFactor;

    StrippedLongSet(int expected, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be non-negative");
        }
        this.loadFactor = loadFactor;
        this.n = Hash.arraySize((int)expected, (float)loadFactor);
        this.mask = this.n - 1;
        this.maxFill = Hash.maxFill((int)this.n, (float)loadFactor);
        this.keys = new long[this.n + 1];
    }

    StrippedLongSet() {
        this(16, 0.5f);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public boolean hasNull() {
        return this.containsNull;
    }

    public boolean add(long k2) {
        if (k2 == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            long[] key = this.keys;
            int pos = (int)k2 & this.mask;
            long curr = key[pos];
            if (curr != 0L) {
                if (curr == k2) {
                    return false;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0L) {
                    if (curr != k2) continue;
                    return false;
                }
            }
            key[pos] = k2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(Hash.arraySize((int)(this.size + 1), (float)this.loadFactor));
        }
        return true;
    }

    public int size() {
        return this.size;
    }

    public SetIterator iterator() {
        return new SetIterator();
    }

    private void rehash(int newN) {
        long[] key = this.keys;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        int i2 = this.n;
        int j2 = this.realSize();
        while (j2-- != 0) {
            while (key[--i2] == 0L) {
            }
            int pos = (int)key[i2] & mask;
            if (newKey[pos] != 0L) {
                while (newKey[pos = pos + 1 & mask] != 0L) {
                }
            }
            newKey[pos] = key[i2];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = Hash.maxFill((int)this.n, (float)this.loadFactor);
        this.keys = newKey;
    }

    public long[] toArray() {
        long[] result2 = new long[this.size];
        SetIterator iterator2 = this.iterator();
        int i2 = 0;
        while (iterator2.hasNext()) {
            result2[i2++] = iterator2.nextLong();
        }
        return result2;
    }

    final class SetIterator {
        int pos;
        int c;
        boolean mustReturnNull;

        SetIterator() {
            this.pos = StrippedLongSet.this.n;
            this.c = StrippedLongSet.this.size;
            this.mustReturnNull = StrippedLongSet.this.containsNull;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public long nextLong() {
            long v2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                return StrippedLongSet.this.keys[StrippedLongSet.this.n];
            }
            long[] key = StrippedLongSet.this.keys;
            while ((v2 = key[--this.pos]) == 0L) {
            }
            return v2;
        }
    }
}

