/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.internal.KotlinBuildToolsInternalJdkUtils;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0007\u001a\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"MINIMAL_SUPPORTED_JDK_VERSION", "", "getJavaMajorVersion", "getJdkClassesClassLoader", "Ljava/lang/ClassLoader;", "isLegacyJavaVersion", "", "versionParts", "", "", "kotlin-build-tools-jdk-utils"})
public final class ClassLoaderUtilsKt {
    private static final boolean isLegacyJavaVersion(List<String> versionParts) {
        return Intrinsics.areEqual("1", versionParts.get(0)) && versionParts.size() > 1;
    }

    private static final int getJavaMajorVersion() {
        int n2;
        try {
            String string = System.getProperty("java.version");
            Intrinsics.checkNotNullExpressionValue(string, "getProperty(\"java.version\")");
            String[] stringArray = new String[]{"."};
            List versionParts = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
            n2 = ClassLoaderUtilsKt.isLegacyJavaVersion(versionParts) ? Integer.parseInt((String)versionParts.get(1)) : Integer.parseInt((String)versionParts.get(0));
        }
        catch (Exception e2) {
            n2 = 8;
        }
        return n2;
    }

    @KotlinBuildToolsInternalJdkUtils
    @Nullable
    public static final ClassLoader getJdkClassesClassLoader() {
        return ClassLoaderUtilsKt.getJavaMajorVersion() > 8 ? ClassLoader.getPlatformClassLoader() : null;
    }
}

