/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorByIdSignatureFinderImpl;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKind;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerDesc;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.KotlinAbiVersion;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsLazyIrModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "libraryAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "stubGenerator", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;)V", "dependencies", "", "contains", "", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "descriptorFinder", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinderImpl;", "tryDeserializeIrSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializedSymbolNotFound", "", "declareIrSymbol", "", "symbol", "declareFieldStub", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "kind", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "getKind", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "ir.serialization.js"})
public final class JsLazyIrModuleDeserializer
extends IrModuleDeserializer {
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final DeclarationStubGenerator stubGenerator;
    @NotNull
    private final List<IrModuleDeserializer> dependencies;
    @NotNull
    private final DescriptorByIdSignatureFinderImpl descriptorFinder;
    @NotNull
    private final IrModuleFragment moduleFragment;
    @NotNull
    private final Collection<IrModuleDeserializer> moduleDependencies;

    public JsLazyIrModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinAbiVersion libraryAbiVersion, @NotNull IrBuiltIns builtIns, @NotNull DeclarationStubGenerator stubGenerator) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(libraryAbiVersion, "libraryAbiVersion");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(stubGenerator, "stubGenerator");
        super(moduleDescriptor, libraryAbiVersion);
        this.builtIns = builtIns;
        this.stubGenerator = stubGenerator;
        this.dependencies = CollectionsKt.emptyList();
        this.descriptorFinder = new DescriptorByIdSignatureFinderImpl(moduleDescriptor, JsManglerDesc.INSTANCE, null, 4, null);
        this.moduleFragment = new IrModuleFragmentImpl(moduleDescriptor);
        this.moduleDependencies = this.dependencies;
    }

    @Override
    public boolean contains(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        return true;
    }

    @Override
    @Nullable
    public IrSymbol tryDeserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        IrDeclaration irDeclaration;
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
        DeclarationDescriptor declarationDescriptor = this.descriptorFinder.findDescriptorBySignature(idSig);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor descriptor = declarationDescriptor;
        DeclarationStubGenerator $this$tryDeserializeIrSymbol_u24lambda_u240 = this.stubGenerator;
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[symbolKind.ordinal()]) {
            case 1: {
                irDeclaration = $this$tryDeserializeIrSymbol_u24lambda_u240.generateClassStub((ClassDescriptor)descriptor);
                break;
            }
            case 2: {
                irDeclaration = $this$tryDeserializeIrSymbol_u24lambda_u240.generatePropertyStub((PropertyDescriptor)descriptor);
                break;
            }
            case 3: {
                irDeclaration = DeclarationStubGenerator.generateFunctionStub$default($this$tryDeserializeIrSymbol_u24lambda_u240, (FunctionDescriptor)descriptor, false, 2, null);
                break;
            }
            case 4: {
                irDeclaration = $this$tryDeserializeIrSymbol_u24lambda_u240.generateConstructorStub((ClassConstructorDescriptor)descriptor);
                break;
            }
            case 5: {
                irDeclaration = $this$tryDeserializeIrSymbol_u24lambda_u240.generateEnumEntryStub((ClassDescriptor)descriptor);
                break;
            }
            case 6: {
                irDeclaration = $this$tryDeserializeIrSymbol_u24lambda_u240.generateTypeAliasStub((TypeAliasDescriptor)descriptor);
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected type " + (Object)((Object)symbolKind) + " for sig " + idSig).toString());
            }
        }
        IrDeclaration declaration = irDeclaration;
        return ((IrSymbolOwner)declaration).getSymbol();
    }

    @Override
    @NotNull
    public Void deserializedSymbolNotFound(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        throw new IllegalStateException(("No descriptor found for " + idSig).toString());
    }

    @Override
    public void declareIrSymbol(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        IrDeclaration irDeclaration = symbol instanceof IrFieldSymbol ? (IrDeclaration)this.declareFieldStub((IrFieldSymbol)symbol) : this.stubGenerator.generateMemberStub(symbol.getDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IrField declareFieldStub(IrFieldSymbol symbol) {
        IrField irField;
        DeclarationStubGenerator $this$declareFieldStub_u24lambda_u240 = this.stubGenerator;
        boolean bl = false;
        boolean old = this.stubGenerator.getUnboundSymbolGeneration();
        try {
            this.stubGenerator.setUnboundSymbolGeneration(true);
            irField = $this$declareFieldStub_u24lambda_u240.generateFieldStub((PropertyDescriptor)symbol.getDescriptor());
        }
        finally {
            this.stubGenerator.setUnboundSymbolGeneration(old);
        }
        return irField;
    }

    @Override
    @NotNull
    public IrModuleFragment getModuleFragment() {
        return this.moduleFragment;
    }

    @Override
    @NotNull
    public Collection<IrModuleDeserializer> getModuleDependencies() {
        return this.moduleDependencies;
    }

    @Override
    @NotNull
    public IrModuleDeserializerKind getKind() {
        return IrModuleDeserializerKind.SYNTHETIC;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BinarySymbolData.SymbolKind.values().length];
            try {
                nArray[BinarySymbolData.SymbolKind.CLASS_SYMBOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.PROPERTY_SYMBOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.FUNCTION_SYMBOL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

