/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.model.FlexibleTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001c\u0010\u000b\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001c\u0010\f\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/types/AbstractStrictEqualityTypeChecker;", "", "<init>", "()V", "strictEqualTypes", "", "context", "Lorg/jetbrains/kotlin/types/model/TypeSystemContext;", "a", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "b", "strictEqualTypesInternal", "strictEqualRigidTypes", "Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;", "compiler.common"})
public final class AbstractStrictEqualityTypeChecker {
    @NotNull
    public static final AbstractStrictEqualityTypeChecker INSTANCE = new AbstractStrictEqualityTypeChecker();

    private AbstractStrictEqualityTypeChecker() {
    }

    public final boolean strictEqualTypes(@NotNull TypeSystemContext context2, @NotNull KotlinTypeMarker a2, @NotNull KotlinTypeMarker b2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        return this.strictEqualTypesInternal(context2, a2, b2);
    }

    private final boolean strictEqualTypesInternal(TypeSystemContext $this$strictEqualTypesInternal, KotlinTypeMarker a2, KotlinTypeMarker b2) {
        if (a2 == b2) {
            return true;
        }
        RigidTypeMarker simpleA = $this$strictEqualTypesInternal.asRigidType(a2);
        RigidTypeMarker simpleB = $this$strictEqualTypesInternal.asRigidType(b2);
        if (simpleA != null && simpleB != null) {
            return this.strictEqualRigidTypes($this$strictEqualTypesInternal, simpleA, simpleB);
        }
        FlexibleTypeMarker flexibleA = $this$strictEqualTypesInternal.asFlexibleType(a2);
        FlexibleTypeMarker flexibleB = $this$strictEqualTypesInternal.asFlexibleType(b2);
        if (flexibleA != null && flexibleB != null) {
            return this.strictEqualRigidTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.lowerBound(flexibleA), $this$strictEqualTypesInternal.lowerBound(flexibleB)) && this.strictEqualRigidTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.upperBound(flexibleA), $this$strictEqualTypesInternal.upperBound(flexibleB));
        }
        return false;
    }

    private final boolean strictEqualRigidTypes(TypeSystemContext $this$strictEqualRigidTypes, RigidTypeMarker a2, RigidTypeMarker b2) {
        if ($this$strictEqualRigidTypes.argumentsCount(a2) != $this$strictEqualRigidTypes.argumentsCount(b2) || $this$strictEqualRigidTypes.isMarkedNullable(a2) != $this$strictEqualRigidTypes.isMarkedNullable(b2) || $this$strictEqualRigidTypes.isDefinitelyNotNullType(a2) != $this$strictEqualRigidTypes.isDefinitelyNotNullType(b2) || !$this$strictEqualRigidTypes.areEqualTypeConstructors($this$strictEqualRigidTypes.typeConstructor(a2), $this$strictEqualRigidTypes.typeConstructor(b2))) {
            return false;
        }
        if ($this$strictEqualRigidTypes.identicalArguments(a2, b2)) {
            return true;
        }
        int n2 = $this$strictEqualRigidTypes.argumentsCount(a2);
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeArgumentMarker aArg = $this$strictEqualRigidTypes.getArgument(a2, i2);
            TypeArgumentMarker bArg = $this$strictEqualRigidTypes.getArgument(b2, i2);
            if ($this$strictEqualRigidTypes.isStarProjection(aArg) != $this$strictEqualRigidTypes.isStarProjection(bArg)) {
                return false;
            }
            if ($this$strictEqualRigidTypes.isStarProjection(aArg)) continue;
            if ($this$strictEqualRigidTypes.getVariance(aArg) != $this$strictEqualRigidTypes.getVariance(bArg)) {
                return false;
            }
            KotlinTypeMarker kotlinTypeMarker = $this$strictEqualRigidTypes.getType(aArg);
            Intrinsics.checkNotNull(kotlinTypeMarker);
            KotlinTypeMarker kotlinTypeMarker2 = $this$strictEqualRigidTypes.getType(bArg);
            Intrinsics.checkNotNull(kotlinTypeMarker2);
            if (this.strictEqualTypesInternal($this$strictEqualRigidTypes, kotlinTypeMarker, kotlinTypeMarker2)) continue;
            return false;
        }
        return true;
    }
}

