/*
 * Decompiled with CFR 0.152.
 */
package org.jline.keymap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.jline.terminal.Terminal;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;

public class KeyMap<T> {
    private Object[] mapping = new Object[128];
    private T anotherKey = null;
    private T unicode;
    private T nomatch;
    private long ambiguousTimeout = 1000L;
    public static final Comparator<String> KEYSEQ_COMPARATOR = (s1, s2) -> {
        int len1 = s1.length();
        int len2 = s2.length();
        int lim = Math.min(len1, len2);
        for (int k2 = 0; k2 < lim; ++k2) {
            char c2;
            char c1 = s1.charAt(k2);
            if (c1 == (c2 = s2.charAt(k2))) continue;
            int l2 = len1 - len2;
            return l2 != 0 ? l2 : c1 - c2;
        }
        return len1 - len2;
    };

    public static String translate(String str) {
        char c2;
        if (!(str.isEmpty() || (c2 = str.charAt(0)) != '\'' && c2 != '\"' || str.charAt(str.length() - 1) != c2)) {
            str = str.substring(1, str.length() - 1);
        }
        StringBuilder keySeq = new StringBuilder();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            int c3;
            block25: {
                block24: {
                    c3 = str.charAt(i2);
                    if (c3 != 92) break block24;
                    if (++i2 >= str.length()) break;
                    c3 = str.charAt(i2);
                    block0 : switch (c3) {
                        case 97: {
                            c3 = 7;
                            break;
                        }
                        case 98: {
                            c3 = 8;
                            break;
                        }
                        case 100: {
                            c3 = 127;
                            break;
                        }
                        case 69: 
                        case 101: {
                            c3 = 27;
                            break;
                        }
                        case 102: {
                            c3 = 12;
                            break;
                        }
                        case 110: {
                            c3 = 10;
                            break;
                        }
                        case 114: {
                            c3 = 13;
                            break;
                        }
                        case 116: {
                            c3 = 9;
                            break;
                        }
                        case 118: {
                            c3 = 11;
                            break;
                        }
                        case 92: {
                            c3 = 92;
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int k2;
                            int j2;
                            c3 = 0;
                            for (j2 = 0; j2 < 3 && i2 < str.length() && (k2 = Character.digit(str.charAt(i2), 8)) >= 0; ++j2, ++i2) {
                                c3 = (char)(c3 * 8 + k2);
                            }
                            --i2;
                            c3 = (char)(c3 & 0xFF);
                            break;
                        }
                        case 120: {
                            int k2;
                            int j2;
                            ++i2;
                            c3 = 0;
                            for (j2 = 0; j2 < 2 && i2 < str.length() && (k2 = Character.digit(str.charAt(i2), 16)) >= 0; ++j2, ++i2) {
                                c3 = (char)(c3 * 16 + k2);
                            }
                            --i2;
                            c3 = (char)(c3 & 0xFF);
                            break;
                        }
                        case 117: {
                            int k2;
                            ++i2;
                            c3 = 0;
                            int j2 = 0;
                            while (j2 < 4) {
                                if (i2 >= str.length() || (k2 = Character.digit(str.charAt(i2), 16)) < 0) break block0;
                                c3 = (char)(c3 * 16 + k2);
                                ++j2;
                                ++i2;
                            }
                            break block25;
                        }
                        case 67: {
                            if (++i2 >= str.length()) break;
                            c3 = str.charAt(i2);
                            if (c3 == 45) {
                                if (++i2 >= str.length()) break;
                                c3 = str.charAt(i2);
                            }
                            c3 = (char)(c3 == 63 ? 127 : (char)(Character.toUpperCase((char)c3) & 0x1F));
                        }
                    }
                    break block25;
                }
                if (c3 == 94) {
                    if (++i2 >= str.length()) break;
                    c3 = str.charAt(i2);
                    if (c3 != 94) {
                        c3 = (char)(c3 == 63 ? 127 : (char)(Character.toUpperCase((char)c3) & 0x1F));
                    }
                }
            }
            keySeq.append((char)c3);
        }
        return keySeq.toString();
    }

    public static Collection<String> range(String range) {
        char c1;
        char c0;
        String pfx;
        String[] keys2 = range.split("-");
        if (keys2.length != 2) {
            return null;
        }
        keys2[0] = KeyMap.translate(keys2[0]);
        keys2[1] = KeyMap.translate(keys2[1]);
        if (keys2[0].length() != keys2[1].length()) {
            return null;
        }
        if (keys2[0].length() > 1) {
            pfx = keys2[0].substring(0, keys2[0].length() - 1);
            if (!keys2[1].startsWith(pfx)) {
                return null;
            }
        } else {
            pfx = "";
        }
        if ((c0 = keys2[0].charAt(keys2[0].length() - 1)) > (c1 = keys2[1].charAt(keys2[1].length() - 1))) {
            return null;
        }
        ArrayList<String> seqs = new ArrayList<String>();
        for (char c2 = c0; c2 <= c1; c2 = (char)(c2 + '\u0001')) {
            seqs.add(pfx + c2);
        }
        return seqs;
    }

    public static String esc() {
        return "\u001b";
    }

    public static String alt(char c2) {
        return "\u001b" + c2;
    }

    public static String alt(String c2) {
        return "\u001b" + c2;
    }

    public static String del() {
        return "\u007f";
    }

    public static String ctrl(char key) {
        return key == '?' ? KeyMap.del() : Character.toString((char)(Character.toUpperCase(key) & 0x1F));
    }

    public static String key(Terminal terminal, InfoCmp.Capability capability) {
        return Curses.tputs(terminal.getStringCapability(capability), new Object[0]);
    }

    public T getUnicode() {
        return this.unicode;
    }

    public void setUnicode(T unicode) {
        this.unicode = unicode;
    }

    public T getNomatch() {
        return this.nomatch;
    }

    public long getAmbiguousTimeout() {
        return this.ambiguousTimeout;
    }

    public void setAmbiguousTimeout(long ambiguousTimeout) {
        this.ambiguousTimeout = ambiguousTimeout;
    }

    public T getBound(CharSequence keySeq, int[] remaining) {
        remaining[0] = -1;
        if (keySeq != null && keySeq.length() > 0) {
            char c2 = keySeq.charAt(0);
            if (c2 >= this.mapping.length) {
                remaining[0] = Character.codePointCount(keySeq, 0, keySeq.length());
                return null;
            }
            if (this.mapping[c2] instanceof KeyMap) {
                CharSequence sub = keySeq.subSequence(1, keySeq.length());
                return ((KeyMap)this.mapping[c2]).getBound(sub, remaining);
            }
            if (this.mapping[c2] != null) {
                remaining[0] = keySeq.length() - 1;
                return (T)this.mapping[c2];
            }
            remaining[0] = keySeq.length();
            return this.anotherKey;
        }
        return this.anotherKey;
    }

    public T getBound(CharSequence keySeq) {
        int[] remaining = new int[1];
        T res2 = this.getBound(keySeq, remaining);
        return (T)(remaining[0] <= 0 ? res2 : null);
    }

    public void bind(T function2, CharSequence ... keySeqs) {
        for (CharSequence keySeq : keySeqs) {
            this.bind(function2, keySeq);
        }
    }

    public void bind(T function2, Iterable<? extends CharSequence> keySeqs) {
        for (CharSequence charSequence : keySeqs) {
            this.bind(function2, charSequence);
        }
    }

    public void bind(T function2, CharSequence keySeq) {
        if (keySeq != null) {
            if (function2 == null) {
                this.unbind(keySeq);
            } else {
                KeyMap.bind(this, keySeq, function2, false);
            }
        }
    }

    public void unbind(CharSequence keySeq) {
        if (keySeq != null) {
            KeyMap.unbind(this, keySeq);
        }
    }

    private static <T> T unbind(KeyMap<T> map, CharSequence keySeq) {
        KeyMap prev = null;
        if (keySeq != null && keySeq.length() > 0) {
            for (int i2 = 0; i2 < keySeq.length() - 1; ++i2) {
                char c2 = keySeq.charAt(i2);
                if (c2 > map.mapping.length) {
                    return null;
                }
                if (!(map.mapping[c2] instanceof KeyMap)) {
                    return null;
                }
                prev = map;
                map = (KeyMap)map.mapping[c2];
            }
            char c3 = keySeq.charAt(keySeq.length() - 1);
            if (c3 > map.mapping.length) {
                return null;
            }
            if (map.mapping[c3] instanceof KeyMap) {
                KeyMap sub = (KeyMap)map.mapping[c3];
                T res2 = sub.anotherKey;
                sub.anotherKey = null;
                return res2;
            }
            Object res3 = map.mapping[c3];
            map.mapping[c3] = null;
            int nb = 0;
            for (int i3 = 0; i3 < map.mapping.length; ++i3) {
                if (map.mapping[i3] == null) continue;
                ++nb;
            }
            if (nb == 0 && prev != null) {
                prev.mapping[keySeq.charAt((int)(keySeq.length() - 2))] = map.anotherKey;
            }
            return (T)res3;
        }
        return null;
    }

    private static <T> void bind(KeyMap<T> map, CharSequence keySeq, T function2, boolean onlyIfNotBound) {
        if (keySeq != null && keySeq.length() > 0) {
            for (int i2 = 0; i2 < keySeq.length(); ++i2) {
                char c2 = keySeq.charAt(i2);
                if (c2 >= map.mapping.length) {
                    return;
                }
                if (i2 < keySeq.length() - 1) {
                    if (!(map.mapping[c2] instanceof KeyMap)) {
                        KeyMap<T> m2 = new KeyMap<T>();
                        m2.anotherKey = map.mapping[c2];
                        map.mapping[c2] = m2;
                    }
                    map = (KeyMap)map.mapping[c2];
                    continue;
                }
                if (map.mapping[c2] instanceof KeyMap) {
                    ((KeyMap)map.mapping[c2]).anotherKey = function2;
                    continue;
                }
                Object op = map.mapping[c2];
                if (onlyIfNotBound && op != null) continue;
                map.mapping[c2] = function2;
            }
        }
    }
}

