package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHealthCheckTemplateAttribute invokes the alb.GetHealthCheckTemplateAttribute API synchronously
func (client *Client) GetHealthCheckTemplateAttribute(request *GetHealthCheckTemplateAttributeRequest) (response *GetHealthCheckTemplateAttributeResponse, err error) {
	response = CreateGetHealthCheckTemplateAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// GetHealthCheckTemplateAttributeWithChan invokes the alb.GetHealthCheckTemplateAttribute API asynchronously
func (client *Client) GetHealthCheckTemplateAttributeWithChan(request *GetHealthCheckTemplateAttributeRequest) (<-chan *GetHealthCheckTemplateAttributeResponse, <-chan error) {
	responseChan := make(chan *GetHealthCheckTemplateAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHealthCheckTemplateAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHealthCheckTemplateAttributeWithCallback invokes the alb.GetHealthCheckTemplateAttribute API asynchronously
func (client *Client) GetHealthCheckTemplateAttributeWithCallback(request *GetHealthCheckTemplateAttributeRequest, callback func(response *GetHealthCheckTemplateAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHealthCheckTemplateAttributeResponse
		var err error
		defer close(result)
		response, err = client.GetHealthCheckTemplateAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHealthCheckTemplateAttributeRequest is the request struct for api GetHealthCheckTemplateAttribute
type GetHealthCheckTemplateAttributeRequest struct {
	*requests.RpcRequest
	HealthCheckTemplateId string `position:"Query" name:"HealthCheckTemplateId"`
}

// GetHealthCheckTemplateAttributeResponse is the response struct for api GetHealthCheckTemplateAttribute
type GetHealthCheckTemplateAttributeResponse struct {
	*responses.BaseResponse
	HealthCheckConnectPort         int      `json:"HealthCheckConnectPort" xml:"HealthCheckConnectPort"`
	HealthCheckHost                string   `json:"HealthCheckHost" xml:"HealthCheckHost"`
	HealthCheckHttpVersion         string   `json:"HealthCheckHttpVersion" xml:"HealthCheckHttpVersion"`
	HealthCheckTemplateId          string   `json:"HealthCheckTemplateId" xml:"HealthCheckTemplateId"`
	HealthCheckInterval            int      `json:"HealthCheckInterval" xml:"HealthCheckInterval"`
	HealthCheckMethod              string   `json:"HealthCheckMethod" xml:"HealthCheckMethod"`
	HealthCheckPath                string   `json:"HealthCheckPath" xml:"HealthCheckPath"`
	HealthCheckProtocol            string   `json:"HealthCheckProtocol" xml:"HealthCheckProtocol"`
	HealthCheckTemplateName        string   `json:"HealthCheckTemplateName" xml:"HealthCheckTemplateName"`
	HealthCheckTimeout             int      `json:"HealthCheckTimeout" xml:"HealthCheckTimeout"`
	HealthyThreshold               int      `json:"HealthyThreshold" xml:"HealthyThreshold"`
	RequestId                      string   `json:"RequestId" xml:"RequestId"`
	UnhealthyThreshold             int      `json:"UnhealthyThreshold" xml:"UnhealthyThreshold"`
	HealthCheckTcpFastCloseEnabled bool     `json:"HealthCheckTcpFastCloseEnabled" xml:"HealthCheckTcpFastCloseEnabled"`
	ServiceManagedEnabled          bool     `json:"ServiceManagedEnabled" xml:"ServiceManagedEnabled"`
	ServiceManagedMode             string   `json:"ServiceManagedMode" xml:"ServiceManagedMode"`
	HealthCheckHttpCodes           []string `json:"HealthCheckHttpCodes" xml:"HealthCheckHttpCodes"`
	HealthCheckCodes               []string `json:"HealthCheckCodes" xml:"HealthCheckCodes"`
}

// CreateGetHealthCheckTemplateAttributeRequest creates a request to invoke GetHealthCheckTemplateAttribute API
func CreateGetHealthCheckTemplateAttributeRequest() (request *GetHealthCheckTemplateAttributeRequest) {
	request = &GetHealthCheckTemplateAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "GetHealthCheckTemplateAttribute", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetHealthCheckTemplateAttributeResponse creates a response to parse from GetHealthCheckTemplateAttribute response
func CreateGetHealthCheckTemplateAttributeResponse() (response *GetHealthCheckTemplateAttributeResponse) {
	response = &GetHealthCheckTemplateAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
