package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DoubleCallSeat invokes the dyvmsapi.DoubleCallSeat API synchronously
func (client *Client) DoubleCallSeat(request *DoubleCallSeatRequest) (response *DoubleCallSeatResponse, err error) {
	response = CreateDoubleCallSeatResponse()
	err = client.DoAction(request, response)
	return
}

// DoubleCallSeatWithChan invokes the dyvmsapi.DoubleCallSeat API asynchronously
func (client *Client) DoubleCallSeatWithChan(request *DoubleCallSeatRequest) (<-chan *DoubleCallSeatResponse, <-chan error) {
	responseChan := make(chan *DoubleCallSeatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DoubleCallSeat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DoubleCallSeatWithCallback invokes the dyvmsapi.DoubleCallSeat API asynchronously
func (client *Client) DoubleCallSeatWithCallback(request *DoubleCallSeatRequest, callback func(response *DoubleCallSeatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DoubleCallSeatResponse
		var err error
		defer close(result)
		response, err = client.DoubleCallSeat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DoubleCallSeatRequest is the request struct for api DoubleCallSeat
type DoubleCallSeatRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CallerShowNumber     string           `position:"Query" name:"CallerShowNumber"`
	SessionTimeout       requests.Integer `position:"Query" name:"SessionTimeout"`
	CalledNumber         string           `position:"Query" name:"CalledNumber"`
	VoiceCode            string           `position:"Query" name:"VoiceCode"`
	CalledShowNumber     string           `position:"Query" name:"CalledShowNumber"`
	AsrFlag              requests.Boolean `position:"Query" name:"AsrFlag"`
	CallType             string           `position:"Query" name:"CallType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	RecordFlag           requests.Boolean `position:"Query" name:"RecordFlag"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RecordPoint          requests.Integer `position:"Query" name:"RecordPoint"`
	OutId                string           `position:"Query" name:"OutId"`
	AsrModelId           string           `position:"Query" name:"AsrModelId"`
	CallerNumber         string           `position:"Query" name:"CallerNumber"`
}

// DoubleCallSeatResponse is the response struct for api DoubleCallSeat
type DoubleCallSeatResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CallId    string `json:"CallId" xml:"CallId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDoubleCallSeatRequest creates a request to invoke DoubleCallSeat API
func CreateDoubleCallSeatRequest() (request *DoubleCallSeatRequest) {
	request = &DoubleCallSeatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "DoubleCallSeat", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDoubleCallSeatResponse creates a response to parse from DoubleCallSeat response
func CreateDoubleCallSeatResponse() (response *DoubleCallSeatResponse) {
	response = &DoubleCallSeatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
