package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRestoreFullDetails invokes the hbase.DescribeRestoreFullDetails API synchronously
func (client *Client) DescribeRestoreFullDetails(request *DescribeRestoreFullDetailsRequest) (response *DescribeRestoreFullDetailsResponse, err error) {
	response = CreateDescribeRestoreFullDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRestoreFullDetailsWithChan invokes the hbase.DescribeRestoreFullDetails API asynchronously
func (client *Client) DescribeRestoreFullDetailsWithChan(request *DescribeRestoreFullDetailsRequest) (<-chan *DescribeRestoreFullDetailsResponse, <-chan error) {
	responseChan := make(chan *DescribeRestoreFullDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRestoreFullDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRestoreFullDetailsWithCallback invokes the hbase.DescribeRestoreFullDetails API asynchronously
func (client *Client) DescribeRestoreFullDetailsWithCallback(request *DescribeRestoreFullDetailsRequest, callback func(response *DescribeRestoreFullDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRestoreFullDetailsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRestoreFullDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRestoreFullDetailsRequest is the request struct for api DescribeRestoreFullDetails
type DescribeRestoreFullDetailsRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	RestoreRecordId string           `position:"Query" name:"RestoreRecordId"`
}

// DescribeRestoreFullDetailsResponse is the response struct for api DescribeRestoreFullDetails
type DescribeRestoreFullDetailsResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	RestoreFull RestoreFull `json:"RestoreFull" xml:"RestoreFull"`
}

// CreateDescribeRestoreFullDetailsRequest creates a request to invoke DescribeRestoreFullDetails API
func CreateDescribeRestoreFullDetailsRequest() (request *DescribeRestoreFullDetailsRequest) {
	request = &DescribeRestoreFullDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeRestoreFullDetails", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRestoreFullDetailsResponse creates a response to parse from DescribeRestoreFullDetails response
func CreateDescribeRestoreFullDetailsResponse() (response *DescribeRestoreFullDetailsResponse) {
	response = &DescribeRestoreFullDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
